/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSConsole.h"

#include <wtf/GetPtr.h>

#include "Console.h"

#include <kjs/Error.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSConsole)

/* Hash table for prototype */

static const HashTableValue JSConsolePrototypeTableValues[17] =
{
    { "debug", DontDelete|Function, (intptr_t)jsConsolePrototypeFunctionDebug, (intptr_t)0 },
    { "error", DontDelete|Function, (intptr_t)jsConsolePrototypeFunctionError, (intptr_t)0 },
    { "info", DontDelete|Function, (intptr_t)jsConsolePrototypeFunctionInfo, (intptr_t)0 },
    { "log", DontDelete|Function, (intptr_t)jsConsolePrototypeFunctionLog, (intptr_t)0 },
    { "warn", DontDelete|Function, (intptr_t)jsConsolePrototypeFunctionWarn, (intptr_t)0 },
    { "dir", DontDelete|Function, (intptr_t)jsConsolePrototypeFunctionDir, (intptr_t)0 },
    { "dirxml", DontDelete|Function, (intptr_t)jsConsolePrototypeFunctionDirxml, (intptr_t)0 },
    { "trace", DontDelete|Function, (intptr_t)jsConsolePrototypeFunctionTrace, (intptr_t)0 },
    { "assert", DontDelete|Function, (intptr_t)jsConsolePrototypeFunctionAssert, (intptr_t)1 },
    { "count", DontDelete|Function, (intptr_t)jsConsolePrototypeFunctionCount, (intptr_t)0 },
    { "profile", DontDelete|Function, (intptr_t)jsConsolePrototypeFunctionProfile, (intptr_t)1 },
    { "profileEnd", DontDelete|Function, (intptr_t)jsConsolePrototypeFunctionProfileEnd, (intptr_t)0 },
    { "time", DontDelete|Function, (intptr_t)jsConsolePrototypeFunctionTime, (intptr_t)1 },
    { "timeEnd", DontDelete|Function, (intptr_t)jsConsolePrototypeFunctionTimeEnd, (intptr_t)0 },
    { "group", DontDelete|Function, (intptr_t)jsConsolePrototypeFunctionGroup, (intptr_t)0 },
    { "groupEnd", DontDelete|Function, (intptr_t)jsConsolePrototypeFunctionGroupEnd, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSConsolePrototypeTable = { 511, JSConsolePrototypeTableValues, 0 };

const ClassInfo JSConsolePrototype::s_info = { "ConsolePrototype", 0, &JSConsolePrototypeTable, 0 };

JSObject* JSConsolePrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSConsole>(exec);
}

bool JSConsolePrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSConsolePrototypeTable, this, propertyName, slot);
}

const ClassInfo JSConsole::s_info = { "Console", 0, 0 , 0 };

JSConsole::JSConsole(PassRefPtr<StructureID> structure, PassRefPtr<Console> impl)
    : DOMObject(structure)
    , m_impl(impl)
{
}

JSConsole::~JSConsole()
{
    forgetDOMObject(*Heap::heap(this)->globalData(), m_impl.get());

}

JSObject* JSConsole::createPrototype(ExecState* exec)
{
    return new (exec) JSConsolePrototype(JSConsolePrototype::createStructureID(exec->lexicalGlobalObject()->objectPrototype()));
}

JSValue* jsConsolePrototypeFunctionDebug(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSConsole::s_info))
        return throwError(exec, TypeError);
    JSConsole* castedThisObj = static_cast<JSConsole*>(thisValue);
    return castedThisObj->debug(exec, args);
}

JSValue* jsConsolePrototypeFunctionError(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSConsole::s_info))
        return throwError(exec, TypeError);
    JSConsole* castedThisObj = static_cast<JSConsole*>(thisValue);
    return castedThisObj->error(exec, args);
}

JSValue* jsConsolePrototypeFunctionInfo(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSConsole::s_info))
        return throwError(exec, TypeError);
    JSConsole* castedThisObj = static_cast<JSConsole*>(thisValue);
    return castedThisObj->info(exec, args);
}

JSValue* jsConsolePrototypeFunctionLog(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSConsole::s_info))
        return throwError(exec, TypeError);
    JSConsole* castedThisObj = static_cast<JSConsole*>(thisValue);
    return castedThisObj->log(exec, args);
}

JSValue* jsConsolePrototypeFunctionWarn(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSConsole::s_info))
        return throwError(exec, TypeError);
    JSConsole* castedThisObj = static_cast<JSConsole*>(thisValue);
    return castedThisObj->warn(exec, args);
}

JSValue* jsConsolePrototypeFunctionDir(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSConsole::s_info))
        return throwError(exec, TypeError);
    JSConsole* castedThisObj = static_cast<JSConsole*>(thisValue);
    return castedThisObj->dir(exec, args);
}

JSValue* jsConsolePrototypeFunctionDirxml(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSConsole::s_info))
        return throwError(exec, TypeError);
    JSConsole* castedThisObj = static_cast<JSConsole*>(thisValue);
    return castedThisObj->dirxml(exec, args);
}

JSValue* jsConsolePrototypeFunctionTrace(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSConsole::s_info))
        return throwError(exec, TypeError);
    JSConsole* castedThisObj = static_cast<JSConsole*>(thisValue);
    return castedThisObj->trace(exec, args);
}

JSValue* jsConsolePrototypeFunctionAssert(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSConsole::s_info))
        return throwError(exec, TypeError);
    JSConsole* castedThisObj = static_cast<JSConsole*>(thisValue);
    return castedThisObj->assertCondition(exec, args);
}

JSValue* jsConsolePrototypeFunctionCount(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSConsole::s_info))
        return throwError(exec, TypeError);
    JSConsole* castedThisObj = static_cast<JSConsole*>(thisValue);
    return castedThisObj->count(exec, args);
}

JSValue* jsConsolePrototypeFunctionProfile(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSConsole::s_info))
        return throwError(exec, TypeError);
    JSConsole* castedThisObj = static_cast<JSConsole*>(thisValue);
    return castedThisObj->profile(exec, args);
}

JSValue* jsConsolePrototypeFunctionProfileEnd(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSConsole::s_info))
        return throwError(exec, TypeError);
    JSConsole* castedThisObj = static_cast<JSConsole*>(thisValue);
    return castedThisObj->profileEnd(exec, args);
}

JSValue* jsConsolePrototypeFunctionTime(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSConsole::s_info))
        return throwError(exec, TypeError);
    JSConsole* castedThisObj = static_cast<JSConsole*>(thisValue);
    Console* imp = static_cast<Console*>(castedThisObj->impl());
    const UString& title = valueToStringWithUndefinedOrNullCheck(exec, args.at(exec, 0));

    imp->time(title);
    return jsUndefined();
}

JSValue* jsConsolePrototypeFunctionTimeEnd(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSConsole::s_info))
        return throwError(exec, TypeError);
    JSConsole* castedThisObj = static_cast<JSConsole*>(thisValue);
    return castedThisObj->timeEnd(exec, args);
}

JSValue* jsConsolePrototypeFunctionGroup(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSConsole::s_info))
        return throwError(exec, TypeError);
    JSConsole* castedThisObj = static_cast<JSConsole*>(thisValue);
    return castedThisObj->group(exec, args);
}

JSValue* jsConsolePrototypeFunctionGroupEnd(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSConsole::s_info))
        return throwError(exec, TypeError);
    JSConsole* castedThisObj = static_cast<JSConsole*>(thisValue);
    Console* imp = static_cast<Console*>(castedThisObj->impl());

    imp->groupEnd();
    return jsUndefined();
}

JSC::JSValue* toJS(JSC::ExecState* exec, Console* object)
{
    return getDOMObjectWrapper<JSConsole>(exec, object);
}
Console* toConsole(JSC::JSValue* val)
{
    return val->isObject(&JSConsole::s_info) ? static_cast<JSConsole*>(val)->impl() : 0;
}

}
