/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSCSSVariablesDeclaration.h"

#include <wtf/GetPtr.h>

#include <kjs/PropertyNameArray.h>
#include "CSSRule.h"
#include "CSSVariablesDeclaration.h"
#include "JSCSSRule.h"
#include "KURL.h"

#include <kjs/Error.h>
#include <kjs/JSNumberCell.h>
#include <kjs/JSString.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSCSSVariablesDeclaration)

/* Hash table */

static const HashTableValue JSCSSVariablesDeclarationTableValues[5] =
{
    { "cssText", DontDelete, (intptr_t)jsCSSVariablesDeclarationCssText, (intptr_t)setJSCSSVariablesDeclarationCssText },
    { "length", DontDelete|ReadOnly, (intptr_t)jsCSSVariablesDeclarationLength, (intptr_t)0 },
    { "parentRule", DontDelete|ReadOnly, (intptr_t)jsCSSVariablesDeclarationParentRule, (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsCSSVariablesDeclarationConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSCSSVariablesDeclarationTable = { 63, JSCSSVariablesDeclarationTableValues, 0 };

/* Hash table for constructor */

static const HashTableValue JSCSSVariablesDeclarationConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSCSSVariablesDeclarationConstructorTable = { 0, JSCSSVariablesDeclarationConstructorTableValues, 0 };

class JSCSSVariablesDeclarationConstructor : public DOMObject {
public:
    JSCSSVariablesDeclarationConstructor(ExecState* exec)
        : DOMObject(JSCSSVariablesDeclarationConstructor::createStructureID(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSCSSVariablesDeclarationPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<StructureID> createStructureID(JSValue* proto) 
    { 
        return StructureID::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSCSSVariablesDeclarationConstructor::s_info = { "CSSVariablesDeclarationConstructor", 0, &JSCSSVariablesDeclarationConstructorTable, 0 };

bool JSCSSVariablesDeclarationConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCSSVariablesDeclarationConstructor, DOMObject>(exec, &JSCSSVariablesDeclarationConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSCSSVariablesDeclarationPrototypeTableValues[5] =
{
    { "getVariableValue", DontDelete|Function, (intptr_t)jsCSSVariablesDeclarationPrototypeFunctionGetVariableValue, (intptr_t)1 },
    { "removeVariable", DontDelete|Function, (intptr_t)jsCSSVariablesDeclarationPrototypeFunctionRemoveVariable, (intptr_t)1 },
    { "setVariable", DontDelete|Function, (intptr_t)jsCSSVariablesDeclarationPrototypeFunctionSetVariable, (intptr_t)2 },
    { "item", DontDelete|Function, (intptr_t)jsCSSVariablesDeclarationPrototypeFunctionItem, (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static const HashTable JSCSSVariablesDeclarationPrototypeTable = { 15, JSCSSVariablesDeclarationPrototypeTableValues, 0 };

const ClassInfo JSCSSVariablesDeclarationPrototype::s_info = { "CSSVariablesDeclarationPrototype", 0, &JSCSSVariablesDeclarationPrototypeTable, 0 };

JSObject* JSCSSVariablesDeclarationPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSCSSVariablesDeclaration>(exec);
}

bool JSCSSVariablesDeclarationPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSCSSVariablesDeclarationPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSCSSVariablesDeclaration::s_info = { "CSSVariablesDeclaration", 0, &JSCSSVariablesDeclarationTable , 0 };

JSCSSVariablesDeclaration::JSCSSVariablesDeclaration(PassRefPtr<StructureID> structure, PassRefPtr<CSSVariablesDeclaration> impl)
    : DOMObject(structure)
    , m_impl(impl)
{
}

JSCSSVariablesDeclaration::~JSCSSVariablesDeclaration()
{
    forgetDOMObject(*Heap::heap(this)->globalData(), m_impl.get());

}

JSObject* JSCSSVariablesDeclaration::createPrototype(ExecState* exec)
{
    return new (exec) JSCSSVariablesDeclarationPrototype(JSCSSVariablesDeclarationPrototype::createStructureID(exec->lexicalGlobalObject()->objectPrototype()));
}

bool JSCSSVariablesDeclaration::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    const HashEntry* entry = JSCSSVariablesDeclarationTable.entry(exec, propertyName);
    if (entry) {
        slot.setCustom(this, entry->propertyGetter());
        return true;
    }
    bool ok;
    unsigned index = propertyName.toUInt32(&ok, false);
    if (ok && index < static_cast<CSSVariablesDeclaration*>(impl())->length()) {
        slot.setCustomIndex(this, index, indexGetter);
        return true;
    }
    return getStaticValueSlot<JSCSSVariablesDeclaration, Base>(exec, &JSCSSVariablesDeclarationTable, this, propertyName, slot);
}

bool JSCSSVariablesDeclaration::getOwnPropertySlot(ExecState* exec, unsigned propertyName, PropertySlot& slot)
{
    if (propertyName < static_cast<CSSVariablesDeclaration*>(impl())->length()) {
        slot.setCustomIndex(this, propertyName, indexGetter);
        return true;
    }
    return getOwnPropertySlot(exec, Identifier::from(exec, propertyName), slot);
}

JSValue* jsCSSVariablesDeclarationCssText(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    CSSVariablesDeclaration* imp = static_cast<CSSVariablesDeclaration*>(static_cast<JSCSSVariablesDeclaration*>(slot.slotBase())->impl());
    return jsString(exec, imp->cssText());
}

JSValue* jsCSSVariablesDeclarationLength(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    CSSVariablesDeclaration* imp = static_cast<CSSVariablesDeclaration*>(static_cast<JSCSSVariablesDeclaration*>(slot.slotBase())->impl());
    return jsNumber(exec, imp->length());
}

JSValue* jsCSSVariablesDeclarationParentRule(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    CSSVariablesDeclaration* imp = static_cast<CSSVariablesDeclaration*>(static_cast<JSCSSVariablesDeclaration*>(slot.slotBase())->impl());
    return toJS(exec, WTF::getPtr(imp->parentRule()));
}

JSValue* jsCSSVariablesDeclarationConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSCSSVariablesDeclaration*>(slot.slotBase())->getConstructor(exec);
}
void JSCSSVariablesDeclaration::put(ExecState* exec, const Identifier& propertyName, JSValue* value, PutPropertySlot& slot)
{
    lookupPut<JSCSSVariablesDeclaration, Base>(exec, propertyName, value, &JSCSSVariablesDeclarationTable, this, slot);
}

void setJSCSSVariablesDeclarationCssText(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    CSSVariablesDeclaration* imp = static_cast<CSSVariablesDeclaration*>(static_cast<JSCSSVariablesDeclaration*>(thisObject)->impl());
    imp->setCssText(value->toString(exec));
}

void JSCSSVariablesDeclaration::getPropertyNames(ExecState* exec, PropertyNameArray& propertyNames)
{
    for (unsigned i = 0; i < static_cast<CSSVariablesDeclaration*>(impl())->length(); ++i)
        propertyNames.add(Identifier::from(exec, i));
     Base::getPropertyNames(exec, propertyNames);
}

JSValue* JSCSSVariablesDeclaration::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSCSSVariablesDeclarationConstructor>(exec);
}

JSValue* jsCSSVariablesDeclarationPrototypeFunctionGetVariableValue(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCSSVariablesDeclaration::s_info))
        return throwError(exec, TypeError);
    JSCSSVariablesDeclaration* castedThisObj = static_cast<JSCSSVariablesDeclaration*>(thisValue);
    CSSVariablesDeclaration* imp = static_cast<CSSVariablesDeclaration*>(castedThisObj->impl());
    const UString& variableName = args.at(exec, 0)->toString(exec);


    JSC::JSValue* result = jsString(exec, imp->getVariableValue(variableName));
    return result;
}

JSValue* jsCSSVariablesDeclarationPrototypeFunctionRemoveVariable(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCSSVariablesDeclaration::s_info))
        return throwError(exec, TypeError);
    JSCSSVariablesDeclaration* castedThisObj = static_cast<JSCSSVariablesDeclaration*>(thisValue);
    CSSVariablesDeclaration* imp = static_cast<CSSVariablesDeclaration*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    const UString& variableName = args.at(exec, 0)->toString(exec);


    JSC::JSValue* result = jsString(exec, imp->removeVariable(variableName, ec));
    setDOMException(exec, ec);
    return result;
}

JSValue* jsCSSVariablesDeclarationPrototypeFunctionSetVariable(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCSSVariablesDeclaration::s_info))
        return throwError(exec, TypeError);
    JSCSSVariablesDeclaration* castedThisObj = static_cast<JSCSSVariablesDeclaration*>(thisValue);
    CSSVariablesDeclaration* imp = static_cast<CSSVariablesDeclaration*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    const UString& variableName = args.at(exec, 0)->toString(exec);
    const UString& value = args.at(exec, 1)->toString(exec);

    imp->setVariable(variableName, value, ec);
    setDOMException(exec, ec);
    return jsUndefined();
}

JSValue* jsCSSVariablesDeclarationPrototypeFunctionItem(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCSSVariablesDeclaration::s_info))
        return throwError(exec, TypeError);
    JSCSSVariablesDeclaration* castedThisObj = static_cast<JSCSSVariablesDeclaration*>(thisValue);
    CSSVariablesDeclaration* imp = static_cast<CSSVariablesDeclaration*>(castedThisObj->impl());
    unsigned index = args.at(exec, 0)->toInt32(exec);


    JSC::JSValue* result = jsString(exec, imp->item(index));
    return result;
}


JSValue* JSCSSVariablesDeclaration::indexGetter(ExecState* exec, const Identifier& propertyName, const PropertySlot& slot)
{
    JSCSSVariablesDeclaration* thisObj = static_cast<JSCSSVariablesDeclaration*>(slot.slotBase());
    return jsStringOrNull(exec, thisObj->impl()->item(slot.index()));
}
JSC::JSValue* toJS(JSC::ExecState* exec, CSSVariablesDeclaration* object)
{
    return getDOMObjectWrapper<JSCSSVariablesDeclaration>(exec, object);
}
CSSVariablesDeclaration* toCSSVariablesDeclaration(JSC::JSValue* val)
{
    return val->isObject(&JSCSSVariablesDeclaration::s_info) ? static_cast<JSCSSVariablesDeclaration*>(val)->impl() : 0;
}

}
