/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSCSSStyleSheet.h"

#include <wtf/GetPtr.h>

#include "CSSRule.h"
#include "CSSRuleList.h"
#include "CSSStyleSheet.h"
#include "JSCSSRule.h"
#include "JSCSSRuleList.h"

#include <kjs/Error.h>
#include <kjs/JSNumberCell.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSCSSStyleSheet)

/* Hash table */

static const HashTableValue JSCSSStyleSheetTableValues[4] =
{
    { "ownerRule", DontDelete|ReadOnly, (intptr_t)jsCSSStyleSheetOwnerRule, (intptr_t)0 },
    { "cssRules", DontDelete|ReadOnly, (intptr_t)jsCSSStyleSheetCssRules, (intptr_t)0 },
    { "rules", DontDelete|ReadOnly, (intptr_t)jsCSSStyleSheetRules, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSCSSStyleSheetTable = { 7, JSCSSStyleSheetTableValues, 0 };

/* Hash table for prototype */

static const HashTableValue JSCSSStyleSheetPrototypeTableValues[5] =
{
    { "insertRule", DontDelete|Function, (intptr_t)jsCSSStyleSheetPrototypeFunctionInsertRule, (intptr_t)2 },
    { "deleteRule", DontDelete|Function, (intptr_t)jsCSSStyleSheetPrototypeFunctionDeleteRule, (intptr_t)1 },
    { "addRule", DontDelete|Function, (intptr_t)jsCSSStyleSheetPrototypeFunctionAddRule, (intptr_t)3 },
    { "removeRule", DontDelete|Function, (intptr_t)jsCSSStyleSheetPrototypeFunctionRemoveRule, (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static const HashTable JSCSSStyleSheetPrototypeTable = { 7, JSCSSStyleSheetPrototypeTableValues, 0 };

const ClassInfo JSCSSStyleSheetPrototype::s_info = { "CSSStyleSheetPrototype", 0, &JSCSSStyleSheetPrototypeTable, 0 };

JSObject* JSCSSStyleSheetPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSCSSStyleSheet>(exec);
}

bool JSCSSStyleSheetPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSCSSStyleSheetPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSCSSStyleSheet::s_info = { "CSSStyleSheet", &JSStyleSheet::s_info, &JSCSSStyleSheetTable , 0 };

JSCSSStyleSheet::JSCSSStyleSheet(PassRefPtr<StructureID> structure, PassRefPtr<CSSStyleSheet> impl)
    : JSStyleSheet(structure, impl)
{
}

JSObject* JSCSSStyleSheet::createPrototype(ExecState* exec)
{
    return new (exec) JSCSSStyleSheetPrototype(JSCSSStyleSheetPrototype::createStructureID(JSStyleSheetPrototype::self(exec)));
}

bool JSCSSStyleSheet::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCSSStyleSheet, Base>(exec, &JSCSSStyleSheetTable, this, propertyName, slot);
}

JSValue* jsCSSStyleSheetOwnerRule(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    CSSStyleSheet* imp = static_cast<CSSStyleSheet*>(static_cast<JSCSSStyleSheet*>(slot.slotBase())->impl());
    return toJS(exec, WTF::getPtr(imp->ownerRule()));
}

JSValue* jsCSSStyleSheetCssRules(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    CSSStyleSheet* imp = static_cast<CSSStyleSheet*>(static_cast<JSCSSStyleSheet*>(slot.slotBase())->impl());
    return toJS(exec, WTF::getPtr(imp->cssRules()));
}

JSValue* jsCSSStyleSheetRules(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    CSSStyleSheet* imp = static_cast<CSSStyleSheet*>(static_cast<JSCSSStyleSheet*>(slot.slotBase())->impl());
    return toJS(exec, WTF::getPtr(imp->rules()));
}

JSValue* jsCSSStyleSheetPrototypeFunctionInsertRule(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCSSStyleSheet::s_info))
        return throwError(exec, TypeError);
    JSCSSStyleSheet* castedThisObj = static_cast<JSCSSStyleSheet*>(thisValue);
    CSSStyleSheet* imp = static_cast<CSSStyleSheet*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    const UString& rule = args.at(exec, 0)->toString(exec);
    unsigned index = args.at(exec, 1)->toInt32(exec);


    JSC::JSValue* result = jsNumber(exec, imp->insertRule(rule, index, ec));
    setDOMException(exec, ec);
    return result;
}

JSValue* jsCSSStyleSheetPrototypeFunctionDeleteRule(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCSSStyleSheet::s_info))
        return throwError(exec, TypeError);
    JSCSSStyleSheet* castedThisObj = static_cast<JSCSSStyleSheet*>(thisValue);
    CSSStyleSheet* imp = static_cast<CSSStyleSheet*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    unsigned index = args.at(exec, 0)->toInt32(exec);

    imp->deleteRule(index, ec);
    setDOMException(exec, ec);
    return jsUndefined();
}

JSValue* jsCSSStyleSheetPrototypeFunctionAddRule(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCSSStyleSheet::s_info))
        return throwError(exec, TypeError);
    JSCSSStyleSheet* castedThisObj = static_cast<JSCSSStyleSheet*>(thisValue);
    CSSStyleSheet* imp = static_cast<CSSStyleSheet*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    const UString& selector = args.at(exec, 0)->toString(exec);
    const UString& style = args.at(exec, 1)->toString(exec);

    int argsCount = args.size();
    if (argsCount < 3) {

        JSC::JSValue* result = jsNumber(exec, imp->addRule(selector, style, ec));
        setDOMException(exec, ec);
        return result;
    }

    unsigned index = args.at(exec, 2)->toInt32(exec);


    JSC::JSValue* result = jsNumber(exec, imp->addRule(selector, style, index, ec));
    setDOMException(exec, ec);
    return result;
}

JSValue* jsCSSStyleSheetPrototypeFunctionRemoveRule(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCSSStyleSheet::s_info))
        return throwError(exec, TypeError);
    JSCSSStyleSheet* castedThisObj = static_cast<JSCSSStyleSheet*>(thisValue);
    CSSStyleSheet* imp = static_cast<CSSStyleSheet*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    unsigned index = args.at(exec, 0)->toInt32(exec);

    imp->removeRule(index, ec);
    setDOMException(exec, ec);
    return jsUndefined();
}


}
