/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** Contact: Qt Software Information (qt-info@nokia.com)
**
** This file is part of the QtGui module of the Qt Toolkit.
**
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the either Technology Preview License Agreement or the
** Beta Release License Agreement.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License versions 2.0 or 3.0 as published by the Free
** Software Foundation and appearing in the file LICENSE.GPL included in
** the packaging of this file.  Please review the following information
** to ensure GNU General Public Licensing requirements will be met:
** http://www.fsf.org/licensing/licenses/info/GPLv2.html and
** http://www.gnu.org/copyleft/gpl.html.  In addition, as a special
** exception, Nokia gives you certain additional rights. These rights
** are described in the Nokia Qt GPL Exception version 1.3, included in
** the file GPL_EXCEPTION.txt in this package.
**
** Qt for Windows(R) Licensees
** As a special exception, Nokia, as the sole copyright holder for Qt
** Designer, grants users of the Qt/Eclipse Integration plug-in the
** right for the Qt/Eclipse Integration to link to functionality
** provided by Qt Designer and its related libraries.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at qt-sales@nokia.com.
**
****************************************************************************/

#ifndef QNATIVEIMAGE_P_H
#define QNATIVEIMAGE_P_H

//
//  W A R N I N G
//  -------------
//
// This file is not part of the Qt API.  It exists purely as an
// implementation detail.  This header file may change from version to
// version without notice, or even be removed.
//
// We mean it.
//

#include "qimage.h"

#ifdef Q_WS_WIN
#include "qt_windows.h"

#elif defined(Q_WS_X11)
#include <private/qt_x11_p.h>

#elif defined(Q_WS_MAC)
#include <private/qt_mac_p.h>

#endif

QT_BEGIN_NAMESPACE

class QWidget;

class Q_GUI_EXPORT QNativeImage
{
public:
    QNativeImage(int width, int height, QImage::Format format, bool isTextBuffer = false, QWidget *widget = 0);
    ~QNativeImage();

    inline int width() const;
    inline int height() const;

    QImage image;

    static QImage::Format systemFormat();

#ifdef Q_WS_WIN
    HDC hdc;
    HBITMAP bitmap;
    HBITMAP null_bitmap;

#elif defined(Q_WS_X11) && !defined(QT_NO_MITSHM)
    XImage *xshmimg;
    Pixmap xshmpm;
    XShmSegmentInfo xshminfo;

#elif defined(Q_WS_MAC)
    CGContextRef cg;
    CGColorSpaceRef cgColorSpace;
#endif

private:
    Q_DISABLE_COPY(QNativeImage)
};

inline int QNativeImage::width() const { return image.width(); }
inline int QNativeImage::height() const { return image.height(); }

QT_END_NAMESPACE

#endif // QNATIVEIMAGE_P_H
