/****************************************************************************
**
** Copyright (C) 2008 Nokia Corporation and/or its subsidiary(-ies).
** Contact: Qt Software Information (qt-info@nokia.com)
**
** This file is part of the QtScriptTools module of the Qt Toolkit.
**
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the either Technology Preview License Agreement or the
** Beta Release License Agreement.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License versions 2.0 or 3.0 as published by the Free
** Software Foundation and appearing in the file LICENSE.GPL included in
** the packaging of this file.  Please review the following information
** to ensure GNU General Public Licensing requirements will be met:
** http://www.fsf.org/licensing/licenses/info/GPLv2.html and
** http://www.gnu.org/copyleft/gpl.html.  In addition, as a special
** exception, Nokia gives you certain additional rights. These rights
** are described in the Nokia Qt GPL Exception version 1.3, included in
** the file GPL_EXCEPTION.txt in this package.
**
** Qt for Windows(R) Licensees
** As a special exception, Nokia, as the sole copyright holder for Qt
** Designer, grants users of the Qt/Eclipse Integration plug-in the
** right for the Qt/Eclipse Integration to link to functionality
** provided by Qt Designer and its related libraries.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at qt-sales@nokia.com.
**
****************************************************************************/

#ifndef QSCRIPTDEBUGGEREVENT_P_H
#define QSCRIPTDEBUGGEREVENT_P_H

//
//  W A R N I N G
//  -------------
//
// This file is not part of the Qt API.  It exists purely as an
// implementation detail.  This header file may change from version to
// version without notice, or even be removed.
//
// We mean it.
//

#include <QtCore/qobjectdefs.h>

#include <QtCore/qhash.h>
#include <QtCore/qvariant.h>

QT_BEGIN_NAMESPACE

class QDataStream;
class QScriptDebuggerValue;

class QScriptDebuggerEventPrivate;
class Q_AUTOTEST_EXPORT QScriptDebuggerEvent
{
public:
    friend Q_AUTOTEST_EXPORT QDataStream &operator<<(QDataStream &, const QScriptDebuggerEvent &);
    friend Q_AUTOTEST_EXPORT QDataStream &operator>>(QDataStream &, QScriptDebuggerEvent &);

    enum Type {
        None,
        Interrupted,
        SteppingFinished,
        LocationReached,
        Breakpoint,
        Exception,
        Trace,
        InlineEvalFinished,
        DebuggerInvocationRequest,
        ForcedReturn,
        UserEvent = 1000,
        MaxUserEvent = 32767
    };

    enum Attribute {
        ScriptID,
        FileName,
        BreakpointID,
        LineNumber,
        ColumnNumber,
        Value,
        Message,
        IsNestedEvaluate,
        UserAttribute = 1000,
        MaxUserAttribute = 32767
    };

    QScriptDebuggerEvent();
    QScriptDebuggerEvent(Type type);
    QScriptDebuggerEvent(Type type, qint64 scriptId, int lineNumber, int columnNumber);
    QScriptDebuggerEvent(const QScriptDebuggerEvent &other);
    ~QScriptDebuggerEvent();

    Type type() const;

    QVariant attribute(Attribute attribute,
                       const QVariant &defaultValue = QVariant()) const;
    void setAttribute(Attribute attribute, const QVariant &value);
    QHash<Attribute, QVariant> attributes() const;

    qint64 scriptId() const;
    void setScriptId(qint64 id);
    QString fileName() const;
    void setFileName(const QString &fileName);
    int lineNumber() const;
    void setLineNumber(int lineNumber);
    int columnNumber() const;
    void setColumnNumber(int columnNumber);
    int breakpointId() const;
    void setBreakpointId(int id);
    QString message() const;
    void setMessage(const QString &message);
    QScriptDebuggerValue scriptValue() const;
    void setScriptValue(const QScriptDebuggerValue &value);
    void setNestedEvaluate(bool nested);
    bool isNestedEvaluate() const;

    QScriptDebuggerEvent &operator=(const QScriptDebuggerEvent &other);

    bool operator==(const QScriptDebuggerEvent &other) const;
    bool operator!=(const QScriptDebuggerEvent &other) const;

private:
    QScriptDebuggerEventPrivate *d_ptr;

    Q_DECLARE_PRIVATE(QScriptDebuggerEvent)
};

Q_AUTOTEST_EXPORT QDataStream &operator<<(QDataStream &, const QScriptDebuggerEvent &);
Q_AUTOTEST_EXPORT QDataStream &operator>>(QDataStream &, QScriptDebuggerEvent &);

QT_END_NAMESPACE

#endif
