/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSWebKitAnimationEvent.h"

#include <wtf/GetPtr.h>

#include "KURL.h"
#include "WebKitAnimationEvent.h"

#include <runtime/Error.h>
#include <runtime/JSNumberCell.h>
#include <runtime/JSString.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSWebKitAnimationEvent)

/* Hash table */

static const HashTableValue JSWebKitAnimationEventTableValues[3] =
{
    { "animationName", DontDelete|ReadOnly, (intptr_t)jsWebKitAnimationEventAnimationName, (intptr_t)0 },
    { "elapsedTime", DontDelete|ReadOnly, (intptr_t)jsWebKitAnimationEventElapsedTime, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSWebKitAnimationEventTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 127, JSWebKitAnimationEventTableValues, 0 };
#else
    { 5, 3, JSWebKitAnimationEventTableValues, 0 };
#endif

/* Hash table for prototype */

static const HashTableValue JSWebKitAnimationEventPrototypeTableValues[2] =
{
    { "initWebKitAnimationEvent", DontDelete|Function, (intptr_t)jsWebKitAnimationEventPrototypeFunctionInitWebKitAnimationEvent, (intptr_t)5 },
    { 0, 0, 0, 0 }
};

static const HashTable JSWebKitAnimationEventPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSWebKitAnimationEventPrototypeTableValues, 0 };
#else
    { 2, 1, JSWebKitAnimationEventPrototypeTableValues, 0 };
#endif

const ClassInfo JSWebKitAnimationEventPrototype::s_info = { "WebKitAnimationEventPrototype", 0, &JSWebKitAnimationEventPrototypeTable, 0 };

JSObject* JSWebKitAnimationEventPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSWebKitAnimationEvent>(exec);
}

bool JSWebKitAnimationEventPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSWebKitAnimationEventPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSWebKitAnimationEvent::s_info = { "WebKitAnimationEvent", &JSEvent::s_info, &JSWebKitAnimationEventTable, 0 };

JSWebKitAnimationEvent::JSWebKitAnimationEvent(PassRefPtr<Structure> structure, PassRefPtr<WebKitAnimationEvent> impl)
    : JSEvent(structure, impl)
{
}

JSObject* JSWebKitAnimationEvent::createPrototype(ExecState* exec)
{
    return new (exec) JSWebKitAnimationEventPrototype(JSWebKitAnimationEventPrototype::createStructure(JSEventPrototype::self(exec)));
}

bool JSWebKitAnimationEvent::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSWebKitAnimationEvent, Base>(exec, &JSWebKitAnimationEventTable, this, propertyName, slot);
}

JSValue* jsWebKitAnimationEventAnimationName(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    WebKitAnimationEvent* imp = static_cast<WebKitAnimationEvent*>(static_cast<JSWebKitAnimationEvent*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->animationName());
}

JSValue* jsWebKitAnimationEventElapsedTime(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    WebKitAnimationEvent* imp = static_cast<WebKitAnimationEvent*>(static_cast<JSWebKitAnimationEvent*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->elapsedTime());
}

JSValue* jsWebKitAnimationEventPrototypeFunctionInitWebKitAnimationEvent(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSWebKitAnimationEvent::s_info))
        return throwError(exec, TypeError);
    JSWebKitAnimationEvent* castedThisObj = static_cast<JSWebKitAnimationEvent*>(asObject(thisValue));
    WebKitAnimationEvent* imp = static_cast<WebKitAnimationEvent*>(castedThisObj->impl());
    const UString& typeArg = args.at(exec, 0)->toString(exec);
    bool canBubbleArg = args.at(exec, 1)->toBoolean(exec);
    bool cancelableArg = args.at(exec, 2)->toBoolean(exec);
    const UString& animationNameArg = args.at(exec, 3)->toString(exec);
    double elapsedTimeArg = args.at(exec, 4)->toNumber(exec);

    imp->initWebKitAnimationEvent(typeArg, canBubbleArg, cancelableArg, animationNameArg, elapsedTimeArg);
    return jsUndefined();
}


}
