/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(SVG)

#include "SVGElement.h"
#include "JSSVGSymbolElement.h"

#include <wtf/GetPtr.h>

#include "CSSMutableStyleDeclaration.h"
#include "CSSStyleDeclaration.h"
#include "CSSValue.h"
#include "JSCSSStyleDeclaration.h"
#include "JSCSSValue.h"
#include "JSSVGAnimatedBoolean.h"
#include "JSSVGAnimatedPreserveAspectRatio.h"
#include "JSSVGAnimatedRect.h"
#include "JSSVGAnimatedString.h"
#include "KURL.h"
#include "SVGSymbolElement.h"

#include <runtime/Error.h>
#include <runtime/JSString.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGSymbolElement)

/* Hash table */

static const HashTableValue JSSVGSymbolElementTableValues[8] =
{
    { "xmllang", DontDelete, (intptr_t)jsSVGSymbolElementXmllang, (intptr_t)setJSSVGSymbolElementXmllang },
    { "xmlspace", DontDelete, (intptr_t)jsSVGSymbolElementXmlspace, (intptr_t)setJSSVGSymbolElementXmlspace },
    { "externalResourcesRequired", DontDelete|ReadOnly, (intptr_t)jsSVGSymbolElementExternalResourcesRequired, (intptr_t)0 },
    { "className", DontDelete|ReadOnly, (intptr_t)jsSVGSymbolElementClassName, (intptr_t)0 },
    { "style", DontDelete|ReadOnly, (intptr_t)jsSVGSymbolElementStyle, (intptr_t)0 },
    { "viewBox", DontDelete|ReadOnly, (intptr_t)jsSVGSymbolElementViewBox, (intptr_t)0 },
    { "preserveAspectRatio", DontDelete|ReadOnly, (intptr_t)jsSVGSymbolElementPreserveAspectRatio, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGSymbolElementTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 15, JSSVGSymbolElementTableValues, 0 };
#else
    { 16, 15, JSSVGSymbolElementTableValues, 0 };
#endif

/* Hash table for prototype */

static const HashTableValue JSSVGSymbolElementPrototypeTableValues[2] =
{
    { "getPresentationAttribute", DontDelete|Function, (intptr_t)jsSVGSymbolElementPrototypeFunctionGetPresentationAttribute, (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGSymbolElementPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSSVGSymbolElementPrototypeTableValues, 0 };
#else
    { 2, 1, JSSVGSymbolElementPrototypeTableValues, 0 };
#endif

const ClassInfo JSSVGSymbolElementPrototype::s_info = { "SVGSymbolElementPrototype", 0, &JSSVGSymbolElementPrototypeTable, 0 };

JSObject* JSSVGSymbolElementPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSSVGSymbolElement>(exec);
}

bool JSSVGSymbolElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGSymbolElementPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSSVGSymbolElement::s_info = { "SVGSymbolElement", &JSSVGElement::s_info, &JSSVGSymbolElementTable, 0 };

JSSVGSymbolElement::JSSVGSymbolElement(PassRefPtr<Structure> structure, PassRefPtr<SVGSymbolElement> impl)
    : JSSVGElement(structure, impl)
{
}

JSObject* JSSVGSymbolElement::createPrototype(ExecState* exec)
{
    return new (exec) JSSVGSymbolElementPrototype(JSSVGSymbolElementPrototype::createStructure(JSSVGElementPrototype::self(exec)));
}

bool JSSVGSymbolElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGSymbolElement, Base>(exec, &JSSVGSymbolElementTable, this, propertyName, slot);
}

JSValue* jsSVGSymbolElementXmllang(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGSymbolElement* imp = static_cast<SVGSymbolElement*>(static_cast<JSSVGSymbolElement*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->xmllang());
}

JSValue* jsSVGSymbolElementXmlspace(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGSymbolElement* imp = static_cast<SVGSymbolElement*>(static_cast<JSSVGSymbolElement*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->xmlspace());
}

JSValue* jsSVGSymbolElementExternalResourcesRequired(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGSymbolElement* imp = static_cast<SVGSymbolElement*>(static_cast<JSSVGSymbolElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedBoolean> obj = imp->externalResourcesRequiredAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValue* jsSVGSymbolElementClassName(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGSymbolElement* imp = static_cast<SVGSymbolElement*>(static_cast<JSSVGSymbolElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedString> obj = imp->classNameAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValue* jsSVGSymbolElementStyle(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGSymbolElement* imp = static_cast<SVGSymbolElement*>(static_cast<JSSVGSymbolElement*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->style()));
}

JSValue* jsSVGSymbolElementViewBox(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGSymbolElement* imp = static_cast<SVGSymbolElement*>(static_cast<JSSVGSymbolElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedRect> obj = imp->viewBoxAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValue* jsSVGSymbolElementPreserveAspectRatio(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGSymbolElement* imp = static_cast<SVGSymbolElement*>(static_cast<JSSVGSymbolElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedPreserveAspectRatio> obj = imp->preserveAspectRatioAnimated();
    return toJS(exec, obj.get(), imp);
}

void JSSVGSymbolElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value, PutPropertySlot& slot)
{
    lookupPut<JSSVGSymbolElement, Base>(exec, propertyName, value, &JSSVGSymbolElementTable, this, slot);
}

void setJSSVGSymbolElementXmllang(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    SVGSymbolElement* imp = static_cast<SVGSymbolElement*>(static_cast<JSSVGSymbolElement*>(thisObject)->impl());
    imp->setXmllang(value->toString(exec));
}

void setJSSVGSymbolElementXmlspace(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    SVGSymbolElement* imp = static_cast<SVGSymbolElement*>(static_cast<JSSVGSymbolElement*>(thisObject)->impl());
    imp->setXmlspace(value->toString(exec));
}

JSValue* jsSVGSymbolElementPrototypeFunctionGetPresentationAttribute(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGSymbolElement::s_info))
        return throwError(exec, TypeError);
    JSSVGSymbolElement* castedThisObj = static_cast<JSSVGSymbolElement*>(asObject(thisValue));
    SVGSymbolElement* imp = static_cast<SVGSymbolElement*>(castedThisObj->impl());
    const UString& name = args.at(exec, 0)->toString(exec);


    JSC::JSValue* result = toJS(exec, WTF::getPtr(imp->getPresentationAttribute(name)));
    return result;
}


}

#endif // ENABLE(SVG)
