/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef JSSVGMatrix_h
#define JSSVGMatrix_h


#if ENABLE(SVG)

#include "JSDOMBinding.h"
#include <runtime/JSGlobalObject.h>
#include <runtime/ObjectPrototype.h>
#include "AffineTransform.h"
#include "JSSVGPODTypeWrapper.h"

namespace WebCore {

class JSSVGMatrix : public DOMObject {
    typedef DOMObject Base;
public:
    JSSVGMatrix(PassRefPtr<JSC::Structure>, PassRefPtr<JSSVGPODTypeWrapper<AffineTransform> >, SVGElement* context);
    virtual ~JSSVGMatrix();
    static JSC::JSObject* createPrototype(JSC::ExecState*);
    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier& propertyName, JSC::PropertySlot&);
    virtual void put(JSC::ExecState*, const JSC::Identifier& propertyName, JSC::JSValue*, JSC::PutPropertySlot&);
    virtual const JSC::ClassInfo* classInfo() const { return &s_info; }
    static const JSC::ClassInfo s_info;

    static PassRefPtr<JSC::Structure> createStructure(JSC::JSValue* prototype)
    {
        return JSC::Structure::create(prototype, JSC::TypeInfo(JSC::ObjectType));
    }


    // Custom functions
    JSC::JSValue* multiply(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue* inverse(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue* translate(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue* scale(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue* scaleNonUniform(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue* rotate(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue* rotateFromVector(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue* flipX(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue* flipY(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue* skewX(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue* skewY(JSC::ExecState*, const JSC::ArgList&);
    JSSVGPODTypeWrapper<AffineTransform>* impl() const { return m_impl.get(); }
    SVGElement* context() const { return m_context.get(); }

private:
    RefPtr<SVGElement> m_context;
    RefPtr<JSSVGPODTypeWrapper<AffineTransform> > m_impl;
};

JSC::JSValue* toJS(JSC::ExecState*, JSSVGPODTypeWrapper<AffineTransform>*, SVGElement* context);
AffineTransform toSVGMatrix(JSC::JSValue*);

class JSSVGMatrixPrototype : public JSC::JSObject {
public:
    static JSC::JSObject* self(JSC::ExecState*);
    virtual const JSC::ClassInfo* classInfo() const { return &s_info; }
    static const JSC::ClassInfo s_info;
    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    static PassRefPtr<JSC::Structure> createStructure(JSC::JSValue* prototype)
    {
        return JSC::Structure::create(prototype, JSC::TypeInfo(JSC::ObjectType));
    }
    JSSVGMatrixPrototype(PassRefPtr<JSC::Structure> structure) : JSC::JSObject(structure) { }
};

// Functions

JSC::JSValue* jsSVGMatrixPrototypeFunctionMultiply(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
JSC::JSValue* jsSVGMatrixPrototypeFunctionInverse(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
JSC::JSValue* jsSVGMatrixPrototypeFunctionTranslate(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
JSC::JSValue* jsSVGMatrixPrototypeFunctionScale(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
JSC::JSValue* jsSVGMatrixPrototypeFunctionScaleNonUniform(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
JSC::JSValue* jsSVGMatrixPrototypeFunctionRotate(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
JSC::JSValue* jsSVGMatrixPrototypeFunctionRotateFromVector(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
JSC::JSValue* jsSVGMatrixPrototypeFunctionFlipX(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
JSC::JSValue* jsSVGMatrixPrototypeFunctionFlipY(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
JSC::JSValue* jsSVGMatrixPrototypeFunctionSkewX(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
JSC::JSValue* jsSVGMatrixPrototypeFunctionSkewY(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
// Attributes

JSC::JSValue* jsSVGMatrixA(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSSVGMatrixA(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsSVGMatrixB(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSSVGMatrixB(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsSVGMatrixC(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSSVGMatrixC(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsSVGMatrixD(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSSVGMatrixD(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsSVGMatrixE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSSVGMatrixE(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsSVGMatrixF(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSSVGMatrixF(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);

} // namespace WebCore

#endif // ENABLE(SVG)

#endif
