/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSProcessingInstruction.h"

#include <wtf/GetPtr.h>

#include "JSStyleSheet.h"
#include "KURL.h"
#include "ProcessingInstruction.h"
#include "StyleSheet.h"

#include <runtime/JSNumberCell.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSProcessingInstruction)

/* Hash table */

static const HashTableValue JSProcessingInstructionTableValues[5] =
{
    { "target", DontDelete|ReadOnly, (intptr_t)jsProcessingInstructionTarget, (intptr_t)0 },
    { "data", DontDelete, (intptr_t)jsProcessingInstructionData, (intptr_t)setJSProcessingInstructionData },
    { "sheet", DontDelete|ReadOnly, (intptr_t)jsProcessingInstructionSheet, (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsProcessingInstructionConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSProcessingInstructionTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 7, JSProcessingInstructionTableValues, 0 };
#else
    { 8, 7, JSProcessingInstructionTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSProcessingInstructionConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSProcessingInstructionConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSProcessingInstructionConstructorTableValues, 0 };
#else
    { 1, 0, JSProcessingInstructionConstructorTableValues, 0 };
#endif

class JSProcessingInstructionConstructor : public DOMObject {
public:
    JSProcessingInstructionConstructor(ExecState* exec)
        : DOMObject(JSProcessingInstructionConstructor::createStructure(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSProcessingInstructionPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue* proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSProcessingInstructionConstructor::s_info = { "ProcessingInstructionConstructor", 0, &JSProcessingInstructionConstructorTable, 0 };

bool JSProcessingInstructionConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSProcessingInstructionConstructor, DOMObject>(exec, &JSProcessingInstructionConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSProcessingInstructionPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSProcessingInstructionPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSProcessingInstructionPrototypeTableValues, 0 };
#else
    { 1, 0, JSProcessingInstructionPrototypeTableValues, 0 };
#endif

const ClassInfo JSProcessingInstructionPrototype::s_info = { "ProcessingInstructionPrototype", 0, &JSProcessingInstructionPrototypeTable, 0 };

JSObject* JSProcessingInstructionPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSProcessingInstruction>(exec);
}

const ClassInfo JSProcessingInstruction::s_info = { "ProcessingInstruction", &JSNode::s_info, &JSProcessingInstructionTable, 0 };

JSProcessingInstruction::JSProcessingInstruction(PassRefPtr<Structure> structure, PassRefPtr<ProcessingInstruction> impl)
    : JSNode(structure, impl)
{
}

JSObject* JSProcessingInstruction::createPrototype(ExecState* exec)
{
    return new (exec) JSProcessingInstructionPrototype(JSProcessingInstructionPrototype::createStructure(JSNodePrototype::self(exec)));
}

bool JSProcessingInstruction::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSProcessingInstruction, Base>(exec, &JSProcessingInstructionTable, this, propertyName, slot);
}

JSValue* jsProcessingInstructionTarget(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    ProcessingInstruction* imp = static_cast<ProcessingInstruction*>(static_cast<JSProcessingInstruction*>(asObject(slot.slotBase()))->impl());
    return jsStringOrNull(exec, imp->target());
}

JSValue* jsProcessingInstructionData(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    ProcessingInstruction* imp = static_cast<ProcessingInstruction*>(static_cast<JSProcessingInstruction*>(asObject(slot.slotBase()))->impl());
    return jsStringOrNull(exec, imp->data());
}

JSValue* jsProcessingInstructionSheet(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    ProcessingInstruction* imp = static_cast<ProcessingInstruction*>(static_cast<JSProcessingInstruction*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->sheet()));
}

JSValue* jsProcessingInstructionConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSProcessingInstruction*>(asObject(slot.slotBase()))->getConstructor(exec);
}
void JSProcessingInstruction::put(ExecState* exec, const Identifier& propertyName, JSValue* value, PutPropertySlot& slot)
{
    lookupPut<JSProcessingInstruction, Base>(exec, propertyName, value, &JSProcessingInstructionTable, this, slot);
}

void setJSProcessingInstructionData(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    ProcessingInstruction* imp = static_cast<ProcessingInstruction*>(static_cast<JSProcessingInstruction*>(thisObject)->impl());
    ExceptionCode ec = 0;
    imp->setData(valueToStringWithNullCheck(exec, value), ec);
    setDOMException(exec, ec);
}

JSValue* JSProcessingInstruction::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSProcessingInstructionConstructor>(exec);
}


}
