/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef JSMessagePort_h
#define JSMessagePort_h

#include "JSDOMBinding.h"
#include <runtime/JSGlobalObject.h>
#include <runtime/ObjectPrototype.h>

namespace WebCore {

class MessagePort;

class JSMessagePort : public DOMObject {
    typedef DOMObject Base;
public:
    JSMessagePort(PassRefPtr<JSC::Structure>, PassRefPtr<MessagePort>);
    virtual ~JSMessagePort();
    static JSC::JSObject* createPrototype(JSC::ExecState*);
    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier& propertyName, JSC::PropertySlot&);
    virtual void put(JSC::ExecState*, const JSC::Identifier& propertyName, JSC::JSValue*, JSC::PutPropertySlot&);
    virtual const JSC::ClassInfo* classInfo() const { return &s_info; }
    static const JSC::ClassInfo s_info;

    static PassRefPtr<JSC::Structure> createStructure(JSC::JSValue* prototype)
    {
        return JSC::Structure::create(prototype, JSC::TypeInfo(JSC::ObjectType));
    }

    virtual void mark();

    static JSC::JSValue* getConstructor(JSC::ExecState*);

    // Custom functions
    JSC::JSValue* startConversation(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue* addEventListener(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue* removeEventListener(JSC::ExecState*, const JSC::ArgList&);
    MessagePort* impl() const { return m_impl.get(); }

private:
    RefPtr<MessagePort> m_impl;
};

JSC::JSValue* toJS(JSC::ExecState*, MessagePort*);
MessagePort* toMessagePort(JSC::JSValue*);

class JSMessagePortPrototype : public JSC::JSObject {
public:
    static JSC::JSObject* self(JSC::ExecState*);
    virtual const JSC::ClassInfo* classInfo() const { return &s_info; }
    static const JSC::ClassInfo s_info;
    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    static PassRefPtr<JSC::Structure> createStructure(JSC::JSValue* prototype)
    {
        return JSC::Structure::create(prototype, JSC::TypeInfo(JSC::ObjectType));
    }
    JSMessagePortPrototype(PassRefPtr<JSC::Structure> structure) : JSC::JSObject(structure) { }
};

// Functions

JSC::JSValue* jsMessagePortPrototypeFunctionPostMessage(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
JSC::JSValue* jsMessagePortPrototypeFunctionStartConversation(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
JSC::JSValue* jsMessagePortPrototypeFunctionStart(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
JSC::JSValue* jsMessagePortPrototypeFunctionClose(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
JSC::JSValue* jsMessagePortPrototypeFunctionAddEventListener(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
JSC::JSValue* jsMessagePortPrototypeFunctionRemoveEventListener(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
JSC::JSValue* jsMessagePortPrototypeFunctionDispatchEvent(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
// Attributes

JSC::JSValue* jsMessagePortActive(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue* jsMessagePortOnmessage(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSMessagePortOnmessage(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsMessagePortOnclose(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSMessagePortOnclose(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsMessagePortConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);

} // namespace WebCore

#endif
