/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSHTMLDListElement.h"

#include <wtf/GetPtr.h>

#include "HTMLDListElement.h"

#include <runtime/JSNumberCell.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHTMLDListElement)

/* Hash table */

static const HashTableValue JSHTMLDListElementTableValues[3] =
{
    { "compact", DontDelete, (intptr_t)jsHTMLDListElementCompact, (intptr_t)setJSHTMLDListElementCompact },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsHTMLDListElementConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLDListElementTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 3, JSHTMLDListElementTableValues, 0 };
#else
    { 4, 3, JSHTMLDListElementTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSHTMLDListElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLDListElementConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHTMLDListElementConstructorTableValues, 0 };
#else
    { 1, 0, JSHTMLDListElementConstructorTableValues, 0 };
#endif

class JSHTMLDListElementConstructor : public DOMObject {
public:
    JSHTMLDListElementConstructor(ExecState* exec)
        : DOMObject(JSHTMLDListElementConstructor::createStructure(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSHTMLDListElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue* proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSHTMLDListElementConstructor::s_info = { "HTMLDListElementConstructor", 0, &JSHTMLDListElementConstructorTable, 0 };

bool JSHTMLDListElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLDListElementConstructor, DOMObject>(exec, &JSHTMLDListElementConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLDListElementPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLDListElementPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHTMLDListElementPrototypeTableValues, 0 };
#else
    { 1, 0, JSHTMLDListElementPrototypeTableValues, 0 };
#endif

const ClassInfo JSHTMLDListElementPrototype::s_info = { "HTMLDListElementPrototype", 0, &JSHTMLDListElementPrototypeTable, 0 };

JSObject* JSHTMLDListElementPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSHTMLDListElement>(exec);
}

const ClassInfo JSHTMLDListElement::s_info = { "HTMLDListElement", &JSHTMLElement::s_info, &JSHTMLDListElementTable, 0 };

JSHTMLDListElement::JSHTMLDListElement(PassRefPtr<Structure> structure, PassRefPtr<HTMLDListElement> impl)
    : JSHTMLElement(structure, impl)
{
}

JSObject* JSHTMLDListElement::createPrototype(ExecState* exec)
{
    return new (exec) JSHTMLDListElementPrototype(JSHTMLDListElementPrototype::createStructure(JSHTMLElementPrototype::self(exec)));
}

bool JSHTMLDListElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLDListElement, Base>(exec, &JSHTMLDListElementTable, this, propertyName, slot);
}

JSValue* jsHTMLDListElementCompact(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLDListElement* imp = static_cast<HTMLDListElement*>(static_cast<JSHTMLDListElement*>(asObject(slot.slotBase()))->impl());
    return jsBoolean(imp->compact());
}

JSValue* jsHTMLDListElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSHTMLDListElement*>(asObject(slot.slotBase()))->getConstructor(exec);
}
void JSHTMLDListElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value, PutPropertySlot& slot)
{
    lookupPut<JSHTMLDListElement, Base>(exec, propertyName, value, &JSHTMLDListElementTable, this, slot);
}

void setJSHTMLDListElementCompact(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLDListElement* imp = static_cast<HTMLDListElement*>(static_cast<JSHTMLDListElement*>(thisObject)->impl());
    imp->setCompact(value->toBoolean(exec));
}

JSValue* JSHTMLDListElement::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSHTMLDListElementConstructor>(exec);
}


}
