/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSHTMLBRElement.h"

#include <wtf/GetPtr.h>

#include "HTMLBRElement.h"
#include "KURL.h"

#include <runtime/JSNumberCell.h>
#include <runtime/JSString.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHTMLBRElement)

/* Hash table */

static const HashTableValue JSHTMLBRElementTableValues[3] =
{
    { "clear", DontDelete, (intptr_t)jsHTMLBRElementClear, (intptr_t)setJSHTMLBRElementClear },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsHTMLBRElementConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLBRElementTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 3, JSHTMLBRElementTableValues, 0 };
#else
    { 4, 3, JSHTMLBRElementTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSHTMLBRElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLBRElementConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHTMLBRElementConstructorTableValues, 0 };
#else
    { 1, 0, JSHTMLBRElementConstructorTableValues, 0 };
#endif

class JSHTMLBRElementConstructor : public DOMObject {
public:
    JSHTMLBRElementConstructor(ExecState* exec)
        : DOMObject(JSHTMLBRElementConstructor::createStructure(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSHTMLBRElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue* proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSHTMLBRElementConstructor::s_info = { "HTMLBRElementConstructor", 0, &JSHTMLBRElementConstructorTable, 0 };

bool JSHTMLBRElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLBRElementConstructor, DOMObject>(exec, &JSHTMLBRElementConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLBRElementPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLBRElementPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHTMLBRElementPrototypeTableValues, 0 };
#else
    { 1, 0, JSHTMLBRElementPrototypeTableValues, 0 };
#endif

const ClassInfo JSHTMLBRElementPrototype::s_info = { "HTMLBRElementPrototype", 0, &JSHTMLBRElementPrototypeTable, 0 };

JSObject* JSHTMLBRElementPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSHTMLBRElement>(exec);
}

const ClassInfo JSHTMLBRElement::s_info = { "HTMLBRElement", &JSHTMLElement::s_info, &JSHTMLBRElementTable, 0 };

JSHTMLBRElement::JSHTMLBRElement(PassRefPtr<Structure> structure, PassRefPtr<HTMLBRElement> impl)
    : JSHTMLElement(structure, impl)
{
}

JSObject* JSHTMLBRElement::createPrototype(ExecState* exec)
{
    return new (exec) JSHTMLBRElementPrototype(JSHTMLBRElementPrototype::createStructure(JSHTMLElementPrototype::self(exec)));
}

bool JSHTMLBRElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLBRElement, Base>(exec, &JSHTMLBRElementTable, this, propertyName, slot);
}

JSValue* jsHTMLBRElementClear(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLBRElement* imp = static_cast<HTMLBRElement*>(static_cast<JSHTMLBRElement*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->clear());
}

JSValue* jsHTMLBRElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSHTMLBRElement*>(asObject(slot.slotBase()))->getConstructor(exec);
}
void JSHTMLBRElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value, PutPropertySlot& slot)
{
    lookupPut<JSHTMLBRElement, Base>(exec, propertyName, value, &JSHTMLBRElementTable, this, slot);
}

void setJSHTMLBRElementClear(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLBRElement* imp = static_cast<HTMLBRElement*>(static_cast<JSHTMLBRElement*>(thisObject)->impl());
    imp->setClear(valueToStringWithNullCheck(exec, value));
}

JSValue* JSHTMLBRElement::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSHTMLBRElementConstructor>(exec);
}


}
