/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSDOMWindow.h"

#include <wtf/GetPtr.h>

#include "BarInfo.h"
#include "CSSMutableStyleDeclaration.h"
#include "CSSRuleList.h"
#include "CSSStyleDeclaration.h"
#include "Console.h"
#include "DOMApplicationCache.h"
#include "DOMSelection.h"
#include "DOMWindow.h"
#include "Database.h"
#include "Document.h"
#include "Element.h"
#include "EventListener.h"
#include "History.h"
#include "JSAttr.h"
#include "JSBarInfo.h"
#include "JSCDATASection.h"
#include "JSCSSCharsetRule.h"
#include "JSCSSFontFaceRule.h"
#include "JSCSSImportRule.h"
#include "JSCSSMediaRule.h"
#include "JSCSSPageRule.h"
#include "JSCSSPrimitiveValue.h"
#include "JSCSSRule.h"
#include "JSCSSRuleList.h"
#include "JSCSSStyleDeclaration.h"
#include "JSCSSStyleRule.h"
#include "JSCSSStyleSheet.h"
#include "JSCSSValue.h"
#include "JSCSSValueList.h"
#include "JSCSSVariablesDeclaration.h"
#include "JSCSSVariablesRule.h"
#include "JSCanvasRenderingContext2D.h"
#include "JSCharacterData.h"
#include "JSClipboard.h"
#include "JSComment.h"
#include "JSConsole.h"
#include "JSCounter.h"
#include "JSDOMApplicationCache.h"
#include "JSDOMBinding.h"
#include "JSDOMCoreException.h"
#include "JSDOMImplementation.h"
#include "JSDOMParser.h"
#include "JSDOMSelection.h"
#include "JSDOMWindow.h"
#include "JSDOMWindowCustom.h"
#include "JSDOMWindowShell.h"
#include "JSDatabase.h"
#include "JSDocument.h"
#include "JSDocumentFragment.h"
#include "JSDocumentType.h"
#include "JSElement.h"
#include "JSEntity.h"
#include "JSEntityReference.h"
#include "JSEvent.h"
#include "JSEventException.h"
#include "JSEventListener.h"
#include "JSFile.h"
#include "JSFileList.h"
#include "JSHTMLAnchorElement.h"
#include "JSHTMLAppletElement.h"
#include "JSHTMLAreaElement.h"
#include "JSHTMLAudioElement.h"
#include "JSHTMLBRElement.h"
#include "JSHTMLBaseElement.h"
#include "JSHTMLBaseFontElement.h"
#include "JSHTMLBlockquoteElement.h"
#include "JSHTMLBodyElement.h"
#include "JSHTMLButtonElement.h"
#include "JSHTMLCanvasElement.h"
#include "JSHTMLCollection.h"
#include "JSHTMLDListElement.h"
#include "JSHTMLDirectoryElement.h"
#include "JSHTMLDivElement.h"
#include "JSHTMLDocument.h"
#include "JSHTMLElement.h"
#include "JSHTMLEmbedElement.h"
#include "JSHTMLFieldSetElement.h"
#include "JSHTMLFontElement.h"
#include "JSHTMLFormElement.h"
#include "JSHTMLFrameElement.h"
#include "JSHTMLFrameSetElement.h"
#include "JSHTMLHRElement.h"
#include "JSHTMLHeadElement.h"
#include "JSHTMLHeadingElement.h"
#include "JSHTMLHtmlElement.h"
#include "JSHTMLIFrameElement.h"
#include "JSHTMLImageElement.h"
#include "JSHTMLInputElement.h"
#include "JSHTMLIsIndexElement.h"
#include "JSHTMLLIElement.h"
#include "JSHTMLLabelElement.h"
#include "JSHTMLLegendElement.h"
#include "JSHTMLLinkElement.h"
#include "JSHTMLMapElement.h"
#include "JSHTMLMarqueeElement.h"
#include "JSHTMLMediaElement.h"
#include "JSHTMLMenuElement.h"
#include "JSHTMLMetaElement.h"
#include "JSHTMLModElement.h"
#include "JSHTMLOListElement.h"
#include "JSHTMLObjectElement.h"
#include "JSHTMLOptGroupElement.h"
#include "JSHTMLOptionElement.h"
#include "JSHTMLParagraphElement.h"
#include "JSHTMLParamElement.h"
#include "JSHTMLPreElement.h"
#include "JSHTMLQuoteElement.h"
#include "JSHTMLScriptElement.h"
#include "JSHTMLSelectElement.h"
#include "JSHTMLStyleElement.h"
#include "JSHTMLTableCaptionElement.h"
#include "JSHTMLTableCellElement.h"
#include "JSHTMLTableColElement.h"
#include "JSHTMLTableElement.h"
#include "JSHTMLTableRowElement.h"
#include "JSHTMLTableSectionElement.h"
#include "JSHTMLTextAreaElement.h"
#include "JSHTMLTitleElement.h"
#include "JSHTMLUListElement.h"
#include "JSHTMLVideoElement.h"
#include "JSHistory.h"
#include "JSKeyboardEvent.h"
#include "JSLocation.h"
#include "JSMediaError.h"
#include "JSMediaList.h"
#include "JSMessageEvent.h"
#include "JSMimeType.h"
#include "JSMimeTypeArray.h"
#include "JSMouseEvent.h"
#include "JSMutationEvent.h"
#include "JSNamedNodeMap.h"
#include "JSNavigator.h"
#include "JSNode.h"
#include "JSNodeFilter.h"
#include "JSNodeList.h"
#include "JSNotation.h"
#include "JSOverflowEvent.h"
#include "JSPlugin.h"
#include "JSPluginArray.h"
#include "JSProcessingInstruction.h"
#include "JSProgressEvent.h"
#include "JSRange.h"
#include "JSRangeException.h"
#include "JSRect.h"
#include "JSSVGAngle.h"
#include "JSSVGColor.h"
#include "JSSVGException.h"
#include "JSSVGGradientElement.h"
#include "JSSVGLength.h"
#include "JSSVGMarkerElement.h"
#include "JSSVGPaint.h"
#include "JSSVGPathSeg.h"
#include "JSSVGPreserveAspectRatio.h"
#include "JSSVGRenderingIntent.h"
#include "JSSVGTextContentElement.h"
#include "JSSVGTextPathElement.h"
#include "JSSVGTransform.h"
#include "JSSVGUnitTypes.h"
#include "JSScreen.h"
#include "JSStorage.h"
#include "JSStorageEvent.h"
#include "JSStyleSheet.h"
#include "JSStyleSheetList.h"
#include "JSText.h"
#include "JSTextEvent.h"
#include "JSTextMetrics.h"
#include "JSUIEvent.h"
#include "JSWheelEvent.h"
#include "JSXMLHttpRequestException.h"
#include "JSXMLHttpRequestUpload.h"
#include "JSXMLSerializer.h"
#include "JSXPathEvaluator.h"
#include "JSXPathException.h"
#include "JSXPathResult.h"
#include "KURL.h"
#include "Location.h"
#include "Navigator.h"
#include "Screen.h"
#include "Storage.h"

#include <runtime/Error.h>
#include <runtime/JSNumberCell.h>
#include <runtime/JSString.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSDOMWindow)

/* Hash table */

static const HashTableValue JSDOMWindowTableValues[221] =
{
    { "screen", DontDelete|ReadOnly, (intptr_t)jsDOMWindowScreen, (intptr_t)0 },
    { "history", DontDelete|ReadOnly, (intptr_t)jsDOMWindowHistory, (intptr_t)0 },
    { "locationbar", DontDelete, (intptr_t)jsDOMWindowLocationbar, (intptr_t)setJSDOMWindowLocationbar },
    { "menubar", DontDelete, (intptr_t)jsDOMWindowMenubar, (intptr_t)setJSDOMWindowMenubar },
    { "personalbar", DontDelete, (intptr_t)jsDOMWindowPersonalbar, (intptr_t)setJSDOMWindowPersonalbar },
    { "scrollbars", DontDelete, (intptr_t)jsDOMWindowScrollbars, (intptr_t)setJSDOMWindowScrollbars },
    { "statusbar", DontDelete, (intptr_t)jsDOMWindowStatusbar, (intptr_t)setJSDOMWindowStatusbar },
    { "toolbar", DontDelete, (intptr_t)jsDOMWindowToolbar, (intptr_t)setJSDOMWindowToolbar },
    { "navigator", DontDelete, (intptr_t)jsDOMWindowNavigator, (intptr_t)setJSDOMWindowNavigator },
    { "clientInformation", DontDelete, (intptr_t)jsDOMWindowClientInformation, (intptr_t)setJSDOMWindowClientInformation },
    { "location", DontDelete, (intptr_t)jsDOMWindowLocation, (intptr_t)setJSDOMWindowLocation },
    { "frameElement", DontDelete|ReadOnly, (intptr_t)jsDOMWindowFrameElement, (intptr_t)0 },
    { "offscreenBuffering", DontDelete, (intptr_t)jsDOMWindowOffscreenBuffering, (intptr_t)setJSDOMWindowOffscreenBuffering },
    { "outerHeight", DontDelete, (intptr_t)jsDOMWindowOuterHeight, (intptr_t)setJSDOMWindowOuterHeight },
    { "outerWidth", DontDelete, (intptr_t)jsDOMWindowOuterWidth, (intptr_t)setJSDOMWindowOuterWidth },
    { "innerHeight", DontDelete, (intptr_t)jsDOMWindowInnerHeight, (intptr_t)setJSDOMWindowInnerHeight },
    { "innerWidth", DontDelete, (intptr_t)jsDOMWindowInnerWidth, (intptr_t)setJSDOMWindowInnerWidth },
    { "screenX", DontDelete, (intptr_t)jsDOMWindowScreenX, (intptr_t)setJSDOMWindowScreenX },
    { "screenY", DontDelete, (intptr_t)jsDOMWindowScreenY, (intptr_t)setJSDOMWindowScreenY },
    { "screenLeft", DontDelete, (intptr_t)jsDOMWindowScreenLeft, (intptr_t)setJSDOMWindowScreenLeft },
    { "screenTop", DontDelete, (intptr_t)jsDOMWindowScreenTop, (intptr_t)setJSDOMWindowScreenTop },
    { "scrollX", DontDelete, (intptr_t)jsDOMWindowScrollX, (intptr_t)setJSDOMWindowScrollX },
    { "scrollY", DontDelete, (intptr_t)jsDOMWindowScrollY, (intptr_t)setJSDOMWindowScrollY },
    { "pageXOffset", DontDelete|ReadOnly, (intptr_t)jsDOMWindowPageXOffset, (intptr_t)0 },
    { "pageYOffset", DontDelete|ReadOnly, (intptr_t)jsDOMWindowPageYOffset, (intptr_t)0 },
    { "closed", DontDelete|ReadOnly, (intptr_t)jsDOMWindowClosed, (intptr_t)0 },
    { "length", DontDelete, (intptr_t)jsDOMWindowLength, (intptr_t)setJSDOMWindowLength },
    { "name", DontDelete, (intptr_t)jsDOMWindowName, (intptr_t)setJSDOMWindowName },
    { "status", DontDelete, (intptr_t)jsDOMWindowStatus, (intptr_t)setJSDOMWindowStatus },
    { "defaultStatus", DontDelete, (intptr_t)jsDOMWindowDefaultStatus, (intptr_t)setJSDOMWindowDefaultStatus },
    { "defaultstatus", DontDelete, (intptr_t)jsDOMWindowDefaultstatus, (intptr_t)setJSDOMWindowDefaultstatus },
    { "self", DontDelete, (intptr_t)jsDOMWindowSelf, (intptr_t)setJSDOMWindowSelf },
    { "window", DontDelete|ReadOnly, (intptr_t)jsDOMWindowWindow, (intptr_t)0 },
    { "frames", DontDelete, (intptr_t)jsDOMWindowFrames, (intptr_t)setJSDOMWindowFrames },
    { "opener", DontDelete, (intptr_t)jsDOMWindowOpener, (intptr_t)setJSDOMWindowOpener },
    { "parent", DontDelete, (intptr_t)jsDOMWindowParent, (intptr_t)setJSDOMWindowParent },
    { "top", DontDelete, (intptr_t)jsDOMWindowTop, (intptr_t)setJSDOMWindowTop },
    { "document", DontDelete|ReadOnly, (intptr_t)jsDOMWindowDocument, (intptr_t)0 },
    { "devicePixelRatio", DontDelete, (intptr_t)jsDOMWindowDevicePixelRatio, (intptr_t)setJSDOMWindowDevicePixelRatio },
    { "applicationCache", DontDelete|ReadOnly, (intptr_t)jsDOMWindowApplicationCache, (intptr_t)0 },
    { "sessionStorage", DontDelete|ReadOnly, (intptr_t)jsDOMWindowSessionStorage, (intptr_t)0 },
    { "localStorage", DontDelete|ReadOnly, (intptr_t)jsDOMWindowLocalStorage, (intptr_t)0 },
    { "console", DontDelete, (intptr_t)jsDOMWindowConsole, (intptr_t)setJSDOMWindowConsole },
    { "onabort", DontDelete, (intptr_t)jsDOMWindowOnabort, (intptr_t)setJSDOMWindowOnabort },
    { "onblur", DontDelete, (intptr_t)jsDOMWindowOnblur, (intptr_t)setJSDOMWindowOnblur },
    { "onchange", DontDelete, (intptr_t)jsDOMWindowOnchange, (intptr_t)setJSDOMWindowOnchange },
    { "onclick", DontDelete, (intptr_t)jsDOMWindowOnclick, (intptr_t)setJSDOMWindowOnclick },
    { "ondblclick", DontDelete, (intptr_t)jsDOMWindowOndblclick, (intptr_t)setJSDOMWindowOndblclick },
    { "onerror", DontDelete, (intptr_t)jsDOMWindowOnerror, (intptr_t)setJSDOMWindowOnerror },
    { "onfocus", DontDelete, (intptr_t)jsDOMWindowOnfocus, (intptr_t)setJSDOMWindowOnfocus },
    { "onkeydown", DontDelete, (intptr_t)jsDOMWindowOnkeydown, (intptr_t)setJSDOMWindowOnkeydown },
    { "onkeypress", DontDelete, (intptr_t)jsDOMWindowOnkeypress, (intptr_t)setJSDOMWindowOnkeypress },
    { "onkeyup", DontDelete, (intptr_t)jsDOMWindowOnkeyup, (intptr_t)setJSDOMWindowOnkeyup },
    { "onload", DontDelete, (intptr_t)jsDOMWindowOnload, (intptr_t)setJSDOMWindowOnload },
    { "onmousedown", DontDelete, (intptr_t)jsDOMWindowOnmousedown, (intptr_t)setJSDOMWindowOnmousedown },
    { "onmousemove", DontDelete, (intptr_t)jsDOMWindowOnmousemove, (intptr_t)setJSDOMWindowOnmousemove },
    { "onmouseout", DontDelete, (intptr_t)jsDOMWindowOnmouseout, (intptr_t)setJSDOMWindowOnmouseout },
    { "onmouseover", DontDelete, (intptr_t)jsDOMWindowOnmouseover, (intptr_t)setJSDOMWindowOnmouseover },
    { "onmouseup", DontDelete, (intptr_t)jsDOMWindowOnmouseup, (intptr_t)setJSDOMWindowOnmouseup },
    { "onmousewheel", DontDelete, (intptr_t)jsDOMWindowOnmousewheel, (intptr_t)setJSDOMWindowOnmousewheel },
    { "onreset", DontDelete, (intptr_t)jsDOMWindowOnreset, (intptr_t)setJSDOMWindowOnreset },
    { "onresize", DontDelete, (intptr_t)jsDOMWindowOnresize, (intptr_t)setJSDOMWindowOnresize },
    { "onscroll", DontDelete, (intptr_t)jsDOMWindowOnscroll, (intptr_t)setJSDOMWindowOnscroll },
    { "onsearch", DontDelete, (intptr_t)jsDOMWindowOnsearch, (intptr_t)setJSDOMWindowOnsearch },
    { "onselect", DontDelete, (intptr_t)jsDOMWindowOnselect, (intptr_t)setJSDOMWindowOnselect },
    { "onsubmit", DontDelete, (intptr_t)jsDOMWindowOnsubmit, (intptr_t)setJSDOMWindowOnsubmit },
    { "onunload", DontDelete, (intptr_t)jsDOMWindowOnunload, (intptr_t)setJSDOMWindowOnunload },
    { "onbeforeunload", DontDelete, (intptr_t)jsDOMWindowOnbeforeunload, (intptr_t)setJSDOMWindowOnbeforeunload },
    { "onwebkitanimationstart", DontDelete, (intptr_t)jsDOMWindowOnwebkitanimationstart, (intptr_t)setJSDOMWindowOnwebkitanimationstart },
    { "onwebkitanimationiteration", DontDelete, (intptr_t)jsDOMWindowOnwebkitanimationiteration, (intptr_t)setJSDOMWindowOnwebkitanimationiteration },
    { "onwebkitanimationend", DontDelete, (intptr_t)jsDOMWindowOnwebkitanimationend, (intptr_t)setJSDOMWindowOnwebkitanimationend },
    { "onwebkittransitionend", DontDelete, (intptr_t)jsDOMWindowOnwebkittransitionend, (intptr_t)setJSDOMWindowOnwebkittransitionend },
    { "StyleSheet", DontDelete, (intptr_t)jsDOMWindowStyleSheetConstructor, (intptr_t)setJSDOMWindowStyleSheetConstructor },
    { "CSSStyleSheet", DontDelete, (intptr_t)jsDOMWindowCSSStyleSheetConstructor, (intptr_t)setJSDOMWindowCSSStyleSheetConstructor },
    { "CSSValue", DontDelete, (intptr_t)jsDOMWindowCSSValueConstructor, (intptr_t)setJSDOMWindowCSSValueConstructor },
    { "CSSPrimitiveValue", DontDelete, (intptr_t)jsDOMWindowCSSPrimitiveValueConstructor, (intptr_t)setJSDOMWindowCSSPrimitiveValueConstructor },
    { "CSSValueList", DontDelete, (intptr_t)jsDOMWindowCSSValueListConstructor, (intptr_t)setJSDOMWindowCSSValueListConstructor },
    { "CSSRule", DontDelete, (intptr_t)jsDOMWindowCSSRuleConstructor, (intptr_t)setJSDOMWindowCSSRuleConstructor },
    { "CSSCharsetRule", DontDelete, (intptr_t)jsDOMWindowCSSCharsetRuleConstructor, (intptr_t)setJSDOMWindowCSSCharsetRuleConstructor },
    { "CSSFontFaceRule", DontDelete, (intptr_t)jsDOMWindowCSSFontFaceRuleConstructor, (intptr_t)setJSDOMWindowCSSFontFaceRuleConstructor },
    { "CSSImportRule", DontDelete, (intptr_t)jsDOMWindowCSSImportRuleConstructor, (intptr_t)setJSDOMWindowCSSImportRuleConstructor },
    { "CSSMediaRule", DontDelete, (intptr_t)jsDOMWindowCSSMediaRuleConstructor, (intptr_t)setJSDOMWindowCSSMediaRuleConstructor },
    { "CSSPageRule", DontDelete, (intptr_t)jsDOMWindowCSSPageRuleConstructor, (intptr_t)setJSDOMWindowCSSPageRuleConstructor },
    { "CSSStyleRule", DontDelete, (intptr_t)jsDOMWindowCSSStyleRuleConstructor, (intptr_t)setJSDOMWindowCSSStyleRuleConstructor },
    { "CSSVariablesRule", DontDelete, (intptr_t)jsDOMWindowCSSVariablesRuleConstructor, (intptr_t)setJSDOMWindowCSSVariablesRuleConstructor },
    { "CSSVariablesDeclaration", DontDelete, (intptr_t)jsDOMWindowCSSVariablesDeclarationConstructor, (intptr_t)setJSDOMWindowCSSVariablesDeclarationConstructor },
    { "CSSStyleDeclaration", DontDelete, (intptr_t)jsDOMWindowCSSStyleDeclarationConstructor, (intptr_t)setJSDOMWindowCSSStyleDeclarationConstructor },
    { "MediaList", DontDelete, (intptr_t)jsDOMWindowMediaListConstructor, (intptr_t)setJSDOMWindowMediaListConstructor },
    { "Counter", DontDelete, (intptr_t)jsDOMWindowCounterConstructor, (intptr_t)setJSDOMWindowCounterConstructor },
    { "CSSRuleList", DontDelete, (intptr_t)jsDOMWindowCSSRuleListConstructor, (intptr_t)setJSDOMWindowCSSRuleListConstructor },
    { "Rect", DontDelete, (intptr_t)jsDOMWindowRectConstructor, (intptr_t)setJSDOMWindowRectConstructor },
    { "StyleSheetList", DontDelete, (intptr_t)jsDOMWindowStyleSheetListConstructor, (intptr_t)setJSDOMWindowStyleSheetListConstructor },
    { "DOMException", DontDelete, (intptr_t)jsDOMWindowDOMExceptionConstructor, (intptr_t)setJSDOMWindowDOMExceptionConstructor },
    { "DOMImplementation", DontDelete, (intptr_t)jsDOMWindowDOMImplementationConstructor, (intptr_t)setJSDOMWindowDOMImplementationConstructor },
    { "DocumentFragment", DontDelete, (intptr_t)jsDOMWindowDocumentFragmentConstructor, (intptr_t)setJSDOMWindowDocumentFragmentConstructor },
    { "Document", DontDelete, (intptr_t)jsDOMWindowDocumentConstructor, (intptr_t)setJSDOMWindowDocumentConstructor },
    { "Node", DontDelete, (intptr_t)jsDOMWindowNodeConstructor, (intptr_t)setJSDOMWindowNodeConstructor },
    { "NodeList", DontDelete, (intptr_t)jsDOMWindowNodeListConstructor, (intptr_t)setJSDOMWindowNodeListConstructor },
    { "NamedNodeMap", DontDelete, (intptr_t)jsDOMWindowNamedNodeMapConstructor, (intptr_t)setJSDOMWindowNamedNodeMapConstructor },
    { "CharacterData", DontDelete, (intptr_t)jsDOMWindowCharacterDataConstructor, (intptr_t)setJSDOMWindowCharacterDataConstructor },
    { "Attr", DontDelete, (intptr_t)jsDOMWindowAttrConstructor, (intptr_t)setJSDOMWindowAttrConstructor },
    { "Element", DontDelete, (intptr_t)jsDOMWindowElementConstructor, (intptr_t)setJSDOMWindowElementConstructor },
    { "Text", DontDelete, (intptr_t)jsDOMWindowTextConstructor, (intptr_t)setJSDOMWindowTextConstructor },
    { "Comment", DontDelete, (intptr_t)jsDOMWindowCommentConstructor, (intptr_t)setJSDOMWindowCommentConstructor },
    { "CDATASection", DontDelete, (intptr_t)jsDOMWindowCDATASectionConstructor, (intptr_t)setJSDOMWindowCDATASectionConstructor },
    { "DocumentType", DontDelete, (intptr_t)jsDOMWindowDocumentTypeConstructor, (intptr_t)setJSDOMWindowDocumentTypeConstructor },
    { "Notation", DontDelete, (intptr_t)jsDOMWindowNotationConstructor, (intptr_t)setJSDOMWindowNotationConstructor },
    { "Entity", DontDelete, (intptr_t)jsDOMWindowEntityConstructor, (intptr_t)setJSDOMWindowEntityConstructor },
    { "EntityReference", DontDelete, (intptr_t)jsDOMWindowEntityReferenceConstructor, (intptr_t)setJSDOMWindowEntityReferenceConstructor },
    { "ProcessingInstruction", DontDelete, (intptr_t)jsDOMWindowProcessingInstructionConstructor, (intptr_t)setJSDOMWindowProcessingInstructionConstructor },
    { "HTMLDocument", DontDelete, (intptr_t)jsDOMWindowHTMLDocumentConstructor, (intptr_t)setJSDOMWindowHTMLDocumentConstructor },
    { "HTMLElement", DontDelete, (intptr_t)jsDOMWindowHTMLElementConstructor, (intptr_t)setJSDOMWindowHTMLElementConstructor },
    { "HTMLAnchorElement", DontDelete, (intptr_t)jsDOMWindowHTMLAnchorElementConstructor, (intptr_t)setJSDOMWindowHTMLAnchorElementConstructor },
    { "HTMLAppletElement", DontDelete, (intptr_t)jsDOMWindowHTMLAppletElementConstructor, (intptr_t)setJSDOMWindowHTMLAppletElementConstructor },
    { "HTMLAreaElement", DontDelete, (intptr_t)jsDOMWindowHTMLAreaElementConstructor, (intptr_t)setJSDOMWindowHTMLAreaElementConstructor },
    { "HTMLBRElement", DontDelete, (intptr_t)jsDOMWindowHTMLBRElementConstructor, (intptr_t)setJSDOMWindowHTMLBRElementConstructor },
    { "HTMLBaseElement", DontDelete, (intptr_t)jsDOMWindowHTMLBaseElementConstructor, (intptr_t)setJSDOMWindowHTMLBaseElementConstructor },
    { "HTMLBaseFontElement", DontDelete, (intptr_t)jsDOMWindowHTMLBaseFontElementConstructor, (intptr_t)setJSDOMWindowHTMLBaseFontElementConstructor },
    { "HTMLBlockquoteElement", DontDelete, (intptr_t)jsDOMWindowHTMLBlockquoteElementConstructor, (intptr_t)setJSDOMWindowHTMLBlockquoteElementConstructor },
    { "HTMLBodyElement", DontDelete, (intptr_t)jsDOMWindowHTMLBodyElementConstructor, (intptr_t)setJSDOMWindowHTMLBodyElementConstructor },
    { "HTMLButtonElement", DontDelete, (intptr_t)jsDOMWindowHTMLButtonElementConstructor, (intptr_t)setJSDOMWindowHTMLButtonElementConstructor },
    { "HTMLCanvasElement", DontDelete, (intptr_t)jsDOMWindowHTMLCanvasElementConstructor, (intptr_t)setJSDOMWindowHTMLCanvasElementConstructor },
    { "HTMLDListElement", DontDelete, (intptr_t)jsDOMWindowHTMLDListElementConstructor, (intptr_t)setJSDOMWindowHTMLDListElementConstructor },
    { "HTMLDirectoryElement", DontDelete, (intptr_t)jsDOMWindowHTMLDirectoryElementConstructor, (intptr_t)setJSDOMWindowHTMLDirectoryElementConstructor },
    { "HTMLDivElement", DontDelete, (intptr_t)jsDOMWindowHTMLDivElementConstructor, (intptr_t)setJSDOMWindowHTMLDivElementConstructor },
    { "HTMLEmbedElement", DontDelete, (intptr_t)jsDOMWindowHTMLEmbedElementConstructor, (intptr_t)setJSDOMWindowHTMLEmbedElementConstructor },
    { "HTMLFieldSetElement", DontDelete, (intptr_t)jsDOMWindowHTMLFieldSetElementConstructor, (intptr_t)setJSDOMWindowHTMLFieldSetElementConstructor },
    { "HTMLFontElement", DontDelete, (intptr_t)jsDOMWindowHTMLFontElementConstructor, (intptr_t)setJSDOMWindowHTMLFontElementConstructor },
    { "HTMLFormElement", DontDelete, (intptr_t)jsDOMWindowHTMLFormElementConstructor, (intptr_t)setJSDOMWindowHTMLFormElementConstructor },
    { "HTMLFrameElement", DontDelete, (intptr_t)jsDOMWindowHTMLFrameElementConstructor, (intptr_t)setJSDOMWindowHTMLFrameElementConstructor },
    { "HTMLFrameSetElement", DontDelete, (intptr_t)jsDOMWindowHTMLFrameSetElementConstructor, (intptr_t)setJSDOMWindowHTMLFrameSetElementConstructor },
    { "HTMLHRElement", DontDelete, (intptr_t)jsDOMWindowHTMLHRElementConstructor, (intptr_t)setJSDOMWindowHTMLHRElementConstructor },
    { "HTMLHeadElement", DontDelete, (intptr_t)jsDOMWindowHTMLHeadElementConstructor, (intptr_t)setJSDOMWindowHTMLHeadElementConstructor },
    { "HTMLHeadingElement", DontDelete, (intptr_t)jsDOMWindowHTMLHeadingElementConstructor, (intptr_t)setJSDOMWindowHTMLHeadingElementConstructor },
    { "HTMLHtmlElement", DontDelete, (intptr_t)jsDOMWindowHTMLHtmlElementConstructor, (intptr_t)setJSDOMWindowHTMLHtmlElementConstructor },
    { "HTMLIFrameElement", DontDelete, (intptr_t)jsDOMWindowHTMLIFrameElementConstructor, (intptr_t)setJSDOMWindowHTMLIFrameElementConstructor },
    { "HTMLImageElement", DontDelete, (intptr_t)jsDOMWindowHTMLImageElementConstructor, (intptr_t)setJSDOMWindowHTMLImageElementConstructor },
    { "HTMLInputElement", DontDelete, (intptr_t)jsDOMWindowHTMLInputElementConstructor, (intptr_t)setJSDOMWindowHTMLInputElementConstructor },
    { "HTMLIsIndexElement", DontDelete, (intptr_t)jsDOMWindowHTMLIsIndexElementConstructor, (intptr_t)setJSDOMWindowHTMLIsIndexElementConstructor },
    { "HTMLLIElement", DontDelete, (intptr_t)jsDOMWindowHTMLLIElementConstructor, (intptr_t)setJSDOMWindowHTMLLIElementConstructor },
    { "HTMLLabelElement", DontDelete, (intptr_t)jsDOMWindowHTMLLabelElementConstructor, (intptr_t)setJSDOMWindowHTMLLabelElementConstructor },
    { "HTMLLegendElement", DontDelete, (intptr_t)jsDOMWindowHTMLLegendElementConstructor, (intptr_t)setJSDOMWindowHTMLLegendElementConstructor },
    { "HTMLLinkElement", DontDelete, (intptr_t)jsDOMWindowHTMLLinkElementConstructor, (intptr_t)setJSDOMWindowHTMLLinkElementConstructor },
    { "HTMLMapElement", DontDelete, (intptr_t)jsDOMWindowHTMLMapElementConstructor, (intptr_t)setJSDOMWindowHTMLMapElementConstructor },
    { "HTMLMarqueeElement", DontDelete, (intptr_t)jsDOMWindowHTMLMarqueeElementConstructor, (intptr_t)setJSDOMWindowHTMLMarqueeElementConstructor },
    { "HTMLMenuElement", DontDelete, (intptr_t)jsDOMWindowHTMLMenuElementConstructor, (intptr_t)setJSDOMWindowHTMLMenuElementConstructor },
    { "HTMLMetaElement", DontDelete, (intptr_t)jsDOMWindowHTMLMetaElementConstructor, (intptr_t)setJSDOMWindowHTMLMetaElementConstructor },
    { "HTMLModElement", DontDelete, (intptr_t)jsDOMWindowHTMLModElementConstructor, (intptr_t)setJSDOMWindowHTMLModElementConstructor },
    { "HTMLOListElement", DontDelete, (intptr_t)jsDOMWindowHTMLOListElementConstructor, (intptr_t)setJSDOMWindowHTMLOListElementConstructor },
    { "HTMLObjectElement", DontDelete, (intptr_t)jsDOMWindowHTMLObjectElementConstructor, (intptr_t)setJSDOMWindowHTMLObjectElementConstructor },
    { "HTMLOptGroupElement", DontDelete, (intptr_t)jsDOMWindowHTMLOptGroupElementConstructor, (intptr_t)setJSDOMWindowHTMLOptGroupElementConstructor },
    { "HTMLOptionElement", DontDelete, (intptr_t)jsDOMWindowHTMLOptionElementConstructor, (intptr_t)setJSDOMWindowHTMLOptionElementConstructor },
    { "HTMLParagraphElement", DontDelete, (intptr_t)jsDOMWindowHTMLParagraphElementConstructor, (intptr_t)setJSDOMWindowHTMLParagraphElementConstructor },
    { "HTMLParamElement", DontDelete, (intptr_t)jsDOMWindowHTMLParamElementConstructor, (intptr_t)setJSDOMWindowHTMLParamElementConstructor },
    { "HTMLPreElement", DontDelete, (intptr_t)jsDOMWindowHTMLPreElementConstructor, (intptr_t)setJSDOMWindowHTMLPreElementConstructor },
    { "HTMLQuoteElement", DontDelete, (intptr_t)jsDOMWindowHTMLQuoteElementConstructor, (intptr_t)setJSDOMWindowHTMLQuoteElementConstructor },
    { "HTMLScriptElement", DontDelete, (intptr_t)jsDOMWindowHTMLScriptElementConstructor, (intptr_t)setJSDOMWindowHTMLScriptElementConstructor },
    { "HTMLSelectElement", DontDelete, (intptr_t)jsDOMWindowHTMLSelectElementConstructor, (intptr_t)setJSDOMWindowHTMLSelectElementConstructor },
    { "HTMLStyleElement", DontDelete, (intptr_t)jsDOMWindowHTMLStyleElementConstructor, (intptr_t)setJSDOMWindowHTMLStyleElementConstructor },
    { "HTMLTableCaptionElement", DontDelete, (intptr_t)jsDOMWindowHTMLTableCaptionElementConstructor, (intptr_t)setJSDOMWindowHTMLTableCaptionElementConstructor },
    { "HTMLTableCellElement", DontDelete, (intptr_t)jsDOMWindowHTMLTableCellElementConstructor, (intptr_t)setJSDOMWindowHTMLTableCellElementConstructor },
    { "HTMLTableColElement", DontDelete, (intptr_t)jsDOMWindowHTMLTableColElementConstructor, (intptr_t)setJSDOMWindowHTMLTableColElementConstructor },
    { "HTMLTableElement", DontDelete, (intptr_t)jsDOMWindowHTMLTableElementConstructor, (intptr_t)setJSDOMWindowHTMLTableElementConstructor },
    { "HTMLTableRowElement", DontDelete, (intptr_t)jsDOMWindowHTMLTableRowElementConstructor, (intptr_t)setJSDOMWindowHTMLTableRowElementConstructor },
    { "HTMLTableSectionElement", DontDelete, (intptr_t)jsDOMWindowHTMLTableSectionElementConstructor, (intptr_t)setJSDOMWindowHTMLTableSectionElementConstructor },
    { "HTMLTextAreaElement", DontDelete, (intptr_t)jsDOMWindowHTMLTextAreaElementConstructor, (intptr_t)setJSDOMWindowHTMLTextAreaElementConstructor },
    { "HTMLTitleElement", DontDelete, (intptr_t)jsDOMWindowHTMLTitleElementConstructor, (intptr_t)setJSDOMWindowHTMLTitleElementConstructor },
    { "HTMLUListElement", DontDelete, (intptr_t)jsDOMWindowHTMLUListElementConstructor, (intptr_t)setJSDOMWindowHTMLUListElementConstructor },
    { "HTMLCollection", DontDelete, (intptr_t)jsDOMWindowHTMLCollectionConstructor, (intptr_t)setJSDOMWindowHTMLCollectionConstructor },
    { "CanvasRenderingContext2D", DontDelete, (intptr_t)jsDOMWindowCanvasRenderingContext2DConstructor, (intptr_t)setJSDOMWindowCanvasRenderingContext2DConstructor },
    { "TextMetrics", DontDelete, (intptr_t)jsDOMWindowTextMetricsConstructor, (intptr_t)setJSDOMWindowTextMetricsConstructor },
    { "Event", DontDelete, (intptr_t)jsDOMWindowEventConstructor, (intptr_t)setJSDOMWindowEventConstructor },
    { "KeyboardEvent", DontDelete, (intptr_t)jsDOMWindowKeyboardEventConstructor, (intptr_t)setJSDOMWindowKeyboardEventConstructor },
    { "MouseEvent", DontDelete, (intptr_t)jsDOMWindowMouseEventConstructor, (intptr_t)setJSDOMWindowMouseEventConstructor },
    { "MutationEvent", DontDelete, (intptr_t)jsDOMWindowMutationEventConstructor, (intptr_t)setJSDOMWindowMutationEventConstructor },
    { "OverflowEvent", DontDelete, (intptr_t)jsDOMWindowOverflowEventConstructor, (intptr_t)setJSDOMWindowOverflowEventConstructor },
    { "ProgressEvent", DontDelete, (intptr_t)jsDOMWindowProgressEventConstructor, (intptr_t)setJSDOMWindowProgressEventConstructor },
    { "TextEvent", DontDelete, (intptr_t)jsDOMWindowTextEventConstructor, (intptr_t)setJSDOMWindowTextEventConstructor },
    { "UIEvent", DontDelete, (intptr_t)jsDOMWindowUIEventConstructor, (intptr_t)setJSDOMWindowUIEventConstructor },
    { "WheelEvent", DontDelete, (intptr_t)jsDOMWindowWheelEventConstructor, (intptr_t)setJSDOMWindowWheelEventConstructor },
    { "MessageEvent", DontDelete, (intptr_t)jsDOMWindowMessageEventConstructor, (intptr_t)setJSDOMWindowMessageEventConstructor },
    { "EventException", DontDelete, (intptr_t)jsDOMWindowEventExceptionConstructor, (intptr_t)setJSDOMWindowEventExceptionConstructor },
    { "Clipboard", DontDelete, (intptr_t)jsDOMWindowClipboardConstructor, (intptr_t)setJSDOMWindowClipboardConstructor },
    { "File", DontDelete, (intptr_t)jsDOMWindowFileConstructor, (intptr_t)setJSDOMWindowFileConstructor },
    { "FileList", DontDelete, (intptr_t)jsDOMWindowFileListConstructor, (intptr_t)setJSDOMWindowFileListConstructor },
    { "NodeFilter", DontDelete, (intptr_t)jsDOMWindowNodeFilterConstructor, (intptr_t)setJSDOMWindowNodeFilterConstructor },
    { "Range", DontDelete, (intptr_t)jsDOMWindowRangeConstructor, (intptr_t)setJSDOMWindowRangeConstructor },
    { "RangeException", DontDelete, (intptr_t)jsDOMWindowRangeExceptionConstructor, (intptr_t)setJSDOMWindowRangeExceptionConstructor },
    { "XMLDocument", DontDelete, (intptr_t)jsDOMWindowXMLDocumentConstructor, (intptr_t)setJSDOMWindowXMLDocumentConstructor },
    { "DOMParser", DontDelete, (intptr_t)jsDOMWindowDOMParserConstructor, (intptr_t)setJSDOMWindowDOMParserConstructor },
    { "XMLSerializer", DontDelete, (intptr_t)jsDOMWindowXMLSerializerConstructor, (intptr_t)setJSDOMWindowXMLSerializerConstructor },
    { "XMLHttpRequestUpload", DontDelete, (intptr_t)jsDOMWindowXMLHttpRequestUploadConstructor, (intptr_t)setJSDOMWindowXMLHttpRequestUploadConstructor },
    { "XMLHttpRequestException", DontDelete, (intptr_t)jsDOMWindowXMLHttpRequestExceptionConstructor, (intptr_t)setJSDOMWindowXMLHttpRequestExceptionConstructor },
    { "Plugin", DontDelete, (intptr_t)jsDOMWindowPluginConstructor, (intptr_t)setJSDOMWindowPluginConstructor },
    { "PluginArray", DontDelete, (intptr_t)jsDOMWindowPluginArrayConstructor, (intptr_t)setJSDOMWindowPluginArrayConstructor },
    { "MimeType", DontDelete, (intptr_t)jsDOMWindowMimeTypeConstructor, (intptr_t)setJSDOMWindowMimeTypeConstructor },
    { "MimeTypeArray", DontDelete, (intptr_t)jsDOMWindowMimeTypeArrayConstructor, (intptr_t)setJSDOMWindowMimeTypeArrayConstructor },
    { "Storage", DontDelete, (intptr_t)jsDOMWindowStorageConstructor, (intptr_t)setJSDOMWindowStorageConstructor },
    { "StorageEvent", DontDelete, (intptr_t)jsDOMWindowStorageEventConstructor, (intptr_t)setJSDOMWindowStorageEventConstructor },
#if ENABLE(VIDEO)
    { "HTMLAudioElement", DontDelete, (intptr_t)jsDOMWindowHTMLAudioElementConstructor, (intptr_t)setJSDOMWindowHTMLAudioElementConstructor },
#endif
#if ENABLE(VIDEO)
    { "HTMLMediaElement", DontDelete, (intptr_t)jsDOMWindowHTMLMediaElementConstructor, (intptr_t)setJSDOMWindowHTMLMediaElementConstructor },
#endif
#if ENABLE(VIDEO)
    { "HTMLVideoElement", DontDelete, (intptr_t)jsDOMWindowHTMLVideoElementConstructor, (intptr_t)setJSDOMWindowHTMLVideoElementConstructor },
#endif
#if ENABLE(VIDEO)
    { "MediaError", DontDelete, (intptr_t)jsDOMWindowMediaErrorConstructor, (intptr_t)setJSDOMWindowMediaErrorConstructor },
#endif
    { "XPathEvaluator", DontDelete, (intptr_t)jsDOMWindowXPathEvaluatorConstructor, (intptr_t)setJSDOMWindowXPathEvaluatorConstructor },
    { "XPathResult", DontDelete, (intptr_t)jsDOMWindowXPathResultConstructor, (intptr_t)setJSDOMWindowXPathResultConstructor },
    { "XPathException", DontDelete, (intptr_t)jsDOMWindowXPathExceptionConstructor, (intptr_t)setJSDOMWindowXPathExceptionConstructor },
    { "SVGAngle", DontDelete, (intptr_t)jsDOMWindowSVGAngleConstructor, (intptr_t)setJSDOMWindowSVGAngleConstructor },
    { "SVGColor", DontDelete, (intptr_t)jsDOMWindowSVGColorConstructor, (intptr_t)setJSDOMWindowSVGColorConstructor },
    { "SVGException", DontDelete, (intptr_t)jsDOMWindowSVGExceptionConstructor, (intptr_t)setJSDOMWindowSVGExceptionConstructor },
    { "SVGGradientElement", DontDelete, (intptr_t)jsDOMWindowSVGGradientElementConstructor, (intptr_t)setJSDOMWindowSVGGradientElementConstructor },
    { "SVGLength", DontDelete, (intptr_t)jsDOMWindowSVGLengthConstructor, (intptr_t)setJSDOMWindowSVGLengthConstructor },
    { "SVGMarkerElement", DontDelete, (intptr_t)jsDOMWindowSVGMarkerElementConstructor, (intptr_t)setJSDOMWindowSVGMarkerElementConstructor },
    { "SVGPaint", DontDelete, (intptr_t)jsDOMWindowSVGPaintConstructor, (intptr_t)setJSDOMWindowSVGPaintConstructor },
    { "SVGPathSeg", DontDelete, (intptr_t)jsDOMWindowSVGPathSegConstructor, (intptr_t)setJSDOMWindowSVGPathSegConstructor },
    { "SVGPreserveAspectRatio", DontDelete, (intptr_t)jsDOMWindowSVGPreserveAspectRatioConstructor, (intptr_t)setJSDOMWindowSVGPreserveAspectRatioConstructor },
    { "SVGRenderingIntent", DontDelete, (intptr_t)jsDOMWindowSVGRenderingIntentConstructor, (intptr_t)setJSDOMWindowSVGRenderingIntentConstructor },
    { "SVGTextContentElement", DontDelete, (intptr_t)jsDOMWindowSVGTextContentElementConstructor, (intptr_t)setJSDOMWindowSVGTextContentElementConstructor },
    { "SVGTextPathElement", DontDelete, (intptr_t)jsDOMWindowSVGTextPathElementConstructor, (intptr_t)setJSDOMWindowSVGTextPathElementConstructor },
    { "SVGTransform", DontDelete, (intptr_t)jsDOMWindowSVGTransformConstructor, (intptr_t)setJSDOMWindowSVGTransformConstructor },
    { "SVGUnitTypes", DontDelete, (intptr_t)jsDOMWindowSVGUnitTypesConstructor, (intptr_t)setJSDOMWindowSVGUnitTypesConstructor },
    { 0, 0, 0, 0 }
};

static const HashTable JSDOMWindowTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 32767, JSDOMWindowTableValues, 0 };
#else
    { 551, 511, JSDOMWindowTableValues, 0 };
#endif

/* Hash table for prototype */

static const HashTableValue JSDOMWindowPrototypeTableValues[30] =
{
    { "getSelection", DontDelete|Function, (intptr_t)jsDOMWindowPrototypeFunctionGetSelection, (intptr_t)0 },
    { "focus", DontDelete|Function, (intptr_t)jsDOMWindowPrototypeFunctionFocus, (intptr_t)0 },
    { "blur", DontDelete|Function, (intptr_t)jsDOMWindowPrototypeFunctionBlur, (intptr_t)0 },
    { "close", DontDelete|Function, (intptr_t)jsDOMWindowPrototypeFunctionClose, (intptr_t)0 },
    { "print", DontDelete|Function, (intptr_t)jsDOMWindowPrototypeFunctionPrint, (intptr_t)0 },
    { "stop", DontDelete|Function, (intptr_t)jsDOMWindowPrototypeFunctionStop, (intptr_t)0 },
    { "alert", DontDelete|Function, (intptr_t)jsDOMWindowPrototypeFunctionAlert, (intptr_t)1 },
    { "confirm", DontDelete|Function, (intptr_t)jsDOMWindowPrototypeFunctionConfirm, (intptr_t)1 },
    { "prompt", DontDelete|Function, (intptr_t)jsDOMWindowPrototypeFunctionPrompt, (intptr_t)2 },
    { "find", DontDelete|Function, (intptr_t)jsDOMWindowPrototypeFunctionFind, (intptr_t)7 },
    { "scrollBy", DontDelete|Function, (intptr_t)jsDOMWindowPrototypeFunctionScrollBy, (intptr_t)2 },
    { "scrollTo", DontDelete|Function, (intptr_t)jsDOMWindowPrototypeFunctionScrollTo, (intptr_t)2 },
    { "scroll", DontDelete|Function, (intptr_t)jsDOMWindowPrototypeFunctionScroll, (intptr_t)2 },
    { "moveBy", DontDelete|Function, (intptr_t)jsDOMWindowPrototypeFunctionMoveBy, (intptr_t)2 },
    { "moveTo", DontDelete|Function, (intptr_t)jsDOMWindowPrototypeFunctionMoveTo, (intptr_t)2 },
    { "resizeBy", DontDelete|Function, (intptr_t)jsDOMWindowPrototypeFunctionResizeBy, (intptr_t)2 },
    { "resizeTo", DontDelete|Function, (intptr_t)jsDOMWindowPrototypeFunctionResizeTo, (intptr_t)2 },
    { "getComputedStyle", DontDelete|Function, (intptr_t)jsDOMWindowPrototypeFunctionGetComputedStyle, (intptr_t)2 },
    { "getMatchedCSSRules", DontDelete|Function, (intptr_t)jsDOMWindowPrototypeFunctionGetMatchedCSSRules, (intptr_t)3 },
    { "openDatabase", DontDelete|Function, (intptr_t)jsDOMWindowPrototypeFunctionOpenDatabase, (intptr_t)4 },
    { "postMessage", DontDelete|Function, (intptr_t)jsDOMWindowPrototypeFunctionPostMessage, (intptr_t)3 },
    { "setTimeout", DontDelete|Function, (intptr_t)jsDOMWindowPrototypeFunctionSetTimeout, (intptr_t)2 },
    { "clearTimeout", DontDelete|Function, (intptr_t)jsDOMWindowPrototypeFunctionClearTimeout, (intptr_t)1 },
    { "setInterval", DontDelete|Function, (intptr_t)jsDOMWindowPrototypeFunctionSetInterval, (intptr_t)2 },
    { "clearInterval", DontDelete|Function, (intptr_t)jsDOMWindowPrototypeFunctionClearInterval, (intptr_t)1 },
    { "atob", DontDelete|Function, (intptr_t)jsDOMWindowPrototypeFunctionAtob, (intptr_t)1 },
    { "btoa", DontDelete|Function, (intptr_t)jsDOMWindowPrototypeFunctionBtoa, (intptr_t)1 },
    { "addEventListener", DontDelete|Function, (intptr_t)jsDOMWindowPrototypeFunctionAddEventListener, (intptr_t)3 },
    { "removeEventListener", DontDelete|Function, (intptr_t)jsDOMWindowPrototypeFunctionRemoveEventListener, (intptr_t)3 },
    { 0, 0, 0, 0 }
};

static const HashTable JSDOMWindowPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 511, JSDOMWindowPrototypeTableValues, 0 };
#else
    { 69, 63, JSDOMWindowPrototypeTableValues, 0 };
#endif

const ClassInfo JSDOMWindowPrototype::s_info = { "DOMWindowPrototype", 0, &JSDOMWindowPrototypeTable, 0 };

void* JSDOMWindowPrototype::operator new(size_t size)
{
    return JSDOMWindow::commonJSGlobalData()->heap.allocate(size);
}

bool JSDOMWindowPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSDOMWindowPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSDOMWindow::s_info = { "DOMWindow", &JSDOMWindowBase::s_info, &JSDOMWindowTable, 0 };

JSDOMWindow::JSDOMWindow(PassRefPtr<Structure> structure, PassRefPtr<DOMWindow> impl, JSDOMWindowShell* shell)
    : JSDOMWindowBase(structure, impl, shell)
{
}

bool JSDOMWindow::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    if (customGetOwnPropertySlot(exec, propertyName, slot))
        return true;
    return getStaticValueSlot<JSDOMWindow, Base>(exec, &JSDOMWindowTable, this, propertyName, slot);
}

JSValue* jsDOMWindowScreen(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->screen()));
}

JSValue* jsDOMWindowHistory(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->history()));
}

JSValue* jsDOMWindowLocationbar(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->locationbar()));
}

JSValue* jsDOMWindowMenubar(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->menubar()));
}

JSValue* jsDOMWindowPersonalbar(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->personalbar()));
}

JSValue* jsDOMWindowScrollbars(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->scrollbars()));
}

JSValue* jsDOMWindowStatusbar(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->statusbar()));
}

JSValue* jsDOMWindowToolbar(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->toolbar()));
}

JSValue* jsDOMWindowNavigator(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->navigator()));
}

JSValue* jsDOMWindowClientInformation(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->clientInformation()));
}

JSValue* jsDOMWindowLocation(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->location()));
}

JSValue* jsDOMWindowFrameElement(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->impl());
    return checkNodeSecurity(exec, imp->frameElement()) ? toJS(exec, WTF::getPtr(imp->frameElement())) : jsUndefined();
}

JSValue* jsDOMWindowOffscreenBuffering(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->impl());
    return jsBoolean(imp->offscreenBuffering());
}

JSValue* jsDOMWindowOuterHeight(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->outerHeight());
}

JSValue* jsDOMWindowOuterWidth(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->outerWidth());
}

JSValue* jsDOMWindowInnerHeight(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->innerHeight());
}

JSValue* jsDOMWindowInnerWidth(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->innerWidth());
}

JSValue* jsDOMWindowScreenX(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->screenX());
}

JSValue* jsDOMWindowScreenY(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->screenY());
}

JSValue* jsDOMWindowScreenLeft(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->screenLeft());
}

JSValue* jsDOMWindowScreenTop(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->screenTop());
}

JSValue* jsDOMWindowScrollX(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->scrollX());
}

JSValue* jsDOMWindowScrollY(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->scrollY());
}

JSValue* jsDOMWindowPageXOffset(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->pageXOffset());
}

JSValue* jsDOMWindowPageYOffset(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->pageYOffset());
}

JSValue* jsDOMWindowClosed(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->impl());
    return jsBoolean(imp->closed());
}

JSValue* jsDOMWindowLength(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->length());
}

JSValue* jsDOMWindowName(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->name());
}

JSValue* jsDOMWindowStatus(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->status());
}

JSValue* jsDOMWindowDefaultStatus(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->defaultStatus());
}

JSValue* jsDOMWindowDefaultstatus(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->defaultstatus());
}

JSValue* jsDOMWindowSelf(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->self()));
}

JSValue* jsDOMWindowWindow(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->window()));
}

JSValue* jsDOMWindowFrames(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->frames()));
}

JSValue* jsDOMWindowOpener(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->opener()));
}

JSValue* jsDOMWindowParent(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->parent()));
}

JSValue* jsDOMWindowTop(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->top()));
}

JSValue* jsDOMWindowDocument(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->document()));
}

JSValue* jsDOMWindowDevicePixelRatio(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->devicePixelRatio());
}

JSValue* jsDOMWindowApplicationCache(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->applicationCache()));
}

JSValue* jsDOMWindowSessionStorage(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->sessionStorage()));
}

JSValue* jsDOMWindowLocalStorage(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->localStorage()));
}

JSValue* jsDOMWindowConsole(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->console()));
}

JSValue* jsDOMWindowOnabort(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->impl());
    if (JSEventListener* listener = static_cast<JSEventListener*>(imp->onabort())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValue* jsDOMWindowOnblur(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->impl());
    if (JSEventListener* listener = static_cast<JSEventListener*>(imp->onblur())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValue* jsDOMWindowOnchange(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->impl());
    if (JSEventListener* listener = static_cast<JSEventListener*>(imp->onchange())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValue* jsDOMWindowOnclick(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->impl());
    if (JSEventListener* listener = static_cast<JSEventListener*>(imp->onclick())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValue* jsDOMWindowOndblclick(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->impl());
    if (JSEventListener* listener = static_cast<JSEventListener*>(imp->ondblclick())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValue* jsDOMWindowOnerror(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->impl());
    if (JSEventListener* listener = static_cast<JSEventListener*>(imp->onerror())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValue* jsDOMWindowOnfocus(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->impl());
    if (JSEventListener* listener = static_cast<JSEventListener*>(imp->onfocus())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValue* jsDOMWindowOnkeydown(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->impl());
    if (JSEventListener* listener = static_cast<JSEventListener*>(imp->onkeydown())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValue* jsDOMWindowOnkeypress(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->impl());
    if (JSEventListener* listener = static_cast<JSEventListener*>(imp->onkeypress())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValue* jsDOMWindowOnkeyup(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->impl());
    if (JSEventListener* listener = static_cast<JSEventListener*>(imp->onkeyup())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValue* jsDOMWindowOnload(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->impl());
    if (JSEventListener* listener = static_cast<JSEventListener*>(imp->onload())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValue* jsDOMWindowOnmousedown(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->impl());
    if (JSEventListener* listener = static_cast<JSEventListener*>(imp->onmousedown())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValue* jsDOMWindowOnmousemove(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->impl());
    if (JSEventListener* listener = static_cast<JSEventListener*>(imp->onmousemove())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValue* jsDOMWindowOnmouseout(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->impl());
    if (JSEventListener* listener = static_cast<JSEventListener*>(imp->onmouseout())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValue* jsDOMWindowOnmouseover(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->impl());
    if (JSEventListener* listener = static_cast<JSEventListener*>(imp->onmouseover())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValue* jsDOMWindowOnmouseup(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->impl());
    if (JSEventListener* listener = static_cast<JSEventListener*>(imp->onmouseup())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValue* jsDOMWindowOnmousewheel(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->impl());
    if (JSEventListener* listener = static_cast<JSEventListener*>(imp->onmousewheel())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValue* jsDOMWindowOnreset(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->impl());
    if (JSEventListener* listener = static_cast<JSEventListener*>(imp->onreset())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValue* jsDOMWindowOnresize(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->impl());
    if (JSEventListener* listener = static_cast<JSEventListener*>(imp->onresize())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValue* jsDOMWindowOnscroll(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->impl());
    if (JSEventListener* listener = static_cast<JSEventListener*>(imp->onscroll())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValue* jsDOMWindowOnsearch(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->impl());
    if (JSEventListener* listener = static_cast<JSEventListener*>(imp->onsearch())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValue* jsDOMWindowOnselect(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->impl());
    if (JSEventListener* listener = static_cast<JSEventListener*>(imp->onselect())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValue* jsDOMWindowOnsubmit(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->impl());
    if (JSEventListener* listener = static_cast<JSEventListener*>(imp->onsubmit())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValue* jsDOMWindowOnunload(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->impl());
    if (JSEventListener* listener = static_cast<JSEventListener*>(imp->onunload())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValue* jsDOMWindowOnbeforeunload(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->impl());
    if (JSEventListener* listener = static_cast<JSEventListener*>(imp->onbeforeunload())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValue* jsDOMWindowOnwebkitanimationstart(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->impl());
    if (JSEventListener* listener = static_cast<JSEventListener*>(imp->onwebkitanimationstart())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValue* jsDOMWindowOnwebkitanimationiteration(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->impl());
    if (JSEventListener* listener = static_cast<JSEventListener*>(imp->onwebkitanimationiteration())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValue* jsDOMWindowOnwebkitanimationend(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->impl());
    if (JSEventListener* listener = static_cast<JSEventListener*>(imp->onwebkitanimationend())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValue* jsDOMWindowOnwebkittransitionend(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->impl());
    if (JSEventListener* listener = static_cast<JSEventListener*>(imp->onwebkittransitionend())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValue* jsDOMWindowStyleSheetConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSStyleSheet::getConstructor(exec);
}

JSValue* jsDOMWindowCSSStyleSheetConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSCSSStyleSheet::getConstructor(exec);
}

JSValue* jsDOMWindowCSSValueConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSCSSValue::getConstructor(exec);
}

JSValue* jsDOMWindowCSSPrimitiveValueConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSCSSPrimitiveValue::getConstructor(exec);
}

JSValue* jsDOMWindowCSSValueListConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSCSSValueList::getConstructor(exec);
}

JSValue* jsDOMWindowCSSRuleConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSCSSRule::getConstructor(exec);
}

JSValue* jsDOMWindowCSSCharsetRuleConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSCSSCharsetRule::getConstructor(exec);
}

JSValue* jsDOMWindowCSSFontFaceRuleConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSCSSFontFaceRule::getConstructor(exec);
}

JSValue* jsDOMWindowCSSImportRuleConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSCSSImportRule::getConstructor(exec);
}

JSValue* jsDOMWindowCSSMediaRuleConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSCSSMediaRule::getConstructor(exec);
}

JSValue* jsDOMWindowCSSPageRuleConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSCSSPageRule::getConstructor(exec);
}

JSValue* jsDOMWindowCSSStyleRuleConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSCSSStyleRule::getConstructor(exec);
}

JSValue* jsDOMWindowCSSVariablesRuleConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSCSSVariablesRule::getConstructor(exec);
}

JSValue* jsDOMWindowCSSVariablesDeclarationConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSCSSVariablesDeclaration::getConstructor(exec);
}

JSValue* jsDOMWindowCSSStyleDeclarationConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSCSSStyleDeclaration::getConstructor(exec);
}

JSValue* jsDOMWindowMediaListConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSMediaList::getConstructor(exec);
}

JSValue* jsDOMWindowCounterConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSCounter::getConstructor(exec);
}

JSValue* jsDOMWindowCSSRuleListConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSCSSRuleList::getConstructor(exec);
}

JSValue* jsDOMWindowRectConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSRect::getConstructor(exec);
}

JSValue* jsDOMWindowStyleSheetListConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSStyleSheetList::getConstructor(exec);
}

JSValue* jsDOMWindowDOMExceptionConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSDOMCoreException::getConstructor(exec);
}

JSValue* jsDOMWindowDOMImplementationConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSDOMImplementation::getConstructor(exec);
}

JSValue* jsDOMWindowDocumentFragmentConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSDocumentFragment::getConstructor(exec);
}

JSValue* jsDOMWindowDocumentConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSDocument::getConstructor(exec);
}

JSValue* jsDOMWindowNodeConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSNode::getConstructor(exec);
}

JSValue* jsDOMWindowNodeListConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSNodeList::getConstructor(exec);
}

JSValue* jsDOMWindowNamedNodeMapConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSNamedNodeMap::getConstructor(exec);
}

JSValue* jsDOMWindowCharacterDataConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSCharacterData::getConstructor(exec);
}

JSValue* jsDOMWindowAttrConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSAttr::getConstructor(exec);
}

JSValue* jsDOMWindowElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSElement::getConstructor(exec);
}

JSValue* jsDOMWindowTextConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSText::getConstructor(exec);
}

JSValue* jsDOMWindowCommentConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSComment::getConstructor(exec);
}

JSValue* jsDOMWindowCDATASectionConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSCDATASection::getConstructor(exec);
}

JSValue* jsDOMWindowDocumentTypeConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSDocumentType::getConstructor(exec);
}

JSValue* jsDOMWindowNotationConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSNotation::getConstructor(exec);
}

JSValue* jsDOMWindowEntityConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSEntity::getConstructor(exec);
}

JSValue* jsDOMWindowEntityReferenceConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSEntityReference::getConstructor(exec);
}

JSValue* jsDOMWindowProcessingInstructionConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSProcessingInstruction::getConstructor(exec);
}

JSValue* jsDOMWindowHTMLDocumentConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSHTMLDocument::getConstructor(exec);
}

JSValue* jsDOMWindowHTMLElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSHTMLElement::getConstructor(exec);
}

JSValue* jsDOMWindowHTMLAnchorElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSHTMLAnchorElement::getConstructor(exec);
}

JSValue* jsDOMWindowHTMLAppletElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSHTMLAppletElement::getConstructor(exec);
}

JSValue* jsDOMWindowHTMLAreaElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSHTMLAreaElement::getConstructor(exec);
}

JSValue* jsDOMWindowHTMLBRElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSHTMLBRElement::getConstructor(exec);
}

JSValue* jsDOMWindowHTMLBaseElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSHTMLBaseElement::getConstructor(exec);
}

JSValue* jsDOMWindowHTMLBaseFontElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSHTMLBaseFontElement::getConstructor(exec);
}

JSValue* jsDOMWindowHTMLBlockquoteElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSHTMLBlockquoteElement::getConstructor(exec);
}

JSValue* jsDOMWindowHTMLBodyElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSHTMLBodyElement::getConstructor(exec);
}

JSValue* jsDOMWindowHTMLButtonElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSHTMLButtonElement::getConstructor(exec);
}

JSValue* jsDOMWindowHTMLCanvasElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSHTMLCanvasElement::getConstructor(exec);
}

JSValue* jsDOMWindowHTMLDListElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSHTMLDListElement::getConstructor(exec);
}

JSValue* jsDOMWindowHTMLDirectoryElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSHTMLDirectoryElement::getConstructor(exec);
}

JSValue* jsDOMWindowHTMLDivElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSHTMLDivElement::getConstructor(exec);
}

JSValue* jsDOMWindowHTMLEmbedElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSHTMLEmbedElement::getConstructor(exec);
}

JSValue* jsDOMWindowHTMLFieldSetElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSHTMLFieldSetElement::getConstructor(exec);
}

JSValue* jsDOMWindowHTMLFontElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSHTMLFontElement::getConstructor(exec);
}

JSValue* jsDOMWindowHTMLFormElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSHTMLFormElement::getConstructor(exec);
}

JSValue* jsDOMWindowHTMLFrameElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSHTMLFrameElement::getConstructor(exec);
}

JSValue* jsDOMWindowHTMLFrameSetElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSHTMLFrameSetElement::getConstructor(exec);
}

JSValue* jsDOMWindowHTMLHRElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSHTMLHRElement::getConstructor(exec);
}

JSValue* jsDOMWindowHTMLHeadElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSHTMLHeadElement::getConstructor(exec);
}

JSValue* jsDOMWindowHTMLHeadingElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSHTMLHeadingElement::getConstructor(exec);
}

JSValue* jsDOMWindowHTMLHtmlElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSHTMLHtmlElement::getConstructor(exec);
}

JSValue* jsDOMWindowHTMLIFrameElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSHTMLIFrameElement::getConstructor(exec);
}

JSValue* jsDOMWindowHTMLImageElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSHTMLImageElement::getConstructor(exec);
}

JSValue* jsDOMWindowHTMLInputElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSHTMLInputElement::getConstructor(exec);
}

JSValue* jsDOMWindowHTMLIsIndexElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSHTMLIsIndexElement::getConstructor(exec);
}

JSValue* jsDOMWindowHTMLLIElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSHTMLLIElement::getConstructor(exec);
}

JSValue* jsDOMWindowHTMLLabelElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSHTMLLabelElement::getConstructor(exec);
}

JSValue* jsDOMWindowHTMLLegendElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSHTMLLegendElement::getConstructor(exec);
}

JSValue* jsDOMWindowHTMLLinkElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSHTMLLinkElement::getConstructor(exec);
}

JSValue* jsDOMWindowHTMLMapElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSHTMLMapElement::getConstructor(exec);
}

JSValue* jsDOMWindowHTMLMarqueeElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSHTMLMarqueeElement::getConstructor(exec);
}

JSValue* jsDOMWindowHTMLMenuElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSHTMLMenuElement::getConstructor(exec);
}

JSValue* jsDOMWindowHTMLMetaElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSHTMLMetaElement::getConstructor(exec);
}

JSValue* jsDOMWindowHTMLModElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSHTMLModElement::getConstructor(exec);
}

JSValue* jsDOMWindowHTMLOListElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSHTMLOListElement::getConstructor(exec);
}

JSValue* jsDOMWindowHTMLObjectElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSHTMLObjectElement::getConstructor(exec);
}

JSValue* jsDOMWindowHTMLOptGroupElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSHTMLOptGroupElement::getConstructor(exec);
}

JSValue* jsDOMWindowHTMLOptionElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSHTMLOptionElement::getConstructor(exec);
}

JSValue* jsDOMWindowHTMLParagraphElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSHTMLParagraphElement::getConstructor(exec);
}

JSValue* jsDOMWindowHTMLParamElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSHTMLParamElement::getConstructor(exec);
}

JSValue* jsDOMWindowHTMLPreElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSHTMLPreElement::getConstructor(exec);
}

JSValue* jsDOMWindowHTMLQuoteElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSHTMLQuoteElement::getConstructor(exec);
}

JSValue* jsDOMWindowHTMLScriptElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSHTMLScriptElement::getConstructor(exec);
}

JSValue* jsDOMWindowHTMLSelectElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSHTMLSelectElement::getConstructor(exec);
}

JSValue* jsDOMWindowHTMLStyleElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSHTMLStyleElement::getConstructor(exec);
}

JSValue* jsDOMWindowHTMLTableCaptionElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSHTMLTableCaptionElement::getConstructor(exec);
}

JSValue* jsDOMWindowHTMLTableCellElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSHTMLTableCellElement::getConstructor(exec);
}

JSValue* jsDOMWindowHTMLTableColElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSHTMLTableColElement::getConstructor(exec);
}

JSValue* jsDOMWindowHTMLTableElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSHTMLTableElement::getConstructor(exec);
}

JSValue* jsDOMWindowHTMLTableRowElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSHTMLTableRowElement::getConstructor(exec);
}

JSValue* jsDOMWindowHTMLTableSectionElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSHTMLTableSectionElement::getConstructor(exec);
}

JSValue* jsDOMWindowHTMLTextAreaElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSHTMLTextAreaElement::getConstructor(exec);
}

JSValue* jsDOMWindowHTMLTitleElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSHTMLTitleElement::getConstructor(exec);
}

JSValue* jsDOMWindowHTMLUListElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSHTMLUListElement::getConstructor(exec);
}

JSValue* jsDOMWindowHTMLCollectionConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSHTMLCollection::getConstructor(exec);
}

JSValue* jsDOMWindowCanvasRenderingContext2DConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSCanvasRenderingContext2D::getConstructor(exec);
}

JSValue* jsDOMWindowTextMetricsConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSTextMetrics::getConstructor(exec);
}

JSValue* jsDOMWindowEventConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSEvent::getConstructor(exec);
}

JSValue* jsDOMWindowKeyboardEventConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSKeyboardEvent::getConstructor(exec);
}

JSValue* jsDOMWindowMouseEventConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSMouseEvent::getConstructor(exec);
}

JSValue* jsDOMWindowMutationEventConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSMutationEvent::getConstructor(exec);
}

JSValue* jsDOMWindowOverflowEventConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSOverflowEvent::getConstructor(exec);
}

JSValue* jsDOMWindowProgressEventConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSProgressEvent::getConstructor(exec);
}

JSValue* jsDOMWindowTextEventConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSTextEvent::getConstructor(exec);
}

JSValue* jsDOMWindowUIEventConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSUIEvent::getConstructor(exec);
}

JSValue* jsDOMWindowWheelEventConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSWheelEvent::getConstructor(exec);
}

JSValue* jsDOMWindowMessageEventConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSMessageEvent::getConstructor(exec);
}

JSValue* jsDOMWindowEventExceptionConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSEventException::getConstructor(exec);
}

JSValue* jsDOMWindowClipboardConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSClipboard::getConstructor(exec);
}

JSValue* jsDOMWindowFileConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSFile::getConstructor(exec);
}

JSValue* jsDOMWindowFileListConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSFileList::getConstructor(exec);
}

JSValue* jsDOMWindowNodeFilterConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSNodeFilter::getConstructor(exec);
}

JSValue* jsDOMWindowRangeConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSRange::getConstructor(exec);
}

JSValue* jsDOMWindowRangeExceptionConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSRangeException::getConstructor(exec);
}

JSValue* jsDOMWindowXMLDocumentConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSDocument::getConstructor(exec);
}

JSValue* jsDOMWindowDOMParserConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSDOMParser::getConstructor(exec);
}

JSValue* jsDOMWindowXMLSerializerConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSXMLSerializer::getConstructor(exec);
}

JSValue* jsDOMWindowXMLHttpRequestUploadConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSXMLHttpRequestUpload::getConstructor(exec);
}

JSValue* jsDOMWindowXMLHttpRequestExceptionConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSXMLHttpRequestException::getConstructor(exec);
}

JSValue* jsDOMWindowPluginConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSPlugin::getConstructor(exec);
}

JSValue* jsDOMWindowPluginArrayConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSPluginArray::getConstructor(exec);
}

JSValue* jsDOMWindowMimeTypeConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSMimeType::getConstructor(exec);
}

JSValue* jsDOMWindowMimeTypeArrayConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSMimeTypeArray::getConstructor(exec);
}

JSValue* jsDOMWindowStorageConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSStorage::getConstructor(exec);
}

JSValue* jsDOMWindowStorageEventConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSStorageEvent::getConstructor(exec);
}

#if ENABLE(VIDEO)
JSValue* jsDOMWindowHTMLAudioElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSHTMLAudioElement::getConstructor(exec);
}
#endif

#if ENABLE(VIDEO)
JSValue* jsDOMWindowHTMLMediaElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSHTMLMediaElement::getConstructor(exec);
}
#endif

#if ENABLE(VIDEO)
JSValue* jsDOMWindowHTMLVideoElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSHTMLVideoElement::getConstructor(exec);
}
#endif

#if ENABLE(VIDEO)
JSValue* jsDOMWindowMediaErrorConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSMediaError::getConstructor(exec);
}
#endif

JSValue* jsDOMWindowXPathEvaluatorConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSXPathEvaluator::getConstructor(exec);
}

JSValue* jsDOMWindowXPathResultConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSXPathResult::getConstructor(exec);
}

JSValue* jsDOMWindowXPathExceptionConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSXPathException::getConstructor(exec);
}

JSValue* jsDOMWindowSVGAngleConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSSVGAngle::getConstructor(exec);
}

JSValue* jsDOMWindowSVGColorConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSSVGColor::getConstructor(exec);
}

JSValue* jsDOMWindowSVGExceptionConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSSVGException::getConstructor(exec);
}

JSValue* jsDOMWindowSVGGradientElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSSVGGradientElement::getConstructor(exec);
}

JSValue* jsDOMWindowSVGLengthConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSSVGLength::getConstructor(exec);
}

JSValue* jsDOMWindowSVGMarkerElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSSVGMarkerElement::getConstructor(exec);
}

JSValue* jsDOMWindowSVGPaintConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSSVGPaint::getConstructor(exec);
}

JSValue* jsDOMWindowSVGPathSegConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSSVGPathSeg::getConstructor(exec);
}

JSValue* jsDOMWindowSVGPreserveAspectRatioConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSSVGPreserveAspectRatio::getConstructor(exec);
}

JSValue* jsDOMWindowSVGRenderingIntentConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSSVGRenderingIntent::getConstructor(exec);
}

JSValue* jsDOMWindowSVGTextContentElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSSVGTextContentElement::getConstructor(exec);
}

JSValue* jsDOMWindowSVGTextPathElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSSVGTextPathElement::getConstructor(exec);
}

JSValue* jsDOMWindowSVGTransformConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSSVGTransform::getConstructor(exec);
}

JSValue* jsDOMWindowSVGUnitTypesConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    if (!static_cast<JSDOMWindow*>(asObject(slot.slotBase()))->allowsAccessFrom(exec))
        return jsUndefined();
    return JSSVGUnitTypes::getConstructor(exec);
}

void JSDOMWindow::put(ExecState* exec, const Identifier& propertyName, JSValue* value, PutPropertySlot& slot)
{
    if (customPut(exec, propertyName, value, slot))
        return;
    lookupPut<JSDOMWindow, Base>(exec, propertyName, value, &JSDOMWindowTable, this, slot);
}

void setJSDOMWindowLocationbar(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "locationbar"), value);
}

void setJSDOMWindowMenubar(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "menubar"), value);
}

void setJSDOMWindowPersonalbar(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "personalbar"), value);
}

void setJSDOMWindowScrollbars(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "scrollbars"), value);
}

void setJSDOMWindowStatusbar(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "statusbar"), value);
}

void setJSDOMWindowToolbar(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "toolbar"), value);
}

void setJSDOMWindowNavigator(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "navigator"), value);
}

void setJSDOMWindowClientInformation(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "clientInformation"), value);
}

void setJSDOMWindowLocation(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    static_cast<JSDOMWindow*>(thisObject)->setLocation(exec, value);
}

void setJSDOMWindowOffscreenBuffering(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "offscreenBuffering"), value);
}

void setJSDOMWindowOuterHeight(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "outerHeight"), value);
}

void setJSDOMWindowOuterWidth(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "outerWidth"), value);
}

void setJSDOMWindowInnerHeight(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "innerHeight"), value);
}

void setJSDOMWindowInnerWidth(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "innerWidth"), value);
}

void setJSDOMWindowScreenX(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "screenX"), value);
}

void setJSDOMWindowScreenY(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "screenY"), value);
}

void setJSDOMWindowScreenLeft(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "screenLeft"), value);
}

void setJSDOMWindowScreenTop(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "screenTop"), value);
}

void setJSDOMWindowScrollX(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "scrollX"), value);
}

void setJSDOMWindowScrollY(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "scrollY"), value);
}

void setJSDOMWindowLength(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "length"), value);
}

void setJSDOMWindowName(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(thisObject)->impl());
    imp->setName(value->toString(exec));
}

void setJSDOMWindowStatus(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(thisObject)->impl());
    imp->setStatus(value->toString(exec));
}

void setJSDOMWindowDefaultStatus(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(thisObject)->impl());
    imp->setDefaultStatus(value->toString(exec));
}

void setJSDOMWindowDefaultstatus(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(thisObject)->impl());
    imp->setDefaultstatus(value->toString(exec));
}

void setJSDOMWindowSelf(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "self"), value);
}

void setJSDOMWindowFrames(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "frames"), value);
}

void setJSDOMWindowOpener(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "opener"), value);
}

void setJSDOMWindowParent(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "parent"), value);
}

void setJSDOMWindowTop(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "top"), value);
}

void setJSDOMWindowDevicePixelRatio(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "devicePixelRatio"), value);
}

void setJSDOMWindowConsole(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "console"), value);
}

void setJSDOMWindowOnabort(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = static_cast<JSDOMWindow*>(thisObject);
    imp->setOnabort(globalObject->findOrCreateJSEventListener(exec, value, true));
}

void setJSDOMWindowOnblur(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = static_cast<JSDOMWindow*>(thisObject);
    imp->setOnblur(globalObject->findOrCreateJSEventListener(exec, value, true));
}

void setJSDOMWindowOnchange(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = static_cast<JSDOMWindow*>(thisObject);
    imp->setOnchange(globalObject->findOrCreateJSEventListener(exec, value, true));
}

void setJSDOMWindowOnclick(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = static_cast<JSDOMWindow*>(thisObject);
    imp->setOnclick(globalObject->findOrCreateJSEventListener(exec, value, true));
}

void setJSDOMWindowOndblclick(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = static_cast<JSDOMWindow*>(thisObject);
    imp->setOndblclick(globalObject->findOrCreateJSEventListener(exec, value, true));
}

void setJSDOMWindowOnerror(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = static_cast<JSDOMWindow*>(thisObject);
    imp->setOnerror(globalObject->findOrCreateJSEventListener(exec, value, true));
}

void setJSDOMWindowOnfocus(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = static_cast<JSDOMWindow*>(thisObject);
    imp->setOnfocus(globalObject->findOrCreateJSEventListener(exec, value, true));
}

void setJSDOMWindowOnkeydown(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = static_cast<JSDOMWindow*>(thisObject);
    imp->setOnkeydown(globalObject->findOrCreateJSEventListener(exec, value, true));
}

void setJSDOMWindowOnkeypress(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = static_cast<JSDOMWindow*>(thisObject);
    imp->setOnkeypress(globalObject->findOrCreateJSEventListener(exec, value, true));
}

void setJSDOMWindowOnkeyup(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = static_cast<JSDOMWindow*>(thisObject);
    imp->setOnkeyup(globalObject->findOrCreateJSEventListener(exec, value, true));
}

void setJSDOMWindowOnload(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = static_cast<JSDOMWindow*>(thisObject);
    imp->setOnload(globalObject->findOrCreateJSEventListener(exec, value, true));
}

void setJSDOMWindowOnmousedown(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = static_cast<JSDOMWindow*>(thisObject);
    imp->setOnmousedown(globalObject->findOrCreateJSEventListener(exec, value, true));
}

void setJSDOMWindowOnmousemove(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = static_cast<JSDOMWindow*>(thisObject);
    imp->setOnmousemove(globalObject->findOrCreateJSEventListener(exec, value, true));
}

void setJSDOMWindowOnmouseout(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = static_cast<JSDOMWindow*>(thisObject);
    imp->setOnmouseout(globalObject->findOrCreateJSEventListener(exec, value, true));
}

void setJSDOMWindowOnmouseover(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = static_cast<JSDOMWindow*>(thisObject);
    imp->setOnmouseover(globalObject->findOrCreateJSEventListener(exec, value, true));
}

void setJSDOMWindowOnmouseup(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = static_cast<JSDOMWindow*>(thisObject);
    imp->setOnmouseup(globalObject->findOrCreateJSEventListener(exec, value, true));
}

void setJSDOMWindowOnmousewheel(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = static_cast<JSDOMWindow*>(thisObject);
    imp->setOnmousewheel(globalObject->findOrCreateJSEventListener(exec, value, true));
}

void setJSDOMWindowOnreset(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = static_cast<JSDOMWindow*>(thisObject);
    imp->setOnreset(globalObject->findOrCreateJSEventListener(exec, value, true));
}

void setJSDOMWindowOnresize(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = static_cast<JSDOMWindow*>(thisObject);
    imp->setOnresize(globalObject->findOrCreateJSEventListener(exec, value, true));
}

void setJSDOMWindowOnscroll(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = static_cast<JSDOMWindow*>(thisObject);
    imp->setOnscroll(globalObject->findOrCreateJSEventListener(exec, value, true));
}

void setJSDOMWindowOnsearch(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = static_cast<JSDOMWindow*>(thisObject);
    imp->setOnsearch(globalObject->findOrCreateJSEventListener(exec, value, true));
}

void setJSDOMWindowOnselect(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = static_cast<JSDOMWindow*>(thisObject);
    imp->setOnselect(globalObject->findOrCreateJSEventListener(exec, value, true));
}

void setJSDOMWindowOnsubmit(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = static_cast<JSDOMWindow*>(thisObject);
    imp->setOnsubmit(globalObject->findOrCreateJSEventListener(exec, value, true));
}

void setJSDOMWindowOnunload(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = static_cast<JSDOMWindow*>(thisObject);
    imp->setOnunload(globalObject->findOrCreateJSEventListener(exec, value, true));
}

void setJSDOMWindowOnbeforeunload(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = static_cast<JSDOMWindow*>(thisObject);
    imp->setOnbeforeunload(globalObject->findOrCreateJSEventListener(exec, value, true));
}

void setJSDOMWindowOnwebkitanimationstart(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = static_cast<JSDOMWindow*>(thisObject);
    imp->setOnwebkitanimationstart(globalObject->findOrCreateJSEventListener(exec, value, true));
}

void setJSDOMWindowOnwebkitanimationiteration(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = static_cast<JSDOMWindow*>(thisObject);
    imp->setOnwebkitanimationiteration(globalObject->findOrCreateJSEventListener(exec, value, true));
}

void setJSDOMWindowOnwebkitanimationend(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = static_cast<JSDOMWindow*>(thisObject);
    imp->setOnwebkitanimationend(globalObject->findOrCreateJSEventListener(exec, value, true));
}

void setJSDOMWindowOnwebkittransitionend(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = static_cast<JSDOMWindow*>(thisObject);
    imp->setOnwebkittransitionend(globalObject->findOrCreateJSEventListener(exec, value, true));
}

void setJSDOMWindowStyleSheetConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "StyleSheet"), value);
}

void setJSDOMWindowCSSStyleSheetConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "CSSStyleSheet"), value);
}

void setJSDOMWindowCSSValueConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "CSSValue"), value);
}

void setJSDOMWindowCSSPrimitiveValueConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "CSSPrimitiveValue"), value);
}

void setJSDOMWindowCSSValueListConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "CSSValueList"), value);
}

void setJSDOMWindowCSSRuleConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "CSSRule"), value);
}

void setJSDOMWindowCSSCharsetRuleConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "CSSCharsetRule"), value);
}

void setJSDOMWindowCSSFontFaceRuleConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "CSSFontFaceRule"), value);
}

void setJSDOMWindowCSSImportRuleConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "CSSImportRule"), value);
}

void setJSDOMWindowCSSMediaRuleConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "CSSMediaRule"), value);
}

void setJSDOMWindowCSSPageRuleConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "CSSPageRule"), value);
}

void setJSDOMWindowCSSStyleRuleConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "CSSStyleRule"), value);
}

void setJSDOMWindowCSSVariablesRuleConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "CSSVariablesRule"), value);
}

void setJSDOMWindowCSSVariablesDeclarationConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "CSSVariablesDeclaration"), value);
}

void setJSDOMWindowCSSStyleDeclarationConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "CSSStyleDeclaration"), value);
}

void setJSDOMWindowMediaListConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "MediaList"), value);
}

void setJSDOMWindowCounterConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "Counter"), value);
}

void setJSDOMWindowCSSRuleListConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "CSSRuleList"), value);
}

void setJSDOMWindowRectConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "Rect"), value);
}

void setJSDOMWindowStyleSheetListConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "StyleSheetList"), value);
}

void setJSDOMWindowDOMExceptionConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "DOMException"), value);
}

void setJSDOMWindowDOMImplementationConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "DOMImplementation"), value);
}

void setJSDOMWindowDocumentFragmentConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "DocumentFragment"), value);
}

void setJSDOMWindowDocumentConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "Document"), value);
}

void setJSDOMWindowNodeConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "Node"), value);
}

void setJSDOMWindowNodeListConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "NodeList"), value);
}

void setJSDOMWindowNamedNodeMapConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "NamedNodeMap"), value);
}

void setJSDOMWindowCharacterDataConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "CharacterData"), value);
}

void setJSDOMWindowAttrConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "Attr"), value);
}

void setJSDOMWindowElementConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "Element"), value);
}

void setJSDOMWindowTextConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "Text"), value);
}

void setJSDOMWindowCommentConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "Comment"), value);
}

void setJSDOMWindowCDATASectionConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "CDATASection"), value);
}

void setJSDOMWindowDocumentTypeConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "DocumentType"), value);
}

void setJSDOMWindowNotationConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "Notation"), value);
}

void setJSDOMWindowEntityConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "Entity"), value);
}

void setJSDOMWindowEntityReferenceConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "EntityReference"), value);
}

void setJSDOMWindowProcessingInstructionConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "ProcessingInstruction"), value);
}

void setJSDOMWindowHTMLDocumentConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "HTMLDocument"), value);
}

void setJSDOMWindowHTMLElementConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "HTMLElement"), value);
}

void setJSDOMWindowHTMLAnchorElementConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "HTMLAnchorElement"), value);
}

void setJSDOMWindowHTMLAppletElementConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "HTMLAppletElement"), value);
}

void setJSDOMWindowHTMLAreaElementConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "HTMLAreaElement"), value);
}

void setJSDOMWindowHTMLBRElementConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "HTMLBRElement"), value);
}

void setJSDOMWindowHTMLBaseElementConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "HTMLBaseElement"), value);
}

void setJSDOMWindowHTMLBaseFontElementConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "HTMLBaseFontElement"), value);
}

void setJSDOMWindowHTMLBlockquoteElementConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "HTMLBlockquoteElement"), value);
}

void setJSDOMWindowHTMLBodyElementConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "HTMLBodyElement"), value);
}

void setJSDOMWindowHTMLButtonElementConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "HTMLButtonElement"), value);
}

void setJSDOMWindowHTMLCanvasElementConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "HTMLCanvasElement"), value);
}

void setJSDOMWindowHTMLDListElementConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "HTMLDListElement"), value);
}

void setJSDOMWindowHTMLDirectoryElementConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "HTMLDirectoryElement"), value);
}

void setJSDOMWindowHTMLDivElementConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "HTMLDivElement"), value);
}

void setJSDOMWindowHTMLEmbedElementConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "HTMLEmbedElement"), value);
}

void setJSDOMWindowHTMLFieldSetElementConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "HTMLFieldSetElement"), value);
}

void setJSDOMWindowHTMLFontElementConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "HTMLFontElement"), value);
}

void setJSDOMWindowHTMLFormElementConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "HTMLFormElement"), value);
}

void setJSDOMWindowHTMLFrameElementConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "HTMLFrameElement"), value);
}

void setJSDOMWindowHTMLFrameSetElementConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "HTMLFrameSetElement"), value);
}

void setJSDOMWindowHTMLHRElementConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "HTMLHRElement"), value);
}

void setJSDOMWindowHTMLHeadElementConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "HTMLHeadElement"), value);
}

void setJSDOMWindowHTMLHeadingElementConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "HTMLHeadingElement"), value);
}

void setJSDOMWindowHTMLHtmlElementConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "HTMLHtmlElement"), value);
}

void setJSDOMWindowHTMLIFrameElementConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "HTMLIFrameElement"), value);
}

void setJSDOMWindowHTMLImageElementConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "HTMLImageElement"), value);
}

void setJSDOMWindowHTMLInputElementConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "HTMLInputElement"), value);
}

void setJSDOMWindowHTMLIsIndexElementConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "HTMLIsIndexElement"), value);
}

void setJSDOMWindowHTMLLIElementConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "HTMLLIElement"), value);
}

void setJSDOMWindowHTMLLabelElementConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "HTMLLabelElement"), value);
}

void setJSDOMWindowHTMLLegendElementConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "HTMLLegendElement"), value);
}

void setJSDOMWindowHTMLLinkElementConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "HTMLLinkElement"), value);
}

void setJSDOMWindowHTMLMapElementConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "HTMLMapElement"), value);
}

void setJSDOMWindowHTMLMarqueeElementConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "HTMLMarqueeElement"), value);
}

void setJSDOMWindowHTMLMenuElementConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "HTMLMenuElement"), value);
}

void setJSDOMWindowHTMLMetaElementConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "HTMLMetaElement"), value);
}

void setJSDOMWindowHTMLModElementConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "HTMLModElement"), value);
}

void setJSDOMWindowHTMLOListElementConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "HTMLOListElement"), value);
}

void setJSDOMWindowHTMLObjectElementConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "HTMLObjectElement"), value);
}

void setJSDOMWindowHTMLOptGroupElementConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "HTMLOptGroupElement"), value);
}

void setJSDOMWindowHTMLOptionElementConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "HTMLOptionElement"), value);
}

void setJSDOMWindowHTMLParagraphElementConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "HTMLParagraphElement"), value);
}

void setJSDOMWindowHTMLParamElementConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "HTMLParamElement"), value);
}

void setJSDOMWindowHTMLPreElementConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "HTMLPreElement"), value);
}

void setJSDOMWindowHTMLQuoteElementConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "HTMLQuoteElement"), value);
}

void setJSDOMWindowHTMLScriptElementConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "HTMLScriptElement"), value);
}

void setJSDOMWindowHTMLSelectElementConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "HTMLSelectElement"), value);
}

void setJSDOMWindowHTMLStyleElementConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "HTMLStyleElement"), value);
}

void setJSDOMWindowHTMLTableCaptionElementConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "HTMLTableCaptionElement"), value);
}

void setJSDOMWindowHTMLTableCellElementConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "HTMLTableCellElement"), value);
}

void setJSDOMWindowHTMLTableColElementConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "HTMLTableColElement"), value);
}

void setJSDOMWindowHTMLTableElementConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "HTMLTableElement"), value);
}

void setJSDOMWindowHTMLTableRowElementConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "HTMLTableRowElement"), value);
}

void setJSDOMWindowHTMLTableSectionElementConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "HTMLTableSectionElement"), value);
}

void setJSDOMWindowHTMLTextAreaElementConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "HTMLTextAreaElement"), value);
}

void setJSDOMWindowHTMLTitleElementConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "HTMLTitleElement"), value);
}

void setJSDOMWindowHTMLUListElementConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "HTMLUListElement"), value);
}

void setJSDOMWindowHTMLCollectionConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "HTMLCollection"), value);
}

void setJSDOMWindowCanvasRenderingContext2DConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "CanvasRenderingContext2D"), value);
}

void setJSDOMWindowTextMetricsConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "TextMetrics"), value);
}

void setJSDOMWindowEventConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "Event"), value);
}

void setJSDOMWindowKeyboardEventConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "KeyboardEvent"), value);
}

void setJSDOMWindowMouseEventConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "MouseEvent"), value);
}

void setJSDOMWindowMutationEventConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "MutationEvent"), value);
}

void setJSDOMWindowOverflowEventConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "OverflowEvent"), value);
}

void setJSDOMWindowProgressEventConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "ProgressEvent"), value);
}

void setJSDOMWindowTextEventConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "TextEvent"), value);
}

void setJSDOMWindowUIEventConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "UIEvent"), value);
}

void setJSDOMWindowWheelEventConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "WheelEvent"), value);
}

void setJSDOMWindowMessageEventConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "MessageEvent"), value);
}

void setJSDOMWindowEventExceptionConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "EventException"), value);
}

void setJSDOMWindowClipboardConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "Clipboard"), value);
}

void setJSDOMWindowFileConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "File"), value);
}

void setJSDOMWindowFileListConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "FileList"), value);
}

void setJSDOMWindowNodeFilterConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "NodeFilter"), value);
}

void setJSDOMWindowRangeConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "Range"), value);
}

void setJSDOMWindowRangeExceptionConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "RangeException"), value);
}

void setJSDOMWindowXMLDocumentConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "XMLDocument"), value);
}

void setJSDOMWindowDOMParserConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "DOMParser"), value);
}

void setJSDOMWindowXMLSerializerConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "XMLSerializer"), value);
}

void setJSDOMWindowXMLHttpRequestUploadConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "XMLHttpRequestUpload"), value);
}

void setJSDOMWindowXMLHttpRequestExceptionConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "XMLHttpRequestException"), value);
}

void setJSDOMWindowPluginConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "Plugin"), value);
}

void setJSDOMWindowPluginArrayConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "PluginArray"), value);
}

void setJSDOMWindowMimeTypeConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "MimeType"), value);
}

void setJSDOMWindowMimeTypeArrayConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "MimeTypeArray"), value);
}

void setJSDOMWindowStorageConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "Storage"), value);
}

void setJSDOMWindowStorageEventConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "StorageEvent"), value);
}

void setJSDOMWindowHTMLAudioElementConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "HTMLAudioElement"), value);
}

void setJSDOMWindowHTMLMediaElementConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "HTMLMediaElement"), value);
}

void setJSDOMWindowHTMLVideoElementConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "HTMLVideoElement"), value);
}

void setJSDOMWindowMediaErrorConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "MediaError"), value);
}

void setJSDOMWindowXPathEvaluatorConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "XPathEvaluator"), value);
}

void setJSDOMWindowXPathResultConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "XPathResult"), value);
}

void setJSDOMWindowXPathExceptionConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "XPathException"), value);
}

void setJSDOMWindowSVGAngleConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "SVGAngle"), value);
}

void setJSDOMWindowSVGColorConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "SVGColor"), value);
}

void setJSDOMWindowSVGExceptionConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "SVGException"), value);
}

void setJSDOMWindowSVGGradientElementConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "SVGGradientElement"), value);
}

void setJSDOMWindowSVGLengthConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "SVGLength"), value);
}

void setJSDOMWindowSVGMarkerElementConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "SVGMarkerElement"), value);
}

void setJSDOMWindowSVGPaintConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "SVGPaint"), value);
}

void setJSDOMWindowSVGPathSegConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "SVGPathSeg"), value);
}

void setJSDOMWindowSVGPreserveAspectRatioConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "SVGPreserveAspectRatio"), value);
}

void setJSDOMWindowSVGRenderingIntentConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "SVGRenderingIntent"), value);
}

void setJSDOMWindowSVGTextContentElementConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "SVGTextContentElement"), value);
}

void setJSDOMWindowSVGTextPathElementConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "SVGTextPathElement"), value);
}

void setJSDOMWindowSVGTransformConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "SVGTransform"), value);
}

void setJSDOMWindowSVGUnitTypesConstructor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    if (!static_cast<JSDOMWindow*>(thisObject)->allowsAccessFrom(exec))
        return;
    // Shadowing a built-in constructor
    static_cast<JSDOMWindow*>(thisObject)->putDirect(Identifier(exec, "SVGUnitTypes"), value);
}

void JSDOMWindow::getPropertyNames(ExecState* exec, PropertyNameArray& propertyNames)
{
    if (customGetPropertyNames(exec, propertyNames))
        return;
     Base::getPropertyNames(exec, propertyNames);
}

JSValue* jsDOMWindowPrototypeFunctionGetSelection(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    JSDOMWindow* castedThisObj = toJSDOMWindow(thisValue);
    if (!castedThisObj)
        return throwError(exec, TypeError);
    if (!castedThisObj->allowsAccessFrom(exec))
        return jsUndefined();
    DOMWindow* imp = static_cast<DOMWindow*>(castedThisObj->impl());


    JSC::JSValue* result = toJS(exec, WTF::getPtr(imp->getSelection()));
    return result;
}

JSValue* jsDOMWindowPrototypeFunctionFocus(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    JSDOMWindow* castedThisObj = toJSDOMWindow(thisValue);
    if (!castedThisObj)
        return throwError(exec, TypeError);
    DOMWindow* imp = static_cast<DOMWindow*>(castedThisObj->impl());

    imp->focus();
    return jsUndefined();
}

JSValue* jsDOMWindowPrototypeFunctionBlur(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    JSDOMWindow* castedThisObj = toJSDOMWindow(thisValue);
    if (!castedThisObj)
        return throwError(exec, TypeError);
    DOMWindow* imp = static_cast<DOMWindow*>(castedThisObj->impl());

    imp->blur();
    return jsUndefined();
}

JSValue* jsDOMWindowPrototypeFunctionClose(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    JSDOMWindow* castedThisObj = toJSDOMWindow(thisValue);
    if (!castedThisObj)
        return throwError(exec, TypeError);
    DOMWindow* imp = static_cast<DOMWindow*>(castedThisObj->impl());

    imp->close();
    return jsUndefined();
}

JSValue* jsDOMWindowPrototypeFunctionPrint(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    JSDOMWindow* castedThisObj = toJSDOMWindow(thisValue);
    if (!castedThisObj)
        return throwError(exec, TypeError);
    if (!castedThisObj->allowsAccessFrom(exec))
        return jsUndefined();
    DOMWindow* imp = static_cast<DOMWindow*>(castedThisObj->impl());

    imp->print();
    return jsUndefined();
}

JSValue* jsDOMWindowPrototypeFunctionStop(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    JSDOMWindow* castedThisObj = toJSDOMWindow(thisValue);
    if (!castedThisObj)
        return throwError(exec, TypeError);
    if (!castedThisObj->allowsAccessFrom(exec))
        return jsUndefined();
    DOMWindow* imp = static_cast<DOMWindow*>(castedThisObj->impl());

    imp->stop();
    return jsUndefined();
}

JSValue* jsDOMWindowPrototypeFunctionAlert(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    JSDOMWindow* castedThisObj = toJSDOMWindow(thisValue);
    if (!castedThisObj)
        return throwError(exec, TypeError);
    if (!castedThisObj->allowsAccessFrom(exec))
        return jsUndefined();
    DOMWindow* imp = static_cast<DOMWindow*>(castedThisObj->impl());
    const UString& message = args.at(exec, 0)->toString(exec);

    imp->alert(message);
    return jsUndefined();
}

JSValue* jsDOMWindowPrototypeFunctionConfirm(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    JSDOMWindow* castedThisObj = toJSDOMWindow(thisValue);
    if (!castedThisObj)
        return throwError(exec, TypeError);
    if (!castedThisObj->allowsAccessFrom(exec))
        return jsUndefined();
    DOMWindow* imp = static_cast<DOMWindow*>(castedThisObj->impl());
    const UString& message = args.at(exec, 0)->toString(exec);


    JSC::JSValue* result = jsBoolean(imp->confirm(message));
    return result;
}

JSValue* jsDOMWindowPrototypeFunctionPrompt(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    JSDOMWindow* castedThisObj = toJSDOMWindow(thisValue);
    if (!castedThisObj)
        return throwError(exec, TypeError);
    if (!castedThisObj->allowsAccessFrom(exec))
        return jsUndefined();
    DOMWindow* imp = static_cast<DOMWindow*>(castedThisObj->impl());
    const UString& message = args.at(exec, 0)->toString(exec);
    const UString& defaultValue = valueToStringWithUndefinedOrNullCheck(exec, args.at(exec, 1));


    JSC::JSValue* result = jsStringOrNull(exec, imp->prompt(message, defaultValue));
    return result;
}

JSValue* jsDOMWindowPrototypeFunctionFind(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    JSDOMWindow* castedThisObj = toJSDOMWindow(thisValue);
    if (!castedThisObj)
        return throwError(exec, TypeError);
    if (!castedThisObj->allowsAccessFrom(exec))
        return jsUndefined();
    DOMWindow* imp = static_cast<DOMWindow*>(castedThisObj->impl());
    const UString& string = args.at(exec, 0)->toString(exec);
    bool caseSensitive = args.at(exec, 1)->toBoolean(exec);
    bool backwards = args.at(exec, 2)->toBoolean(exec);
    bool wrap = args.at(exec, 3)->toBoolean(exec);
    bool wholeWord = args.at(exec, 4)->toBoolean(exec);
    bool searchInFrames = args.at(exec, 5)->toBoolean(exec);
    bool showDialog = args.at(exec, 6)->toBoolean(exec);


    JSC::JSValue* result = jsBoolean(imp->find(string, caseSensitive, backwards, wrap, wholeWord, searchInFrames, showDialog));
    return result;
}

JSValue* jsDOMWindowPrototypeFunctionScrollBy(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    JSDOMWindow* castedThisObj = toJSDOMWindow(thisValue);
    if (!castedThisObj)
        return throwError(exec, TypeError);
    if (!castedThisObj->allowsAccessFrom(exec))
        return jsUndefined();
    DOMWindow* imp = static_cast<DOMWindow*>(castedThisObj->impl());
    if (args.size() < 2)
        return jsUndefined();
    int x = args.at(exec, 0)->toInt32(exec);
    int y = args.at(exec, 1)->toInt32(exec);

    imp->scrollBy(x, y);
    return jsUndefined();
}

JSValue* jsDOMWindowPrototypeFunctionScrollTo(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    JSDOMWindow* castedThisObj = toJSDOMWindow(thisValue);
    if (!castedThisObj)
        return throwError(exec, TypeError);
    if (!castedThisObj->allowsAccessFrom(exec))
        return jsUndefined();
    DOMWindow* imp = static_cast<DOMWindow*>(castedThisObj->impl());
    if (args.size() < 2)
        return jsUndefined();
    int x = args.at(exec, 0)->toInt32(exec);
    int y = args.at(exec, 1)->toInt32(exec);

    imp->scrollTo(x, y);
    return jsUndefined();
}

JSValue* jsDOMWindowPrototypeFunctionScroll(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    JSDOMWindow* castedThisObj = toJSDOMWindow(thisValue);
    if (!castedThisObj)
        return throwError(exec, TypeError);
    if (!castedThisObj->allowsAccessFrom(exec))
        return jsUndefined();
    DOMWindow* imp = static_cast<DOMWindow*>(castedThisObj->impl());
    if (args.size() < 2)
        return jsUndefined();
    int x = args.at(exec, 0)->toInt32(exec);
    int y = args.at(exec, 1)->toInt32(exec);

    imp->scroll(x, y);
    return jsUndefined();
}

JSValue* jsDOMWindowPrototypeFunctionMoveBy(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    JSDOMWindow* castedThisObj = toJSDOMWindow(thisValue);
    if (!castedThisObj)
        return throwError(exec, TypeError);
    if (!castedThisObj->allowsAccessFrom(exec))
        return jsUndefined();
    DOMWindow* imp = static_cast<DOMWindow*>(castedThisObj->impl());
    if (args.size() < 2)
        return jsUndefined();
    float x = args.at(exec, 0)->toFloat(exec);
    float y = args.at(exec, 1)->toFloat(exec);

    imp->moveBy(x, y);
    return jsUndefined();
}

JSValue* jsDOMWindowPrototypeFunctionMoveTo(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    JSDOMWindow* castedThisObj = toJSDOMWindow(thisValue);
    if (!castedThisObj)
        return throwError(exec, TypeError);
    if (!castedThisObj->allowsAccessFrom(exec))
        return jsUndefined();
    DOMWindow* imp = static_cast<DOMWindow*>(castedThisObj->impl());
    if (args.size() < 2)
        return jsUndefined();
    float x = args.at(exec, 0)->toFloat(exec);
    float y = args.at(exec, 1)->toFloat(exec);

    imp->moveTo(x, y);
    return jsUndefined();
}

JSValue* jsDOMWindowPrototypeFunctionResizeBy(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    JSDOMWindow* castedThisObj = toJSDOMWindow(thisValue);
    if (!castedThisObj)
        return throwError(exec, TypeError);
    if (!castedThisObj->allowsAccessFrom(exec))
        return jsUndefined();
    DOMWindow* imp = static_cast<DOMWindow*>(castedThisObj->impl());
    if (args.size() < 2)
        return jsUndefined();
    float x = args.at(exec, 0)->toFloat(exec);
    float y = args.at(exec, 1)->toFloat(exec);

    imp->resizeBy(x, y);
    return jsUndefined();
}

JSValue* jsDOMWindowPrototypeFunctionResizeTo(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    JSDOMWindow* castedThisObj = toJSDOMWindow(thisValue);
    if (!castedThisObj)
        return throwError(exec, TypeError);
    if (!castedThisObj->allowsAccessFrom(exec))
        return jsUndefined();
    DOMWindow* imp = static_cast<DOMWindow*>(castedThisObj->impl());
    if (args.size() < 2)
        return jsUndefined();
    float width = args.at(exec, 0)->toFloat(exec);
    float height = args.at(exec, 1)->toFloat(exec);

    imp->resizeTo(width, height);
    return jsUndefined();
}

JSValue* jsDOMWindowPrototypeFunctionGetComputedStyle(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    JSDOMWindow* castedThisObj = toJSDOMWindow(thisValue);
    if (!castedThisObj)
        return throwError(exec, TypeError);
    if (!castedThisObj->allowsAccessFrom(exec))
        return jsUndefined();
    DOMWindow* imp = static_cast<DOMWindow*>(castedThisObj->impl());
    Element* element = toElement(args.at(exec, 0));
    const UString& pseudoElement = args.at(exec, 1)->toString(exec);


    JSC::JSValue* result = toJS(exec, WTF::getPtr(imp->getComputedStyle(element, pseudoElement)));
    return result;
}

JSValue* jsDOMWindowPrototypeFunctionGetMatchedCSSRules(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    JSDOMWindow* castedThisObj = toJSDOMWindow(thisValue);
    if (!castedThisObj)
        return throwError(exec, TypeError);
    if (!castedThisObj->allowsAccessFrom(exec))
        return jsUndefined();
    DOMWindow* imp = static_cast<DOMWindow*>(castedThisObj->impl());
    Element* element = toElement(args.at(exec, 0));
    const UString& pseudoElement = args.at(exec, 1)->toString(exec);

    int argsCount = args.size();
    if (argsCount < 3) {

        JSC::JSValue* result = toJS(exec, WTF::getPtr(imp->getMatchedCSSRules(element, pseudoElement)));
        return result;
    }

    bool authorOnly = args.at(exec, 2)->toBoolean(exec);


    JSC::JSValue* result = toJS(exec, WTF::getPtr(imp->getMatchedCSSRules(element, pseudoElement, authorOnly)));
    return result;
}

JSValue* jsDOMWindowPrototypeFunctionOpenDatabase(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    JSDOMWindow* castedThisObj = toJSDOMWindow(thisValue);
    if (!castedThisObj)
        return throwError(exec, TypeError);
    if (!castedThisObj->allowsAccessFrom(exec))
        return jsUndefined();
    DOMWindow* imp = static_cast<DOMWindow*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    const UString& name = args.at(exec, 0)->toString(exec);
    const UString& version = args.at(exec, 1)->toString(exec);
    const UString& displayName = args.at(exec, 2)->toString(exec);
    unsigned estimatedSize = args.at(exec, 3)->toInt32(exec);


    JSC::JSValue* result = toJS(exec, WTF::getPtr(imp->openDatabase(name, version, displayName, estimatedSize, ec)));
    setDOMException(exec, ec);
    return result;
}

JSValue* jsDOMWindowPrototypeFunctionPostMessage(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    JSDOMWindow* castedThisObj = toJSDOMWindow(thisValue);
    if (!castedThisObj)
        return throwError(exec, TypeError);
    return castedThisObj->postMessage(exec, args);
}

JSValue* jsDOMWindowPrototypeFunctionSetTimeout(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    JSDOMWindow* castedThisObj = toJSDOMWindow(thisValue);
    if (!castedThisObj)
        return throwError(exec, TypeError);
    if (!castedThisObj->allowsAccessFrom(exec))
        return jsUndefined();
    return castedThisObj->setTimeout(exec, args);
}

JSValue* jsDOMWindowPrototypeFunctionClearTimeout(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    JSDOMWindow* castedThisObj = toJSDOMWindow(thisValue);
    if (!castedThisObj)
        return throwError(exec, TypeError);
    if (!castedThisObj->allowsAccessFrom(exec))
        return jsUndefined();
    return castedThisObj->clearTimeout(exec, args);
}

JSValue* jsDOMWindowPrototypeFunctionSetInterval(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    JSDOMWindow* castedThisObj = toJSDOMWindow(thisValue);
    if (!castedThisObj)
        return throwError(exec, TypeError);
    if (!castedThisObj->allowsAccessFrom(exec))
        return jsUndefined();
    return castedThisObj->setInterval(exec, args);
}

JSValue* jsDOMWindowPrototypeFunctionClearInterval(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    JSDOMWindow* castedThisObj = toJSDOMWindow(thisValue);
    if (!castedThisObj)
        return throwError(exec, TypeError);
    if (!castedThisObj->allowsAccessFrom(exec))
        return jsUndefined();
    return castedThisObj->clearInterval(exec, args);
}

JSValue* jsDOMWindowPrototypeFunctionAtob(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    JSDOMWindow* castedThisObj = toJSDOMWindow(thisValue);
    if (!castedThisObj)
        return throwError(exec, TypeError);
    if (!castedThisObj->allowsAccessFrom(exec))
        return jsUndefined();
    return castedThisObj->atob(exec, args);
}

JSValue* jsDOMWindowPrototypeFunctionBtoa(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    JSDOMWindow* castedThisObj = toJSDOMWindow(thisValue);
    if (!castedThisObj)
        return throwError(exec, TypeError);
    if (!castedThisObj->allowsAccessFrom(exec))
        return jsUndefined();
    return castedThisObj->btoa(exec, args);
}

JSValue* jsDOMWindowPrototypeFunctionAddEventListener(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    JSDOMWindow* castedThisObj = toJSDOMWindow(thisValue);
    if (!castedThisObj)
        return throwError(exec, TypeError);
    if (!castedThisObj->allowsAccessFrom(exec))
        return jsUndefined();
    return castedThisObj->addEventListener(exec, args);
}

JSValue* jsDOMWindowPrototypeFunctionRemoveEventListener(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    JSDOMWindow* castedThisObj = toJSDOMWindow(thisValue);
    if (!castedThisObj)
        return throwError(exec, TypeError);
    if (!castedThisObj->allowsAccessFrom(exec))
        return jsUndefined();
    return castedThisObj->removeEventListener(exec, args);
}


}
