/****************************************************************************
**
** Copyright (C) 2007-2008 Trolltech ASA. All rights reserved.
**
** This file is part of the Qt Assistant of the Qt Toolkit.
**
** This file may be used under the terms of the GNU General Public
** License versions 2.0 or 3.0 as published by the Free Software
** Foundation and appearing in the files LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file.  Alternatively you may (at
** your option) use any later version of the GNU General Public
** License if such license has been publicly approved by Trolltech ASA
** (or its successors, if any) and the KDE Free Qt Foundation. In
** addition, as a special exception, Trolltech gives you certain
** additional rights. These rights are described in the Trolltech GPL
** Exception version 1.2, which can be found at
** http://www.trolltech.com/products/qt/gplexception/ and in the file
** GPL_EXCEPTION.txt in this package.
**
** Please review the following information to ensure GNU General
** Public Licensing requirements will be met:
** http://trolltech.com/products/qt/licenses/licensing/opensource/. If
** you are unsure which license is appropriate for your use, please
** review the following information:
** http://trolltech.com/products/qt/licenses/licensing/licensingoverview
** or contact the sales department at sales@trolltech.com.
**
** In addition, as a special exception, Trolltech, as the sole
** copyright holder for Qt Designer, grants users of the Qt/Eclipse
** Integration plug-in the right for the Qt/Eclipse Integration to
** link to functionality provided by Qt Designer and its related
** libraries.
**
** This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
** INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE. Trolltech reserves all rights not expressly
** granted herein.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#include <QtCore/QMap>
#include <QtCore/QDir>
#include <QtCore/QLibraryInfo>
#include <QtHelp/QHelpEngineCore>
#include "qtdocinstaller.h"

QT_BEGIN_NAMESPACE

QtDocInstaller::QtDocInstaller(const QString &collectionFile)
{
    m_abort = false;
    m_collectionFile = collectionFile;
}

QtDocInstaller::~QtDocInstaller()
{
    if (!isRunning())
        return;
    m_mutex.lock();
    m_abort = true;
    m_mutex.unlock();
    wait();
}

void QtDocInstaller::installDocs()
{
    start(LowPriority);
}

void QtDocInstaller::run()
{
    QHelpEngineCore *helpEngine = new QHelpEngineCore(m_collectionFile);
    helpEngine->setupData();
    bool changes = false;

    QMap<QString, QString> docs;
    docs.insert(QLatin1String("html-assistant"), QLatin1String("assistant"));
    docs.insert(QLatin1String("html-designer"), QLatin1String("designer"));
    docs.insert(QLatin1String("html-linguist"), QLatin1String("linguist"));
    docs.insert(QLatin1String("html-qmake"), QLatin1String("qmake"));
    docs.insert(QLatin1String("html-qt"), QLatin1String("qt"));

    QMap<QString, QString>::const_iterator it = docs.constBegin();
    while (it != docs.constEnd()) {
        changes |= installDoc(it.key(), it.value(), helpEngine);
        m_mutex.lock();
        if (m_abort) {
            m_mutex.unlock();
            return;
        }
        m_mutex.unlock();
        ++it;
    }
    emit docsInstalled(changes);
}

bool QtDocInstaller::installDoc(const QString &path, const QString &name,
                                QHelpEngineCore *helpEngine)
{
    QString versionKey = QString(QLatin1String("qtVersion%1$$$%2")).
        arg(QLatin1String(QT_VERSION_STR)).arg(name);
    if (helpEngine->customValue(versionKey, 0).toInt() == 1)
        return false;

    QDir dir(QLibraryInfo::location(QLibraryInfo::DocumentationPath)
        + QDir::separator() + path);
    QStringList files = dir.entryList(QStringList() << QLatin1String("*.qch"));
    foreach (QString f, files) {        
        if (f.startsWith(name)) {
            QString absFileName = dir.absolutePath() + QDir::separator() + f;
            QString namespaceUri = QHelpEngineCore::namespaceUri(absFileName);
            if (namespaceUri.isEmpty())
                continue;
            if (!helpEngine->registeredDocumentations().contains(namespaceUri)) {
                if (!helpEngine->registerDocumentation(absFileName)) {
                    emit errorMessage(
                        tr("The file %1 could not be registered successfully!\n\nReason: %2")
                        .arg(absFileName).arg(helpEngine->error()));
                }
                helpEngine->setCustomValue(versionKey, 1);
                return true;
            } else {
                helpEngine->setCustomValue(versionKey, 1);
            }
        }
    }
    return false;
}

QT_END_NAMESPACE
