/****************************************************************************
**
** Copyright (C) 1992-2006 Trolltech ASA. All rights reserved.
**
** This file is part of the tools applications of the Qt Toolkit.
**
** Licensees holding valid Qt Preview licenses may use this file in
** accordance with the Qt Preview License Agreement provided with the
** Software.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
** information about Qt Commercial License Agreements.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#include "qdbusserver.h"
#include "qdbusconnection_p.h"

/*!
    \class QDBusServer

    The QDBusServer is useful for doing D-Bus peer-to-peer communication
    between processes on the same computer.
*/

/*!
  Constructs a QDBusServer with the given \a address, and the given \a parent.
*/
QDBusServer::QDBusServer(const QString &address, QObject *parent)
    : QObject(parent)
{
    d = new QDBusConnectionPrivate(this);

    if (address.isEmpty())
        return;

    // server = dbus_server_listen( "unix:tmpdir=/tmp",  &error );
    d->setServer(dbus_server_listen(address.toUtf8().constData(), &d->error));
}

/*!
    Returns true if this QDBusServer object is connected.

    If it isn't connected, you need to call the QDBusServer constructor again.
*/
bool QDBusServer::isConnected() const
{
    return d->server && dbus_server_get_is_connected(d->server);
}

/*!
    Returns the last error that happened in this server.

    This function is provided for low-level code.
*/
QDBusError QDBusServer::lastError() const
{
    return d->lastError;
}

/*!
    Returns the address this server is assosiated width.
*/
QString QDBusServer::address() const
{
    QString addr;
    if (d->server) {
        char *c = dbus_server_get_address(d->server);
        addr = QString::fromUtf8(c);
        dbus_free(c);
    }

    return addr;
}

