/****************************************************************************
**
** Copyright (C) 2004-2006 Trolltech ASA. All rights reserved.
** Copyright (C) 2001-2004 Roberto Raggi
**
** This file is part of the qt3to4 porting application of the Qt Toolkit.
**
** Licensees holding valid Qt Preview licenses may use this file in
** accordance with the Qt Preview License Agreement provided with the
** Software.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
** information about Qt Commercial License Agreements.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef ERRORS_H
#define ERRORS_H

#include <QString>

class Error
{
public:
    int code;
    int level;
    QString text;

    inline Error(int c, int l, const QString &s)
        : code(c), level(l), text(s) {}
};

class Errors
{
public:
    QT_STATIC_CONST Error& InternalError;
    QT_STATIC_CONST Error& SyntaxError;
    QT_STATIC_CONST Error& ParseError;
};

#endif
