/****************************************************************************
**
** Copyright (C) 1992-2006 Trolltech ASA. All rights reserved.
**
** This file is part of the Qt Linguist of the Qt Toolkit.
**
** Licensees holding valid Qt Preview licenses may use this file in
** accordance with the Qt Preview License Agreement provided with the
** Software.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
** information about Qt Commercial License Agreements.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#include "about.h"

#include <QPixmap>
#include <QStyle>

AboutDialog::AboutDialog(QWidget* parent, Qt::WindowFlags fl)
    : QDialog(parent, fl)
{
    setupUi(this);
    
    PixmapLabel1->setPixmap(QPixmap(":/images/splash.png"));
    Qt::TextInteractionFlags f(style()->styleHint(QStyle::SH_MessageBox_TextInteractionFlags));
    versionLabel->setTextInteractionFlags(f);
    infoText->setTextInteractionFlags(f);
    connect(PushButton1, SIGNAL(clicked()), this, SLOT(accept()));
}

void AboutDialog::languageChange()
{
    retranslateUi(this);
}
