/****************************************************************************
**
** Copyright (C) 1992-2006 Trolltech ASA. All rights reserved.
**
** This file is part of the Qt Designer of the Qt Toolkit.
**
** Licensees holding valid Qt Preview licenses may use this file in
** accordance with the Qt Preview License Agreement provided with the
** Software.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
** information about Qt Commercial License Agreements.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef GROUPBOX_TASKMENU_H
#define GROUPBOX_TASKMENU_H

#include <QGroupBox>
#include <QPointer>

#include <qdesigner_taskmenu_p.h>
#include <QtDesigner/default_extensionfactory.h>

class QLineEdit;
class QDesignerFormWindowInterface;

namespace qdesigner_internal {

class GroupBoxTaskMenu: public QDesignerTaskMenu
{
    Q_OBJECT
public:
    GroupBoxTaskMenu(QGroupBox *groupbox, QObject *parent = 0);
    virtual ~GroupBoxTaskMenu();

    virtual QAction *preferredEditAction() const;
    virtual QList<QAction*> taskActions() const;

private slots:
    void editTitle();
    void editIcon();
    void updateText(const QString &text);
    void updateSelection();

private:
    QGroupBox *m_groupbox;
    QPointer<QLineEdit> m_editor;

    QAction *m_editTitleAction;
    QList<QAction*> m_taskActions;
};

class GroupBoxTaskMenuFactory: public QExtensionFactory
{
    Q_OBJECT
public:
    GroupBoxTaskMenuFactory(QExtensionManager *extensionManager = 0);

protected:
    virtual QObject *createExtension(QObject *object, const QString &iid, QObject *parent) const;
};

}  // namespace qdesigner_internal

#endif // GROUPBOX_TASKMENU_H
