/****************************************************************************
**
** Copyright (C) 1992-2006 Trolltech ASA. All rights reserved.
**
** This file is part of the Qt Designer of the Qt Toolkit.
**
** Licensees holding valid Qt Preview licenses may use this file in
** accordance with the Qt Preview License Agreement provided with the
** Software.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
** information about Qt Commercial License Agreements.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#include "qtspinbox.h"

#include "qdebug.h"

using namespace qdesigner_internal;

QtSpinBox::QtSpinBox(QWidget *parent)
    : QSpinBox(parent)
{
}

void QtSpinBox::stepBy(int steps)
{
    QSpinBox::stepBy(steps);
    emit editingFinished();
}

QtDoubleSpinBox::QtDoubleSpinBox(QWidget *parent)
    : QDoubleSpinBox(parent)
{
}

void QtDoubleSpinBox::stepBy(int steps)
{
    QDoubleSpinBox::stepBy(steps);
    emit editingFinished();
}

void QtDoubleSpinBox::fixup(QString &input) const
{
    QDoubleSpinBox::fixup(input);
    double val = valueFromText(input);
    input = textFromValue(val);
}

