/****************************************************************************
**
** Copyright (C) 1992-2006 Trolltech ASA. All rights reserved.
**
** This file is part of the QtGui module of the Qt Toolkit.
**
** Licensees holding valid Qt Preview licenses may use this file in
** accordance with the Qt Preview License Agreement provided with the
** Software.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
** information about Qt Commercial License Agreements.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef QPRINTDIALOG_H
#define QPRINTDIALOG_H

#include <QtGui/qabstractprintdialog.h>

QT_BEGIN_HEADER

QT_MODULE(Gui)

#ifndef QT_NO_PRINTDIALOG

class QPrintDialogPrivate;
class QPushButton;
class QPrinter;

class Q_GUI_EXPORT QPrintDialog : public QAbstractPrintDialog
{
    Q_OBJECT
    Q_DECLARE_PRIVATE(QPrintDialog)
public:
    explicit QPrintDialog(QPrinter *printer, QWidget *parent = 0);
    ~QPrintDialog();

    int exec();

#if defined (Q_OS_UNIX) && !defined (Q_OS_MAC) && defined (QT3_SUPPORT)
    void setPrinter(QPrinter *, bool = false);
    QPrinter *printer() const;
    void addButton(QPushButton *button);
#endif

private:
    Q_PRIVATE_SLOT(d_func(), void _q_printToFileChanged(int))
    Q_PRIVATE_SLOT(d_func(), void _q_rbPrintRangeToggled(bool))
    Q_PRIVATE_SLOT(d_func(), void _q_printerChanged(int))
    Q_PRIVATE_SLOT(d_func(), void _q_paperSizeChanged(int))
#ifndef QT_NO_FILEDIALOG
    Q_PRIVATE_SLOT(d_func(), void _q_btnBrowseClicked())
#endif
    Q_PRIVATE_SLOT(d_func(), void _q_btnPropertiesClicked())
};

#endif // QT_NO_PRINTDIALOG

QT_END_HEADER

#endif // QPRINTDIALOG_H
