/****************************************************************************
**
** Copyright (C) 2006-2006 Trolltech ASA. All rights reserved.
**
** This file is part of the example classes of the Qt Toolkit.
**
** Licensees holding valid Qt Preview licenses may use this file in
** accordance with the Qt Preview License Agreement provided with the
** Software.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
** information about Qt Commercial License Agreements.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#include "animateditem.h"

AnimatedPixmapItem::AnimatedPixmapItem(const QList<QPixmap> &animation,
                                       QGraphicsScene *scene)
    : QGraphicsPixmapItem(0, scene), currentFrame(0), frames(animation), vx(0), vy(0)
{
}

void AnimatedPixmapItem::setFrame(int frame)
{
    if (!frames.isEmpty()) {
        currentFrame = frame % frames.size();
        setPixmap(frames.at(currentFrame));
    }
}

void AnimatedPixmapItem::advance(int phase)
{
    if (phase == 1 && !frames.isEmpty()) {
        currentFrame = (currentFrame + 1) % frames.size();
        setPixmap(frames.at(currentFrame));
        if (vx || vy)
            moveBy(vx, vy);
    }
}

QPainterPath AnimatedPixmapItem::shape() const
{
    QPainterPath path;
    path.addRect(0, 0,
                 frames.at(currentFrame).width(),
                 frames.at(currentFrame).height());
    return path;
}
