/****************************************************************************
**
** Copyright (C) 1992-2005 Trolltech AS. All rights reserved.
**
** This file is part of the Qt Designer of the Qt Toolkit.
**
** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://www.trolltech.com/products/qt/opensource.html
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://www.trolltech.com/products/qt/licensing.html or contact the
** sales department at sales@trolltech.com.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

//
//  W A R N I N G
//  -------------
//
// This file is not part of the Qt API.  It exists for the convenience
// of Qt Designer.  This header
// file may change from version to version without notice, or even be removed.
//
// We mean it.
//

#ifndef FINDICONDIALOG_H
#define FINDICONDIALOG_H

#include "shared_global_p.h"

#include <QtCore/QDir>
#include <QtGui/QDialog>

class QDesignerFormWindowInterface;
class QListWidgetItem;
class QModelIndex;

namespace Ui
{
    class FindIconDialog;
} // namespace Ui

namespace qdesigner_internal {

class ResourceEditor;

class QDESIGNER_SHARED_EXPORT FindIconDialog : public QDialog
{
    Q_OBJECT

public:
    FindIconDialog(QDesignerFormWindowInterface *form, QWidget *parent);
    virtual ~FindIconDialog();

    void setPaths(const QString &qrcPath, const QString &filePath);
    QString qrcPath() const;
    QString filePath() const;

    virtual void accept();

private slots:
    void setActiveBox();
    void updateButtons();

    void setFile(const QString &path);
    void setQrc(const QString &qrc, const QString &file);
    void cdUp();

    void itemActivated(QListWidgetItem *item);
    void currentItemChanged(QListWidgetItem *item);
    void itemActivated(const QString &qrc_path, const QString &file_name);
    void itemChanged(const QString &qrc_path, const QString &file_name);

private:
    enum InputBox { FileBox, ResourceBox };

    void setActiveBox(InputBox box);
    InputBox activeBox() const;

    Ui::FindIconDialog *ui;
    QDesignerFormWindowInterface *m_form;

    void setViewDir(const QString &path);
    QDir m_view_dir;
    struct FileData {
        QString file;
    } m_file_data;
    struct ResourceData {
        QString file;
        QString qrc;
    } m_resource_data;
    ResourceEditor *m_resource_editor;
};

} // namespace qdesigner_internal

#endif // FINDICONDIALOG_H
