/****************************************************************************
**
** Copyright (C) 1992-2005 Trolltech AS. All rights reserved.
**
** This file is part of the QtGui module of the Qt Toolkit.
**
** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://www.trolltech.com/products/qt/opensource.html
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://www.trolltech.com/products/qt/licensing.html or contact the
** sales department at sales@trolltech.com.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef QSTRINGFILTERMODEL_H
#define QSTRINGFILTERMODEL_H

#include <QtCore/qregexp.h>
#include <QtGui/qfilteringproxymodel.h>

QT_MODULE(Gui)

class QStringFilterModelPrivate;

class Q_GUI_EXPORT QStringFilterModel : public QFilteringProxyModel
{
    Q_OBJECT
    Q_PROPERTY(QRegExp regExp READ regExp WRITE setRegExp)
    Q_PROPERTY(int keyColumn READ keyColumn WRITE setKeyColumn)
public:
    QStringFilterModel(QObject *parent = 0);
    ~QStringFilterModel();

    QRegExp regExp() const;
    void setRegExp(const QRegExp &regExp);

    int keyColumn() const;
    void setKeyColumn(int column);

public Q_SLOTS:
    void setPattern(const QString &pattern); 

protected:
    QStringFilterModel(QStringFilterModelPrivate&, QObject *parent);
    bool filterRow(int source_row, const QModelIndex &source_parent) const;
    void sourceDataChanged(const QModelIndex &source_top_left,
                           const QModelIndex &spirce_bottom_right);

private:
    Q_DECLARE_PRIVATE(QStringFilterModel)
    Q_DISABLE_COPY(QStringFilterModel)
};

#endif // QSTRINGFILTERMODEL_H
