/****************************************************************************
**
** Copyright (C) 2005-2005 Trolltech AS. All rights reserved.
**
** This file is part of the example classes of the Qt Toolkit.
**
** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://www.trolltech.com/products/qt/opensource.html
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://www.trolltech.com/products/qt/licensing.html or contact the
** sales department at sales@trolltech.com.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#include <QtGui>

#include "dropsitewidget.h"
#include "dropsitewindow.h"

DropSiteWidget::DropSiteWidget(QWidget *parent)
    : QLabel(parent)
{
    setMinimumSize(200, 200);
    setFrameStyle(QFrame::Sunken | QFrame::StyledPanel);
    setAcceptDrops(true);
    setBackgroundRole(QPalette::Dark);

    setText(tr("<drop content>"));
    setAlignment(Qt::AlignCenter);
}

void DropSiteWidget::dragEnterEvent(QDragEnterEvent *event)
{
    setText(tr("<drop content>"));
    setBackgroundRole(QPalette::Light);

    event->acceptProposedAction();
    emit changed(event->mimeData());
}

void DropSiteWidget::dropEvent(QDropEvent *event)
{
    const QMimeData *mimeData = event->mimeData();
    QStringList formats = mimeData->formats();

    foreach (QString format, formats)
    {
        if (format.startsWith("image/")) {
            QPixmap pixmap = createPixmap(mimeData->data(format), format);
            if (!pixmap.isNull()) {
                setPixmap(pixmap);
                break;
            }
        }
        QString text = createPlainText(mimeData->data(format), format);
        if (!text.isEmpty()) {
            setText(text);
            break;
        } else {
            setText(tr("No supported format"));
        }
    }

    setBackgroundRole(QPalette::Dark);
    event->acceptProposedAction();
}

void DropSiteWidget::dragLeaveEvent(QDragLeaveEvent *event)
{
    clear();
    event->accept();
}

void DropSiteWidget::clear()
{
    setText(tr("<drop content>"));
    setBackgroundRole(QPalette::Dark);

    emit changed();
}

QPixmap DropSiteWidget::createPixmap(QByteArray data, QString format)
{
    QList<QByteArray> imageFormats = QImageReader::supportedImageFormats();
    QPixmap pixmap;

    foreach (QByteArray imageFormat, imageFormats) {
        if (format.mid(6) == QString(imageFormat)) {
            pixmap.loadFromData(data, imageFormat);
            break;
        }
    }
    return pixmap;
}

QString DropSiteWidget::createPlainText(QByteArray data, QString format)
{
    QString text = "";

    if (format.startsWith("text/plain")) {
        text.append(QString(data));
    } else if (format.startsWith("text/plain;")) {
        int index = format.indexOf('=');
        if (index > 0) {
            QTextCodec *codec = QTextCodec::codecForName(format.mid(index + 1).toAscii());
            text.append(QString(codec->toUnicode(data)));
        }
    }
    return text;
}


