/****************************************************************************
**
** Copyright (C) 2008 Nokia Corporation and/or its subsidiary(-ies).
** Contact: Qt Software Information (qt-info@nokia.com)
**
** This file is part of the Qt Linguist of the Qt Toolkit.
**
** No Commercial Usage
** This file contains pre-release code and may only be used for
** evaluation and testing purposes.  It may not be used for commercial
** development.  You may use this file in accordance with the terms and
** conditions contained in the either Technology Preview License
** Agreement or the Beta Release License Agreement.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License versions 2.0 or 3.0 as published by the Free
** Software Foundation and appearing in the file LICENSE.GPL included in
** the packaging of this file.  Please review the following information
** to ensure GNU General Public Licensing requirements will be met:
** http://www.fsf.org/licensing/licenses/info/GPLv2.html and
** http://www.gnu.org/copyleft/gpl.html.  In addition, as a special
** exception, Nokia gives you certain additional rights. These rights
** are described in the Nokia Qt GPL Exception version 1.3, included in
** the file GPL_EXCEPTION.txt in this package.
**
** Qt for Windows(R) Licensees
** As a special exception, Nokia, as the sole copyright holder for Qt
** Designer, grants users of the Qt/Eclipse Integration plug-in the
** right for the Qt/Eclipse Integration to link to functionality
** provided by Qt Designer and its related libraries.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at qt-sales@nokia.com.
**
****************************************************************************/

#include "recentfiles.h"

#include <QtCore/QFileInfo>
#include <QtCore/QSettings>
#include <QtCore/QString>
#include <QtCore/QStringList>

QT_BEGIN_NAMESPACE

static const char CONFIGKEY[] = "RecentlyOpenedFiles";

RecentFiles::RecentFiles(const QString &settingsPrefix, const int maxEntries)
  : m_groupOpen(false),
    m_clone1st(false),
    m_maxEntries(maxEntries),
    m_settingsPrefix(settingsPrefix)
{
    m_timer.setSingleShot(true);
    m_timer.setInterval(3 * 60 * 1000);
    connect(&m_timer, SIGNAL(timeout()), SLOT(closeGroup()));
}

void RecentFiles::addFiles(const QStringList &names)
{
    QStringList filePaths;
    foreach (const QString &name, names)
        if (name.startsWith(QLatin1Char('=')))
            filePaths << (QLatin1Char('=') + QFileInfo(name.mid(1)).absoluteFilePath());
        else
            filePaths << QFileInfo(name).absoluteFilePath();
    filePaths.sort();

    if (m_groupOpen) {
        if (!m_clone1st)
            m_strLists.removeFirst();
        else
            m_clone1st = false;
    } else {
        m_groupOpen = true;
        m_clone1st = m_strLists.removeOne(filePaths);
    }
    if (m_strLists.count() >= m_maxEntries)
        m_strLists.removeLast();
    m_strLists.prepend(filePaths);
    m_timer.start();
}

void RecentFiles::closeGroup()
{
    m_timer.stop();
    m_groupOpen = false;
}

void RecentFiles::readConfig()
{
    QSettings config;
    m_strLists.clear();
    QVariant val = config.value(m_settingsPrefix + QLatin1String(CONFIGKEY));
    if (val.type() == QVariant::StringList) // Backwards compat to Qt < 4.5
        foreach (const QString &s, val.toStringList())
            m_strLists << QStringList(s);
    else
        foreach (const QVariant &v, val.toList())
            m_strLists << v.toStringList();
}

void RecentFiles::writeConfig() const
{
    QSettings config;
    QList<QVariant> vals;
    foreach (const QStringList &sl, m_strLists)
        vals << sl;
    config.setValue(m_settingsPrefix + QLatin1String(CONFIGKEY), vals);
}

QT_END_NAMESPACE
