/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(XPATH)

#include "JSXPathException.h"

#include <wtf/GetPtr.h>

#include "KURL.h"
#include "XPathException.h"

#include <kjs/Error.h>
#include <kjs/JSNumberCell.h>
#include <kjs/JSString.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSXPathException)

/* Hash table */

static const HashTableValue JSXPathExceptionTableValues[5] =
{
    { "code", DontDelete|ReadOnly, (intptr_t)jsXPathExceptionCode, (intptr_t)0 },
    { "name", DontDelete|ReadOnly, (intptr_t)jsXPathExceptionName, (intptr_t)0 },
    { "message", DontDelete|ReadOnly, (intptr_t)jsXPathExceptionMessage, (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsXPathExceptionConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSXPathExceptionTable = { 127, JSXPathExceptionTableValues, 0 };

/* Hash table for constructor */

static const HashTableValue JSXPathExceptionConstructorTableValues[3] =
{
    { "INVALID_EXPRESSION_ERR", DontDelete|ReadOnly, (intptr_t)jsXPathExceptionINVALID_EXPRESSION_ERR, (intptr_t)0 },
    { "TYPE_ERR", DontDelete|ReadOnly, (intptr_t)jsXPathExceptionTYPE_ERR, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSXPathExceptionConstructorTable = { 3, JSXPathExceptionConstructorTableValues, 0 };

class JSXPathExceptionConstructor : public DOMObject {
public:
    JSXPathExceptionConstructor(ExecState* exec)
        : DOMObject(JSXPathExceptionConstructor::createStructureID(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSXPathExceptionPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<StructureID> createStructureID(JSValue* proto) 
    { 
        return StructureID::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSXPathExceptionConstructor::s_info = { "XPathExceptionConstructor", 0, &JSXPathExceptionConstructorTable, 0 };

bool JSXPathExceptionConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSXPathExceptionConstructor, DOMObject>(exec, &JSXPathExceptionConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSXPathExceptionPrototypeTableValues[4] =
{
    { "INVALID_EXPRESSION_ERR", DontDelete|ReadOnly, (intptr_t)jsXPathExceptionINVALID_EXPRESSION_ERR, (intptr_t)0 },
    { "TYPE_ERR", DontDelete|ReadOnly, (intptr_t)jsXPathExceptionTYPE_ERR, (intptr_t)0 },
    { "toString", DontDelete|DontEnum|Function, (intptr_t)jsXPathExceptionPrototypeFunctionToString, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSXPathExceptionPrototypeTable = { 3, JSXPathExceptionPrototypeTableValues, 0 };

const ClassInfo JSXPathExceptionPrototype::s_info = { "XPathExceptionPrototype", 0, &JSXPathExceptionPrototypeTable, 0 };

JSObject* JSXPathExceptionPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSXPathException>(exec);
}

bool JSXPathExceptionPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticPropertySlot<JSXPathExceptionPrototype, JSObject>(exec, &JSXPathExceptionPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSXPathException::s_info = { "XPathException", 0, &JSXPathExceptionTable , 0 };

JSXPathException::JSXPathException(PassRefPtr<StructureID> structure, PassRefPtr<XPathException> impl)
    : DOMObject(structure)
    , m_impl(impl)
{
}

JSXPathException::~JSXPathException()
{
    forgetDOMObject(*Heap::heap(this)->globalData(), m_impl.get());

}

JSObject* JSXPathException::createPrototype(ExecState* exec)
{
    return new (exec) JSXPathExceptionPrototype(JSXPathExceptionPrototype::createStructureID(exec->lexicalGlobalObject()->objectPrototype()));
}

bool JSXPathException::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSXPathException, Base>(exec, &JSXPathExceptionTable, this, propertyName, slot);
}

JSValue* jsXPathExceptionCode(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    XPathException* imp = static_cast<XPathException*>(static_cast<JSXPathException*>(slot.slotBase())->impl());
    return jsNumber(exec, imp->code());
}

JSValue* jsXPathExceptionName(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    XPathException* imp = static_cast<XPathException*>(static_cast<JSXPathException*>(slot.slotBase())->impl());
    return jsString(exec, imp->name());
}

JSValue* jsXPathExceptionMessage(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    XPathException* imp = static_cast<XPathException*>(static_cast<JSXPathException*>(slot.slotBase())->impl());
    return jsString(exec, imp->message());
}

JSValue* jsXPathExceptionConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSXPathException*>(slot.slotBase())->getConstructor(exec);
}
JSValue* JSXPathException::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSXPathExceptionConstructor>(exec);
}

JSValue* jsXPathExceptionPrototypeFunctionToString(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSXPathException::s_info))
        return throwError(exec, TypeError);
    JSXPathException* castedThisObj = static_cast<JSXPathException*>(thisValue);
    XPathException* imp = static_cast<XPathException*>(castedThisObj->impl());


    JSC::JSValue* result = jsString(exec, imp->toString());
    return result;
}

// Constant getters

JSValue* jsXPathExceptionINVALID_EXPRESSION_ERR(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(51));
}

JSValue* jsXPathExceptionTYPE_ERR(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(52));
}

JSC::JSValue* toJS(JSC::ExecState* exec, XPathException* object)
{
    return getDOMObjectWrapper<JSXPathException>(exec, object);
}
XPathException* toXPathException(JSC::JSValue* val)
{
    return val->isObject(&JSXPathException::s_info) ? static_cast<JSXPathException*>(val)->impl() : 0;
}

}

#endif // ENABLE(XPATH)
