/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef JSTreeWalker_h
#define JSTreeWalker_h

#include "JSDOMBinding.h"
#include <kjs/JSGlobalObject.h>
#include <kjs/ObjectPrototype.h>

namespace WebCore {

class TreeWalker;

class JSTreeWalker : public DOMObject {
    typedef DOMObject Base;
public:
    JSTreeWalker(PassRefPtr<JSC::StructureID>, PassRefPtr<TreeWalker>);
    virtual ~JSTreeWalker();
    static JSC::JSObject* createPrototype(JSC::ExecState*);
    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier& propertyName, JSC::PropertySlot&);
    virtual void put(JSC::ExecState*, const JSC::Identifier& propertyName, JSC::JSValue*, JSC::PutPropertySlot&);
    virtual const JSC::ClassInfo* classInfo() const { return &s_info; }
    static const JSC::ClassInfo s_info;

    virtual void mark();


    // Custom functions
    JSC::JSValue* parentNode(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue* firstChild(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue* lastChild(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue* previousSibling(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue* nextSibling(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue* previousNode(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue* nextNode(JSC::ExecState*, const JSC::ArgList&);
    TreeWalker* impl() const { return m_impl.get(); }

private:
    RefPtr<TreeWalker> m_impl;
};

JSC::JSValue* toJS(JSC::ExecState*, TreeWalker*);
TreeWalker* toTreeWalker(JSC::JSValue*);

class JSTreeWalkerPrototype : public JSC::JSObject {
public:
    static JSC::JSObject* self(JSC::ExecState*);
    virtual const JSC::ClassInfo* classInfo() const { return &s_info; }
    static const JSC::ClassInfo s_info;
    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    JSTreeWalkerPrototype(PassRefPtr<JSC::StructureID> structure) : JSC::JSObject(structure) { }
};

// Functions

JSC::JSValue* jsTreeWalkerPrototypeFunctionParentNode(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
JSC::JSValue* jsTreeWalkerPrototypeFunctionFirstChild(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
JSC::JSValue* jsTreeWalkerPrototypeFunctionLastChild(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
JSC::JSValue* jsTreeWalkerPrototypeFunctionPreviousSibling(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
JSC::JSValue* jsTreeWalkerPrototypeFunctionNextSibling(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
JSC::JSValue* jsTreeWalkerPrototypeFunctionPreviousNode(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
JSC::JSValue* jsTreeWalkerPrototypeFunctionNextNode(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
// Attibutes

JSC::JSValue* jsTreeWalkerRoot(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue* jsTreeWalkerWhatToShow(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue* jsTreeWalkerFilter(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue* jsTreeWalkerExpandEntityReferences(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue* jsTreeWalkerCurrentNode(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSTreeWalkerCurrentNode(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);

} // namespace WebCore

#endif
