/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSTreeWalker.h"

#include <wtf/GetPtr.h>

#include "JSNode.h"
#include "JSNodeFilter.h"
#include "Node.h"
#include "NodeFilter.h"
#include "TreeWalker.h"

#include <kjs/Error.h>
#include <kjs/JSNumberCell.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSTreeWalker)

/* Hash table */

static const HashTableValue JSTreeWalkerTableValues[6] =
{
    { "root", DontDelete|ReadOnly, (intptr_t)jsTreeWalkerRoot, (intptr_t)0 },
    { "whatToShow", DontDelete|ReadOnly, (intptr_t)jsTreeWalkerWhatToShow, (intptr_t)0 },
    { "filter", DontDelete|ReadOnly, (intptr_t)jsTreeWalkerFilter, (intptr_t)0 },
    { "expandEntityReferences", DontDelete|ReadOnly, (intptr_t)jsTreeWalkerExpandEntityReferences, (intptr_t)0 },
    { "currentNode", DontDelete, (intptr_t)jsTreeWalkerCurrentNode, (intptr_t)setJSTreeWalkerCurrentNode },
    { 0, 0, 0, 0 }
};

static const HashTable JSTreeWalkerTable = { 255, JSTreeWalkerTableValues, 0 };

/* Hash table for prototype */

static const HashTableValue JSTreeWalkerPrototypeTableValues[8] =
{
    { "parentNode", DontDelete|Function, (intptr_t)jsTreeWalkerPrototypeFunctionParentNode, (intptr_t)0 },
    { "firstChild", DontDelete|Function, (intptr_t)jsTreeWalkerPrototypeFunctionFirstChild, (intptr_t)0 },
    { "lastChild", DontDelete|Function, (intptr_t)jsTreeWalkerPrototypeFunctionLastChild, (intptr_t)0 },
    { "previousSibling", DontDelete|Function, (intptr_t)jsTreeWalkerPrototypeFunctionPreviousSibling, (intptr_t)0 },
    { "nextSibling", DontDelete|Function, (intptr_t)jsTreeWalkerPrototypeFunctionNextSibling, (intptr_t)0 },
    { "previousNode", DontDelete|Function, (intptr_t)jsTreeWalkerPrototypeFunctionPreviousNode, (intptr_t)0 },
    { "nextNode", DontDelete|Function, (intptr_t)jsTreeWalkerPrototypeFunctionNextNode, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSTreeWalkerPrototypeTable = { 15, JSTreeWalkerPrototypeTableValues, 0 };

const ClassInfo JSTreeWalkerPrototype::s_info = { "TreeWalkerPrototype", 0, &JSTreeWalkerPrototypeTable, 0 };

JSObject* JSTreeWalkerPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSTreeWalker>(exec);
}

bool JSTreeWalkerPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSTreeWalkerPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSTreeWalker::s_info = { "TreeWalker", 0, &JSTreeWalkerTable , 0 };

JSTreeWalker::JSTreeWalker(PassRefPtr<StructureID> structure, PassRefPtr<TreeWalker> impl)
    : DOMObject(structure)
    , m_impl(impl)
{
}

JSTreeWalker::~JSTreeWalker()
{
    forgetDOMObject(*Heap::heap(this)->globalData(), m_impl.get());

}

JSObject* JSTreeWalker::createPrototype(ExecState* exec)
{
    return new (exec) JSTreeWalkerPrototype(JSTreeWalkerPrototype::createStructureID(exec->lexicalGlobalObject()->objectPrototype()));
}

bool JSTreeWalker::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSTreeWalker, Base>(exec, &JSTreeWalkerTable, this, propertyName, slot);
}

JSValue* jsTreeWalkerRoot(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    TreeWalker* imp = static_cast<TreeWalker*>(static_cast<JSTreeWalker*>(slot.slotBase())->impl());
    return toJS(exec, WTF::getPtr(imp->root()));
}

JSValue* jsTreeWalkerWhatToShow(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    TreeWalker* imp = static_cast<TreeWalker*>(static_cast<JSTreeWalker*>(slot.slotBase())->impl());
    return jsNumber(exec, imp->whatToShow());
}

JSValue* jsTreeWalkerFilter(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    TreeWalker* imp = static_cast<TreeWalker*>(static_cast<JSTreeWalker*>(slot.slotBase())->impl());
    return toJS(exec, WTF::getPtr(imp->filter()));
}

JSValue* jsTreeWalkerExpandEntityReferences(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    TreeWalker* imp = static_cast<TreeWalker*>(static_cast<JSTreeWalker*>(slot.slotBase())->impl());
    return jsBoolean(imp->expandEntityReferences());
}

JSValue* jsTreeWalkerCurrentNode(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    TreeWalker* imp = static_cast<TreeWalker*>(static_cast<JSTreeWalker*>(slot.slotBase())->impl());
    return toJS(exec, WTF::getPtr(imp->currentNode()));
}

void JSTreeWalker::put(ExecState* exec, const Identifier& propertyName, JSValue* value, PutPropertySlot& slot)
{
    lookupPut<JSTreeWalker, Base>(exec, propertyName, value, &JSTreeWalkerTable, this, slot);
}

void setJSTreeWalkerCurrentNode(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    TreeWalker* imp = static_cast<TreeWalker*>(static_cast<JSTreeWalker*>(thisObject)->impl());
    ExceptionCode ec = 0;
    imp->setCurrentNode(toNode(value), ec);
    setDOMException(exec, ec);
}

JSValue* jsTreeWalkerPrototypeFunctionParentNode(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSTreeWalker::s_info))
        return throwError(exec, TypeError);
    JSTreeWalker* castedThisObj = static_cast<JSTreeWalker*>(thisValue);
    return castedThisObj->parentNode(exec, args);
}

JSValue* jsTreeWalkerPrototypeFunctionFirstChild(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSTreeWalker::s_info))
        return throwError(exec, TypeError);
    JSTreeWalker* castedThisObj = static_cast<JSTreeWalker*>(thisValue);
    return castedThisObj->firstChild(exec, args);
}

JSValue* jsTreeWalkerPrototypeFunctionLastChild(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSTreeWalker::s_info))
        return throwError(exec, TypeError);
    JSTreeWalker* castedThisObj = static_cast<JSTreeWalker*>(thisValue);
    return castedThisObj->lastChild(exec, args);
}

JSValue* jsTreeWalkerPrototypeFunctionPreviousSibling(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSTreeWalker::s_info))
        return throwError(exec, TypeError);
    JSTreeWalker* castedThisObj = static_cast<JSTreeWalker*>(thisValue);
    return castedThisObj->previousSibling(exec, args);
}

JSValue* jsTreeWalkerPrototypeFunctionNextSibling(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSTreeWalker::s_info))
        return throwError(exec, TypeError);
    JSTreeWalker* castedThisObj = static_cast<JSTreeWalker*>(thisValue);
    return castedThisObj->nextSibling(exec, args);
}

JSValue* jsTreeWalkerPrototypeFunctionPreviousNode(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSTreeWalker::s_info))
        return throwError(exec, TypeError);
    JSTreeWalker* castedThisObj = static_cast<JSTreeWalker*>(thisValue);
    return castedThisObj->previousNode(exec, args);
}

JSValue* jsTreeWalkerPrototypeFunctionNextNode(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSTreeWalker::s_info))
        return throwError(exec, TypeError);
    JSTreeWalker* castedThisObj = static_cast<JSTreeWalker*>(thisValue);
    return castedThisObj->nextNode(exec, args);
}

JSC::JSValue* toJS(JSC::ExecState* exec, TreeWalker* object)
{
    return getDOMObjectWrapper<JSTreeWalker>(exec, object);
}
TreeWalker* toTreeWalker(JSC::JSValue* val)
{
    return val->isObject(&JSTreeWalker::s_info) ? static_cast<JSTreeWalker*>(val)->impl() : 0;
}

}
