/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(SVG)

#include "SVGElement.h"
#include "JSSVGTextElement.h"

#include <wtf/GetPtr.h>

#include "JSSVGAnimatedTransformList.h"
#include "JSSVGElement.h"
#include "JSSVGMatrix.h"
#include "JSSVGRect.h"
#include "SVGElement.h"
#include "SVGTextElement.h"

#include <kjs/Error.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGTextElement)

/* Hash table */

static const HashTableValue JSSVGTextElementTableValues[4] =
{
    { "transform", DontDelete|ReadOnly, (intptr_t)jsSVGTextElementTransform, (intptr_t)0 },
    { "nearestViewportElement", DontDelete|ReadOnly, (intptr_t)jsSVGTextElementNearestViewportElement, (intptr_t)0 },
    { "farthestViewportElement", DontDelete|ReadOnly, (intptr_t)jsSVGTextElementFarthestViewportElement, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGTextElementTable = { 7, JSSVGTextElementTableValues, 0 };

/* Hash table for prototype */

static const HashTableValue JSSVGTextElementPrototypeTableValues[5] =
{
    { "getBBox", DontDelete|Function, (intptr_t)jsSVGTextElementPrototypeFunctionGetBBox, (intptr_t)0 },
    { "getCTM", DontDelete|Function, (intptr_t)jsSVGTextElementPrototypeFunctionGetCTM, (intptr_t)0 },
    { "getScreenCTM", DontDelete|Function, (intptr_t)jsSVGTextElementPrototypeFunctionGetScreenCTM, (intptr_t)0 },
    { "getTransformToElement", DontDelete|Function, (intptr_t)jsSVGTextElementPrototypeFunctionGetTransformToElement, (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGTextElementPrototypeTable = { 3, JSSVGTextElementPrototypeTableValues, 0 };

const ClassInfo JSSVGTextElementPrototype::s_info = { "SVGTextElementPrototype", 0, &JSSVGTextElementPrototypeTable, 0 };

JSObject* JSSVGTextElementPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSSVGTextElement>(exec);
}

bool JSSVGTextElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGTextElementPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSSVGTextElement::s_info = { "SVGTextElement", &JSSVGTextPositioningElement::s_info, &JSSVGTextElementTable , 0 };

JSSVGTextElement::JSSVGTextElement(PassRefPtr<StructureID> structure, PassRefPtr<SVGTextElement> impl)
    : JSSVGTextPositioningElement(structure, impl)
{
}

JSObject* JSSVGTextElement::createPrototype(ExecState* exec)
{
    return new (exec) JSSVGTextElementPrototype(JSSVGTextElementPrototype::createStructureID(JSSVGTextPositioningElementPrototype::self(exec)));
}

bool JSSVGTextElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGTextElement, Base>(exec, &JSSVGTextElementTable, this, propertyName, slot);
}

JSValue* jsSVGTextElementTransform(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGTextElement* imp = static_cast<SVGTextElement*>(static_cast<JSSVGTextElement*>(slot.slotBase())->impl());
    RefPtr<SVGAnimatedTransformList> obj = imp->transformAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValue* jsSVGTextElementNearestViewportElement(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGTextElement* imp = static_cast<SVGTextElement*>(static_cast<JSSVGTextElement*>(slot.slotBase())->impl());
    return toJS(exec, WTF::getPtr(imp->nearestViewportElement()));
}

JSValue* jsSVGTextElementFarthestViewportElement(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGTextElement* imp = static_cast<SVGTextElement*>(static_cast<JSSVGTextElement*>(slot.slotBase())->impl());
    return toJS(exec, WTF::getPtr(imp->farthestViewportElement()));
}

JSValue* jsSVGTextElementPrototypeFunctionGetBBox(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGTextElement::s_info))
        return throwError(exec, TypeError);
    JSSVGTextElement* castedThisObj = static_cast<JSSVGTextElement*>(thisValue);
    SVGTextElement* imp = static_cast<SVGTextElement*>(castedThisObj->impl());


    JSC::JSValue* result = toJS(exec, JSSVGStaticPODTypeWrapper<FloatRect>::create(imp->getBBox()).get(), imp);
    return result;
}

JSValue* jsSVGTextElementPrototypeFunctionGetCTM(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGTextElement::s_info))
        return throwError(exec, TypeError);
    JSSVGTextElement* castedThisObj = static_cast<JSSVGTextElement*>(thisValue);
    SVGTextElement* imp = static_cast<SVGTextElement*>(castedThisObj->impl());


    JSC::JSValue* result = toJS(exec, JSSVGStaticPODTypeWrapper<AffineTransform>::create(imp->getCTM()).get(), imp);
    return result;
}

JSValue* jsSVGTextElementPrototypeFunctionGetScreenCTM(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGTextElement::s_info))
        return throwError(exec, TypeError);
    JSSVGTextElement* castedThisObj = static_cast<JSSVGTextElement*>(thisValue);
    SVGTextElement* imp = static_cast<SVGTextElement*>(castedThisObj->impl());


    JSC::JSValue* result = toJS(exec, JSSVGStaticPODTypeWrapper<AffineTransform>::create(imp->getScreenCTM()).get(), imp);
    return result;
}

JSValue* jsSVGTextElementPrototypeFunctionGetTransformToElement(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGTextElement::s_info))
        return throwError(exec, TypeError);
    JSSVGTextElement* castedThisObj = static_cast<JSSVGTextElement*>(thisValue);
    SVGTextElement* imp = static_cast<SVGTextElement*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    SVGElement* element = toSVGElement(args.at(exec, 0));


    JSC::JSValue* result = toJS(exec, JSSVGStaticPODTypeWrapper<AffineTransform>::create(imp->getTransformToElement(element, ec)).get(), imp);
    setDOMException(exec, ec);
    return result;
}


}

#endif // ENABLE(SVG)
