/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(SVG)

#include "SVGElement.h"
#include "JSSVGStyleElement.h"

#include <wtf/GetPtr.h>

#include "KURL.h"
#include "SVGStyleElement.h"

#include <kjs/JSString.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGStyleElement)

/* Hash table */

static const HashTableValue JSSVGStyleElementTableValues[5] =
{
    { "xmlspace", DontDelete, (intptr_t)jsSVGStyleElementXmlspace, (intptr_t)setJSSVGStyleElementXmlspace },
    { "type", DontDelete, (intptr_t)jsSVGStyleElementType, (intptr_t)setJSSVGStyleElementType },
    { "media", DontDelete, (intptr_t)jsSVGStyleElementMedia, (intptr_t)setJSSVGStyleElementMedia },
    { "title", DontDelete, (intptr_t)jsSVGStyleElementTitle, (intptr_t)setJSSVGStyleElementTitle },
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGStyleElementTable = { 31, JSSVGStyleElementTableValues, 0 };

/* Hash table for prototype */

static const HashTableValue JSSVGStyleElementPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGStyleElementPrototypeTable = { 0, JSSVGStyleElementPrototypeTableValues, 0 };

const ClassInfo JSSVGStyleElementPrototype::s_info = { "SVGStyleElementPrototype", 0, &JSSVGStyleElementPrototypeTable, 0 };

JSObject* JSSVGStyleElementPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSSVGStyleElement>(exec);
}

const ClassInfo JSSVGStyleElement::s_info = { "SVGStyleElement", &JSSVGElement::s_info, &JSSVGStyleElementTable , 0 };

JSSVGStyleElement::JSSVGStyleElement(PassRefPtr<StructureID> structure, PassRefPtr<SVGStyleElement> impl)
    : JSSVGElement(structure, impl)
{
}

JSObject* JSSVGStyleElement::createPrototype(ExecState* exec)
{
    return new (exec) JSSVGStyleElementPrototype(JSSVGStyleElementPrototype::createStructureID(JSSVGElementPrototype::self(exec)));
}

bool JSSVGStyleElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGStyleElement, Base>(exec, &JSSVGStyleElementTable, this, propertyName, slot);
}

JSValue* jsSVGStyleElementXmlspace(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGStyleElement* imp = static_cast<SVGStyleElement*>(static_cast<JSSVGStyleElement*>(slot.slotBase())->impl());
    return jsString(exec, imp->xmlspace());
}

JSValue* jsSVGStyleElementType(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGStyleElement* imp = static_cast<SVGStyleElement*>(static_cast<JSSVGStyleElement*>(slot.slotBase())->impl());
    return jsString(exec, imp->type());
}

JSValue* jsSVGStyleElementMedia(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGStyleElement* imp = static_cast<SVGStyleElement*>(static_cast<JSSVGStyleElement*>(slot.slotBase())->impl());
    return jsString(exec, imp->media());
}

JSValue* jsSVGStyleElementTitle(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGStyleElement* imp = static_cast<SVGStyleElement*>(static_cast<JSSVGStyleElement*>(slot.slotBase())->impl());
    return jsString(exec, imp->title());
}

void JSSVGStyleElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value, PutPropertySlot& slot)
{
    lookupPut<JSSVGStyleElement, Base>(exec, propertyName, value, &JSSVGStyleElementTable, this, slot);
}

void setJSSVGStyleElementXmlspace(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    SVGStyleElement* imp = static_cast<SVGStyleElement*>(static_cast<JSSVGStyleElement*>(thisObject)->impl());
    ExceptionCode ec = 0;
    imp->setXmlspace(value->toString(exec), ec);
    setDOMException(exec, ec);
}

void setJSSVGStyleElementType(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    SVGStyleElement* imp = static_cast<SVGStyleElement*>(static_cast<JSSVGStyleElement*>(thisObject)->impl());
    ExceptionCode ec = 0;
    imp->setType(value->toString(exec), ec);
    setDOMException(exec, ec);
}

void setJSSVGStyleElementMedia(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    SVGStyleElement* imp = static_cast<SVGStyleElement*>(static_cast<JSSVGStyleElement*>(thisObject)->impl());
    ExceptionCode ec = 0;
    imp->setMedia(value->toString(exec), ec);
    setDOMException(exec, ec);
}

void setJSSVGStyleElementTitle(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    SVGStyleElement* imp = static_cast<SVGStyleElement*>(static_cast<JSSVGStyleElement*>(thisObject)->impl());
    ExceptionCode ec = 0;
    imp->setTitle(value->toString(exec), ec);
    setDOMException(exec, ec);
}


}

#endif // ENABLE(SVG)
