/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(SVG)

#include "SVGElement.h"
#include "JSSVGPoint.h"

#include <wtf/GetPtr.h>

#include "JSSVGMatrix.h"
#include "JSSVGPoint.h"

#include <kjs/Error.h>
#include <kjs/JSNumberCell.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGPoint)

/* Hash table */

static const HashTableValue JSSVGPointTableValues[3] =
{
    { "x", DontDelete, (intptr_t)jsSVGPointX, (intptr_t)setJSSVGPointX },
    { "y", DontDelete, (intptr_t)jsSVGPointY, (intptr_t)setJSSVGPointY },
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGPointTable = { 1, JSSVGPointTableValues, 0 };

/* Hash table for prototype */

static const HashTableValue JSSVGPointPrototypeTableValues[2] =
{
    { "matrixTransform", DontDelete|Function, (intptr_t)jsSVGPointPrototypeFunctionMatrixTransform, (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGPointPrototypeTable = { 0, JSSVGPointPrototypeTableValues, 0 };

const ClassInfo JSSVGPointPrototype::s_info = { "SVGPointPrototype", 0, &JSSVGPointPrototypeTable, 0 };

JSObject* JSSVGPointPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSSVGPoint>(exec);
}

bool JSSVGPointPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGPointPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSSVGPoint::s_info = { "SVGPoint", 0, &JSSVGPointTable , 0 };

JSSVGPoint::JSSVGPoint(PassRefPtr<StructureID> structure, PassRefPtr<JSSVGPODTypeWrapper<FloatPoint> > impl, SVGElement* context)
    : DOMObject(structure)
    , m_context(context)
    , m_impl(impl)
{
}

JSSVGPoint::~JSSVGPoint()
{
    forgetDOMObject(*Heap::heap(this)->globalData(), m_impl.get());

}

JSObject* JSSVGPoint::createPrototype(ExecState* exec)
{
    return new (exec) JSSVGPointPrototype(JSSVGPointPrototype::createStructureID(exec->lexicalGlobalObject()->objectPrototype()));
}

bool JSSVGPoint::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGPoint, Base>(exec, &JSSVGPointTable, this, propertyName, slot);
}

JSValue* jsSVGPointX(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    FloatPoint imp(*static_cast<JSSVGPoint*>(slot.slotBase())->impl());
    return jsNumber(exec, imp.x());
}

JSValue* jsSVGPointY(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    FloatPoint imp(*static_cast<JSSVGPoint*>(slot.slotBase())->impl());
    return jsNumber(exec, imp.y());
}

void JSSVGPoint::put(ExecState* exec, const Identifier& propertyName, JSValue* value, PutPropertySlot& slot)
{
    lookupPut<JSSVGPoint, Base>(exec, propertyName, value, &JSSVGPointTable, this, slot);
}

void setJSSVGPointX(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    FloatPoint imp(*static_cast<JSSVGPoint*>(thisObject)->impl());
    imp.setX(value->toFloat(exec));
        static_cast<JSSVGPoint*>(thisObject)->impl()->commitChange(imp, static_cast<JSSVGPoint*>(thisObject)->context());
}

void setJSSVGPointY(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    FloatPoint imp(*static_cast<JSSVGPoint*>(thisObject)->impl());
    imp.setY(value->toFloat(exec));
        static_cast<JSSVGPoint*>(thisObject)->impl()->commitChange(imp, static_cast<JSSVGPoint*>(thisObject)->context());
}

JSValue* jsSVGPointPrototypeFunctionMatrixTransform(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGPoint::s_info))
        return throwError(exec, TypeError);
    JSSVGPoint* castedThisObj = static_cast<JSSVGPoint*>(thisValue);
    JSSVGPODTypeWrapper<FloatPoint>* wrapper = castedThisObj->impl();
    FloatPoint imp(*wrapper);
    AffineTransform matrix = toSVGMatrix(args.at(exec, 0));


    JSC::JSValue* result = toJS(exec, JSSVGStaticPODTypeWrapper<FloatPoint>::create(imp.matrixTransform(matrix)).get(), castedThisObj->context());
    wrapper->commitChange(imp, castedThisObj->context());
    return result;
}

JSC::JSValue* toJS(JSC::ExecState* exec, JSSVGPODTypeWrapper<FloatPoint>* object, SVGElement* context)
{
    return getDOMObjectWrapper<JSSVGPoint, JSSVGPODTypeWrapper<FloatPoint> >(exec, object, context);
}
FloatPoint toSVGPoint(JSC::JSValue* val)
{
    return val->isObject(&JSSVGPoint::s_info) ? (FloatPoint) *static_cast<JSSVGPoint*>(val)->impl() : FloatPoint();
}

}

#endif // ENABLE(SVG)
