/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(SVG)

#include "SVGElement.h"
#include "JSSVGMatrix.h"

#include <wtf/GetPtr.h>


#include <kjs/Error.h>
#include <kjs/JSNumberCell.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGMatrix)

/* Hash table */

static const HashTableValue JSSVGMatrixTableValues[7] =
{
    { "a", DontDelete, (intptr_t)jsSVGMatrixA, (intptr_t)setJSSVGMatrixA },
    { "b", DontDelete, (intptr_t)jsSVGMatrixB, (intptr_t)setJSSVGMatrixB },
    { "c", DontDelete, (intptr_t)jsSVGMatrixC, (intptr_t)setJSSVGMatrixC },
    { "d", DontDelete, (intptr_t)jsSVGMatrixD, (intptr_t)setJSSVGMatrixD },
    { "e", DontDelete, (intptr_t)jsSVGMatrixE, (intptr_t)setJSSVGMatrixE },
    { "f", DontDelete, (intptr_t)jsSVGMatrixF, (intptr_t)setJSSVGMatrixF },
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGMatrixTable = { 15, JSSVGMatrixTableValues, 0 };

/* Hash table for prototype */

static const HashTableValue JSSVGMatrixPrototypeTableValues[12] =
{
    { "multiply", DontDelete|Function, (intptr_t)jsSVGMatrixPrototypeFunctionMultiply, (intptr_t)1 },
    { "inverse", DontDelete|Function, (intptr_t)jsSVGMatrixPrototypeFunctionInverse, (intptr_t)0 },
    { "translate", DontDelete|Function, (intptr_t)jsSVGMatrixPrototypeFunctionTranslate, (intptr_t)2 },
    { "scale", DontDelete|Function, (intptr_t)jsSVGMatrixPrototypeFunctionScale, (intptr_t)1 },
    { "scaleNonUniform", DontDelete|Function, (intptr_t)jsSVGMatrixPrototypeFunctionScaleNonUniform, (intptr_t)2 },
    { "rotate", DontDelete|Function, (intptr_t)jsSVGMatrixPrototypeFunctionRotate, (intptr_t)1 },
    { "rotateFromVector", DontDelete|Function, (intptr_t)jsSVGMatrixPrototypeFunctionRotateFromVector, (intptr_t)2 },
    { "flipX", DontDelete|Function, (intptr_t)jsSVGMatrixPrototypeFunctionFlipX, (intptr_t)0 },
    { "flipY", DontDelete|Function, (intptr_t)jsSVGMatrixPrototypeFunctionFlipY, (intptr_t)0 },
    { "skewX", DontDelete|Function, (intptr_t)jsSVGMatrixPrototypeFunctionSkewX, (intptr_t)1 },
    { "skewY", DontDelete|Function, (intptr_t)jsSVGMatrixPrototypeFunctionSkewY, (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGMatrixPrototypeTable = { 63, JSSVGMatrixPrototypeTableValues, 0 };

const ClassInfo JSSVGMatrixPrototype::s_info = { "SVGMatrixPrototype", 0, &JSSVGMatrixPrototypeTable, 0 };

JSObject* JSSVGMatrixPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSSVGMatrix>(exec);
}

bool JSSVGMatrixPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGMatrixPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSSVGMatrix::s_info = { "SVGMatrix", 0, &JSSVGMatrixTable , 0 };

JSSVGMatrix::JSSVGMatrix(PassRefPtr<StructureID> structure, PassRefPtr<JSSVGPODTypeWrapper<AffineTransform> > impl, SVGElement* context)
    : DOMObject(structure)
    , m_context(context)
    , m_impl(impl)
{
}

JSSVGMatrix::~JSSVGMatrix()
{
    forgetDOMObject(*Heap::heap(this)->globalData(), m_impl.get());

}

JSObject* JSSVGMatrix::createPrototype(ExecState* exec)
{
    return new (exec) JSSVGMatrixPrototype(JSSVGMatrixPrototype::createStructureID(exec->lexicalGlobalObject()->objectPrototype()));
}

bool JSSVGMatrix::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGMatrix, Base>(exec, &JSSVGMatrixTable, this, propertyName, slot);
}

JSValue* jsSVGMatrixA(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    AffineTransform imp(*static_cast<JSSVGMatrix*>(slot.slotBase())->impl());
    return jsNumber(exec, imp.a());
}

JSValue* jsSVGMatrixB(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    AffineTransform imp(*static_cast<JSSVGMatrix*>(slot.slotBase())->impl());
    return jsNumber(exec, imp.b());
}

JSValue* jsSVGMatrixC(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    AffineTransform imp(*static_cast<JSSVGMatrix*>(slot.slotBase())->impl());
    return jsNumber(exec, imp.c());
}

JSValue* jsSVGMatrixD(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    AffineTransform imp(*static_cast<JSSVGMatrix*>(slot.slotBase())->impl());
    return jsNumber(exec, imp.d());
}

JSValue* jsSVGMatrixE(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    AffineTransform imp(*static_cast<JSSVGMatrix*>(slot.slotBase())->impl());
    return jsNumber(exec, imp.e());
}

JSValue* jsSVGMatrixF(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    AffineTransform imp(*static_cast<JSSVGMatrix*>(slot.slotBase())->impl());
    return jsNumber(exec, imp.f());
}

void JSSVGMatrix::put(ExecState* exec, const Identifier& propertyName, JSValue* value, PutPropertySlot& slot)
{
    lookupPut<JSSVGMatrix, Base>(exec, propertyName, value, &JSSVGMatrixTable, this, slot);
}

void setJSSVGMatrixA(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    AffineTransform imp(*static_cast<JSSVGMatrix*>(thisObject)->impl());
    imp.setA(value->toNumber(exec));
        static_cast<JSSVGMatrix*>(thisObject)->impl()->commitChange(imp, static_cast<JSSVGMatrix*>(thisObject)->context());
}

void setJSSVGMatrixB(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    AffineTransform imp(*static_cast<JSSVGMatrix*>(thisObject)->impl());
    imp.setB(value->toNumber(exec));
        static_cast<JSSVGMatrix*>(thisObject)->impl()->commitChange(imp, static_cast<JSSVGMatrix*>(thisObject)->context());
}

void setJSSVGMatrixC(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    AffineTransform imp(*static_cast<JSSVGMatrix*>(thisObject)->impl());
    imp.setC(value->toNumber(exec));
        static_cast<JSSVGMatrix*>(thisObject)->impl()->commitChange(imp, static_cast<JSSVGMatrix*>(thisObject)->context());
}

void setJSSVGMatrixD(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    AffineTransform imp(*static_cast<JSSVGMatrix*>(thisObject)->impl());
    imp.setD(value->toNumber(exec));
        static_cast<JSSVGMatrix*>(thisObject)->impl()->commitChange(imp, static_cast<JSSVGMatrix*>(thisObject)->context());
}

void setJSSVGMatrixE(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    AffineTransform imp(*static_cast<JSSVGMatrix*>(thisObject)->impl());
    imp.setE(value->toNumber(exec));
        static_cast<JSSVGMatrix*>(thisObject)->impl()->commitChange(imp, static_cast<JSSVGMatrix*>(thisObject)->context());
}

void setJSSVGMatrixF(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    AffineTransform imp(*static_cast<JSSVGMatrix*>(thisObject)->impl());
    imp.setF(value->toNumber(exec));
        static_cast<JSSVGMatrix*>(thisObject)->impl()->commitChange(imp, static_cast<JSSVGMatrix*>(thisObject)->context());
}

JSValue* jsSVGMatrixPrototypeFunctionMultiply(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGMatrix::s_info))
        return throwError(exec, TypeError);
    JSSVGMatrix* castedThisObj = static_cast<JSSVGMatrix*>(thisValue);
    return castedThisObj->multiply(exec, args);
}

JSValue* jsSVGMatrixPrototypeFunctionInverse(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGMatrix::s_info))
        return throwError(exec, TypeError);
    JSSVGMatrix* castedThisObj = static_cast<JSSVGMatrix*>(thisValue);
    return castedThisObj->inverse(exec, args);
}

JSValue* jsSVGMatrixPrototypeFunctionTranslate(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGMatrix::s_info))
        return throwError(exec, TypeError);
    JSSVGMatrix* castedThisObj = static_cast<JSSVGMatrix*>(thisValue);
    return castedThisObj->translate(exec, args);
}

JSValue* jsSVGMatrixPrototypeFunctionScale(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGMatrix::s_info))
        return throwError(exec, TypeError);
    JSSVGMatrix* castedThisObj = static_cast<JSSVGMatrix*>(thisValue);
    return castedThisObj->scale(exec, args);
}

JSValue* jsSVGMatrixPrototypeFunctionScaleNonUniform(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGMatrix::s_info))
        return throwError(exec, TypeError);
    JSSVGMatrix* castedThisObj = static_cast<JSSVGMatrix*>(thisValue);
    return castedThisObj->scaleNonUniform(exec, args);
}

JSValue* jsSVGMatrixPrototypeFunctionRotate(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGMatrix::s_info))
        return throwError(exec, TypeError);
    JSSVGMatrix* castedThisObj = static_cast<JSSVGMatrix*>(thisValue);
    return castedThisObj->rotate(exec, args);
}

JSValue* jsSVGMatrixPrototypeFunctionRotateFromVector(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGMatrix::s_info))
        return throwError(exec, TypeError);
    JSSVGMatrix* castedThisObj = static_cast<JSSVGMatrix*>(thisValue);
    return castedThisObj->rotateFromVector(exec, args);
}

JSValue* jsSVGMatrixPrototypeFunctionFlipX(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGMatrix::s_info))
        return throwError(exec, TypeError);
    JSSVGMatrix* castedThisObj = static_cast<JSSVGMatrix*>(thisValue);
    return castedThisObj->flipX(exec, args);
}

JSValue* jsSVGMatrixPrototypeFunctionFlipY(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGMatrix::s_info))
        return throwError(exec, TypeError);
    JSSVGMatrix* castedThisObj = static_cast<JSSVGMatrix*>(thisValue);
    return castedThisObj->flipY(exec, args);
}

JSValue* jsSVGMatrixPrototypeFunctionSkewX(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGMatrix::s_info))
        return throwError(exec, TypeError);
    JSSVGMatrix* castedThisObj = static_cast<JSSVGMatrix*>(thisValue);
    return castedThisObj->skewX(exec, args);
}

JSValue* jsSVGMatrixPrototypeFunctionSkewY(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGMatrix::s_info))
        return throwError(exec, TypeError);
    JSSVGMatrix* castedThisObj = static_cast<JSSVGMatrix*>(thisValue);
    return castedThisObj->skewY(exec, args);
}

JSC::JSValue* toJS(JSC::ExecState* exec, JSSVGPODTypeWrapper<AffineTransform>* object, SVGElement* context)
{
    return getDOMObjectWrapper<JSSVGMatrix, JSSVGPODTypeWrapper<AffineTransform> >(exec, object, context);
}
AffineTransform toSVGMatrix(JSC::JSValue* val)
{
    return val->isObject(&JSSVGMatrix::s_info) ? (AffineTransform) *static_cast<JSSVGMatrix*>(val)->impl() : AffineTransform();
}

}

#endif // ENABLE(SVG)
