/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(SVG) && ENABLE(SVG_FILTERS)

#include "SVGElement.h"
#include "JSSVGFEDisplacementMapElement.h"

#include <wtf/GetPtr.h>

#include "CSSMutableStyleDeclaration.h"
#include "CSSStyleDeclaration.h"
#include "CSSValue.h"
#include "JSCSSStyleDeclaration.h"
#include "JSCSSValue.h"
#include "JSSVGAnimatedEnumeration.h"
#include "JSSVGAnimatedLength.h"
#include "JSSVGAnimatedNumber.h"
#include "JSSVGAnimatedString.h"
#include "SVGFEDisplacementMapElement.h"

#include <kjs/Error.h>
#include <kjs/JSNumberCell.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGFEDisplacementMapElement)

/* Hash table */

static const HashTableValue JSSVGFEDisplacementMapElementTableValues[14] =
{
    { "in1", DontDelete|ReadOnly, (intptr_t)jsSVGFEDisplacementMapElementIn1, (intptr_t)0 },
    { "in2", DontDelete|ReadOnly, (intptr_t)jsSVGFEDisplacementMapElementIn2, (intptr_t)0 },
    { "scale", DontDelete|ReadOnly, (intptr_t)jsSVGFEDisplacementMapElementScale, (intptr_t)0 },
    { "xChannelSelector", DontDelete|ReadOnly, (intptr_t)jsSVGFEDisplacementMapElementXChannelSelector, (intptr_t)0 },
    { "yChannelSelector", DontDelete|ReadOnly, (intptr_t)jsSVGFEDisplacementMapElementYChannelSelector, (intptr_t)0 },
    { "x", DontDelete|ReadOnly, (intptr_t)jsSVGFEDisplacementMapElementX, (intptr_t)0 },
    { "y", DontDelete|ReadOnly, (intptr_t)jsSVGFEDisplacementMapElementY, (intptr_t)0 },
    { "width", DontDelete|ReadOnly, (intptr_t)jsSVGFEDisplacementMapElementWidth, (intptr_t)0 },
    { "height", DontDelete|ReadOnly, (intptr_t)jsSVGFEDisplacementMapElementHeight, (intptr_t)0 },
    { "result", DontDelete|ReadOnly, (intptr_t)jsSVGFEDisplacementMapElementResult, (intptr_t)0 },
    { "className", DontDelete|ReadOnly, (intptr_t)jsSVGFEDisplacementMapElementClassName, (intptr_t)0 },
    { "style", DontDelete|ReadOnly, (intptr_t)jsSVGFEDisplacementMapElementStyle, (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsSVGFEDisplacementMapElementConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGFEDisplacementMapElementTable = { 255, JSSVGFEDisplacementMapElementTableValues, 0 };

/* Hash table for constructor */

static const HashTableValue JSSVGFEDisplacementMapElementConstructorTableValues[6] =
{
    { "SVG_CHANNEL_UNKNOWN", DontDelete|ReadOnly, (intptr_t)jsSVGFEDisplacementMapElementSVG_CHANNEL_UNKNOWN, (intptr_t)0 },
    { "SVG_CHANNEL_R", DontDelete|ReadOnly, (intptr_t)jsSVGFEDisplacementMapElementSVG_CHANNEL_R, (intptr_t)0 },
    { "SVG_CHANNEL_G", DontDelete|ReadOnly, (intptr_t)jsSVGFEDisplacementMapElementSVG_CHANNEL_G, (intptr_t)0 },
    { "SVG_CHANNEL_B", DontDelete|ReadOnly, (intptr_t)jsSVGFEDisplacementMapElementSVG_CHANNEL_B, (intptr_t)0 },
    { "SVG_CHANNEL_A", DontDelete|ReadOnly, (intptr_t)jsSVGFEDisplacementMapElementSVG_CHANNEL_A, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGFEDisplacementMapElementConstructorTable = { 15, JSSVGFEDisplacementMapElementConstructorTableValues, 0 };

class JSSVGFEDisplacementMapElementConstructor : public DOMObject {
public:
    JSSVGFEDisplacementMapElementConstructor(ExecState* exec)
        : DOMObject(JSSVGFEDisplacementMapElementConstructor::createStructureID(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSSVGFEDisplacementMapElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<StructureID> createStructureID(JSValue* proto) 
    { 
        return StructureID::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSSVGFEDisplacementMapElementConstructor::s_info = { "SVGFEDisplacementMapElementConstructor", 0, &JSSVGFEDisplacementMapElementConstructorTable, 0 };

bool JSSVGFEDisplacementMapElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGFEDisplacementMapElementConstructor, DOMObject>(exec, &JSSVGFEDisplacementMapElementConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSSVGFEDisplacementMapElementPrototypeTableValues[7] =
{
    { "SVG_CHANNEL_UNKNOWN", DontDelete|ReadOnly, (intptr_t)jsSVGFEDisplacementMapElementSVG_CHANNEL_UNKNOWN, (intptr_t)0 },
    { "SVG_CHANNEL_R", DontDelete|ReadOnly, (intptr_t)jsSVGFEDisplacementMapElementSVG_CHANNEL_R, (intptr_t)0 },
    { "SVG_CHANNEL_G", DontDelete|ReadOnly, (intptr_t)jsSVGFEDisplacementMapElementSVG_CHANNEL_G, (intptr_t)0 },
    { "SVG_CHANNEL_B", DontDelete|ReadOnly, (intptr_t)jsSVGFEDisplacementMapElementSVG_CHANNEL_B, (intptr_t)0 },
    { "SVG_CHANNEL_A", DontDelete|ReadOnly, (intptr_t)jsSVGFEDisplacementMapElementSVG_CHANNEL_A, (intptr_t)0 },
    { "getPresentationAttribute", DontDelete|Function, (intptr_t)jsSVGFEDisplacementMapElementPrototypeFunctionGetPresentationAttribute, (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGFEDisplacementMapElementPrototypeTable = { 15, JSSVGFEDisplacementMapElementPrototypeTableValues, 0 };

const ClassInfo JSSVGFEDisplacementMapElementPrototype::s_info = { "SVGFEDisplacementMapElementPrototype", 0, &JSSVGFEDisplacementMapElementPrototypeTable, 0 };

JSObject* JSSVGFEDisplacementMapElementPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSSVGFEDisplacementMapElement>(exec);
}

bool JSSVGFEDisplacementMapElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticPropertySlot<JSSVGFEDisplacementMapElementPrototype, JSObject>(exec, &JSSVGFEDisplacementMapElementPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSSVGFEDisplacementMapElement::s_info = { "SVGFEDisplacementMapElement", &JSSVGElement::s_info, &JSSVGFEDisplacementMapElementTable , 0 };

JSSVGFEDisplacementMapElement::JSSVGFEDisplacementMapElement(PassRefPtr<StructureID> structure, PassRefPtr<SVGFEDisplacementMapElement> impl)
    : JSSVGElement(structure, impl)
{
}

JSObject* JSSVGFEDisplacementMapElement::createPrototype(ExecState* exec)
{
    return new (exec) JSSVGFEDisplacementMapElementPrototype(JSSVGFEDisplacementMapElementPrototype::createStructureID(JSSVGElementPrototype::self(exec)));
}

bool JSSVGFEDisplacementMapElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGFEDisplacementMapElement, Base>(exec, &JSSVGFEDisplacementMapElementTable, this, propertyName, slot);
}

JSValue* jsSVGFEDisplacementMapElementIn1(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGFEDisplacementMapElement* imp = static_cast<SVGFEDisplacementMapElement*>(static_cast<JSSVGFEDisplacementMapElement*>(slot.slotBase())->impl());
    RefPtr<SVGAnimatedString> obj = imp->in1Animated();
    return toJS(exec, obj.get(), imp);
}

JSValue* jsSVGFEDisplacementMapElementIn2(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGFEDisplacementMapElement* imp = static_cast<SVGFEDisplacementMapElement*>(static_cast<JSSVGFEDisplacementMapElement*>(slot.slotBase())->impl());
    RefPtr<SVGAnimatedString> obj = imp->in2Animated();
    return toJS(exec, obj.get(), imp);
}

JSValue* jsSVGFEDisplacementMapElementScale(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGFEDisplacementMapElement* imp = static_cast<SVGFEDisplacementMapElement*>(static_cast<JSSVGFEDisplacementMapElement*>(slot.slotBase())->impl());
    RefPtr<SVGAnimatedNumber> obj = imp->scaleAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValue* jsSVGFEDisplacementMapElementXChannelSelector(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGFEDisplacementMapElement* imp = static_cast<SVGFEDisplacementMapElement*>(static_cast<JSSVGFEDisplacementMapElement*>(slot.slotBase())->impl());
    RefPtr<SVGAnimatedEnumeration> obj = imp->xChannelSelectorAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValue* jsSVGFEDisplacementMapElementYChannelSelector(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGFEDisplacementMapElement* imp = static_cast<SVGFEDisplacementMapElement*>(static_cast<JSSVGFEDisplacementMapElement*>(slot.slotBase())->impl());
    RefPtr<SVGAnimatedEnumeration> obj = imp->yChannelSelectorAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValue* jsSVGFEDisplacementMapElementX(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGFEDisplacementMapElement* imp = static_cast<SVGFEDisplacementMapElement*>(static_cast<JSSVGFEDisplacementMapElement*>(slot.slotBase())->impl());
    RefPtr<SVGAnimatedLength> obj = imp->xAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValue* jsSVGFEDisplacementMapElementY(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGFEDisplacementMapElement* imp = static_cast<SVGFEDisplacementMapElement*>(static_cast<JSSVGFEDisplacementMapElement*>(slot.slotBase())->impl());
    RefPtr<SVGAnimatedLength> obj = imp->yAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValue* jsSVGFEDisplacementMapElementWidth(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGFEDisplacementMapElement* imp = static_cast<SVGFEDisplacementMapElement*>(static_cast<JSSVGFEDisplacementMapElement*>(slot.slotBase())->impl());
    RefPtr<SVGAnimatedLength> obj = imp->widthAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValue* jsSVGFEDisplacementMapElementHeight(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGFEDisplacementMapElement* imp = static_cast<SVGFEDisplacementMapElement*>(static_cast<JSSVGFEDisplacementMapElement*>(slot.slotBase())->impl());
    RefPtr<SVGAnimatedLength> obj = imp->heightAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValue* jsSVGFEDisplacementMapElementResult(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGFEDisplacementMapElement* imp = static_cast<SVGFEDisplacementMapElement*>(static_cast<JSSVGFEDisplacementMapElement*>(slot.slotBase())->impl());
    RefPtr<SVGAnimatedString> obj = imp->resultAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValue* jsSVGFEDisplacementMapElementClassName(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGFEDisplacementMapElement* imp = static_cast<SVGFEDisplacementMapElement*>(static_cast<JSSVGFEDisplacementMapElement*>(slot.slotBase())->impl());
    RefPtr<SVGAnimatedString> obj = imp->classNameAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValue* jsSVGFEDisplacementMapElementStyle(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGFEDisplacementMapElement* imp = static_cast<SVGFEDisplacementMapElement*>(static_cast<JSSVGFEDisplacementMapElement*>(slot.slotBase())->impl());
    return toJS(exec, WTF::getPtr(imp->style()));
}

JSValue* jsSVGFEDisplacementMapElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSSVGFEDisplacementMapElement*>(slot.slotBase())->getConstructor(exec);
}
JSValue* JSSVGFEDisplacementMapElement::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSSVGFEDisplacementMapElementConstructor>(exec);
}

JSValue* jsSVGFEDisplacementMapElementPrototypeFunctionGetPresentationAttribute(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGFEDisplacementMapElement::s_info))
        return throwError(exec, TypeError);
    JSSVGFEDisplacementMapElement* castedThisObj = static_cast<JSSVGFEDisplacementMapElement*>(thisValue);
    SVGFEDisplacementMapElement* imp = static_cast<SVGFEDisplacementMapElement*>(castedThisObj->impl());
    const UString& name = args.at(exec, 0)->toString(exec);


    JSC::JSValue* result = toJS(exec, WTF::getPtr(imp->getPresentationAttribute(name)));
    return result;
}

// Constant getters

JSValue* jsSVGFEDisplacementMapElementSVG_CHANNEL_UNKNOWN(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(0));
}

JSValue* jsSVGFEDisplacementMapElementSVG_CHANNEL_R(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(1));
}

JSValue* jsSVGFEDisplacementMapElementSVG_CHANNEL_G(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(2));
}

JSValue* jsSVGFEDisplacementMapElementSVG_CHANNEL_B(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(3));
}

JSValue* jsSVGFEDisplacementMapElementSVG_CHANNEL_A(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(4));
}


}

#endif // ENABLE(SVG) && ENABLE(SVG_FILTERS)
