/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(SVG) && ENABLE(SVG_FILTERS)

#include "SVGElement.h"
#include "JSSVGFEBlendElement.h"

#include <wtf/GetPtr.h>

#include "CSSMutableStyleDeclaration.h"
#include "CSSStyleDeclaration.h"
#include "CSSValue.h"
#include "JSCSSStyleDeclaration.h"
#include "JSCSSValue.h"
#include "JSSVGAnimatedEnumeration.h"
#include "JSSVGAnimatedLength.h"
#include "JSSVGAnimatedString.h"
#include "SVGFEBlendElement.h"

#include <kjs/Error.h>
#include <kjs/JSNumberCell.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGFEBlendElement)

/* Hash table */

static const HashTableValue JSSVGFEBlendElementTableValues[12] =
{
    { "in1", DontDelete|ReadOnly, (intptr_t)jsSVGFEBlendElementIn1, (intptr_t)0 },
    { "in2", DontDelete|ReadOnly, (intptr_t)jsSVGFEBlendElementIn2, (intptr_t)0 },
    { "mode", DontDelete|ReadOnly, (intptr_t)jsSVGFEBlendElementMode, (intptr_t)0 },
    { "x", DontDelete|ReadOnly, (intptr_t)jsSVGFEBlendElementX, (intptr_t)0 },
    { "y", DontDelete|ReadOnly, (intptr_t)jsSVGFEBlendElementY, (intptr_t)0 },
    { "width", DontDelete|ReadOnly, (intptr_t)jsSVGFEBlendElementWidth, (intptr_t)0 },
    { "height", DontDelete|ReadOnly, (intptr_t)jsSVGFEBlendElementHeight, (intptr_t)0 },
    { "result", DontDelete|ReadOnly, (intptr_t)jsSVGFEBlendElementResult, (intptr_t)0 },
    { "className", DontDelete|ReadOnly, (intptr_t)jsSVGFEBlendElementClassName, (intptr_t)0 },
    { "style", DontDelete|ReadOnly, (intptr_t)jsSVGFEBlendElementStyle, (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsSVGFEBlendElementConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGFEBlendElementTable = { 255, JSSVGFEBlendElementTableValues, 0 };

/* Hash table for constructor */

static const HashTableValue JSSVGFEBlendElementConstructorTableValues[7] =
{
    { "SVG_FEBLEND_MODE_UNKNOWN", DontDelete|ReadOnly, (intptr_t)jsSVGFEBlendElementSVG_FEBLEND_MODE_UNKNOWN, (intptr_t)0 },
    { "SVG_FEBLEND_MODE_NORMAL", DontDelete|ReadOnly, (intptr_t)jsSVGFEBlendElementSVG_FEBLEND_MODE_NORMAL, (intptr_t)0 },
    { "SVG_FEBLEND_MODE_MULTIPLY", DontDelete|ReadOnly, (intptr_t)jsSVGFEBlendElementSVG_FEBLEND_MODE_MULTIPLY, (intptr_t)0 },
    { "SVG_FEBLEND_MODE_SCREEN", DontDelete|ReadOnly, (intptr_t)jsSVGFEBlendElementSVG_FEBLEND_MODE_SCREEN, (intptr_t)0 },
    { "SVG_FEBLEND_MODE_DARKEN", DontDelete|ReadOnly, (intptr_t)jsSVGFEBlendElementSVG_FEBLEND_MODE_DARKEN, (intptr_t)0 },
    { "SVG_FEBLEND_MODE_LIGHTEN", DontDelete|ReadOnly, (intptr_t)jsSVGFEBlendElementSVG_FEBLEND_MODE_LIGHTEN, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGFEBlendElementConstructorTable = { 15, JSSVGFEBlendElementConstructorTableValues, 0 };

class JSSVGFEBlendElementConstructor : public DOMObject {
public:
    JSSVGFEBlendElementConstructor(ExecState* exec)
        : DOMObject(JSSVGFEBlendElementConstructor::createStructureID(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSSVGFEBlendElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<StructureID> createStructureID(JSValue* proto) 
    { 
        return StructureID::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSSVGFEBlendElementConstructor::s_info = { "SVGFEBlendElementConstructor", 0, &JSSVGFEBlendElementConstructorTable, 0 };

bool JSSVGFEBlendElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGFEBlendElementConstructor, DOMObject>(exec, &JSSVGFEBlendElementConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSSVGFEBlendElementPrototypeTableValues[8] =
{
    { "SVG_FEBLEND_MODE_UNKNOWN", DontDelete|ReadOnly, (intptr_t)jsSVGFEBlendElementSVG_FEBLEND_MODE_UNKNOWN, (intptr_t)0 },
    { "SVG_FEBLEND_MODE_NORMAL", DontDelete|ReadOnly, (intptr_t)jsSVGFEBlendElementSVG_FEBLEND_MODE_NORMAL, (intptr_t)0 },
    { "SVG_FEBLEND_MODE_MULTIPLY", DontDelete|ReadOnly, (intptr_t)jsSVGFEBlendElementSVG_FEBLEND_MODE_MULTIPLY, (intptr_t)0 },
    { "SVG_FEBLEND_MODE_SCREEN", DontDelete|ReadOnly, (intptr_t)jsSVGFEBlendElementSVG_FEBLEND_MODE_SCREEN, (intptr_t)0 },
    { "SVG_FEBLEND_MODE_DARKEN", DontDelete|ReadOnly, (intptr_t)jsSVGFEBlendElementSVG_FEBLEND_MODE_DARKEN, (intptr_t)0 },
    { "SVG_FEBLEND_MODE_LIGHTEN", DontDelete|ReadOnly, (intptr_t)jsSVGFEBlendElementSVG_FEBLEND_MODE_LIGHTEN, (intptr_t)0 },
    { "getPresentationAttribute", DontDelete|Function, (intptr_t)jsSVGFEBlendElementPrototypeFunctionGetPresentationAttribute, (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGFEBlendElementPrototypeTable = { 15, JSSVGFEBlendElementPrototypeTableValues, 0 };

const ClassInfo JSSVGFEBlendElementPrototype::s_info = { "SVGFEBlendElementPrototype", 0, &JSSVGFEBlendElementPrototypeTable, 0 };

JSObject* JSSVGFEBlendElementPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSSVGFEBlendElement>(exec);
}

bool JSSVGFEBlendElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticPropertySlot<JSSVGFEBlendElementPrototype, JSObject>(exec, &JSSVGFEBlendElementPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSSVGFEBlendElement::s_info = { "SVGFEBlendElement", &JSSVGElement::s_info, &JSSVGFEBlendElementTable , 0 };

JSSVGFEBlendElement::JSSVGFEBlendElement(PassRefPtr<StructureID> structure, PassRefPtr<SVGFEBlendElement> impl)
    : JSSVGElement(structure, impl)
{
}

JSObject* JSSVGFEBlendElement::createPrototype(ExecState* exec)
{
    return new (exec) JSSVGFEBlendElementPrototype(JSSVGFEBlendElementPrototype::createStructureID(JSSVGElementPrototype::self(exec)));
}

bool JSSVGFEBlendElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGFEBlendElement, Base>(exec, &JSSVGFEBlendElementTable, this, propertyName, slot);
}

JSValue* jsSVGFEBlendElementIn1(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGFEBlendElement* imp = static_cast<SVGFEBlendElement*>(static_cast<JSSVGFEBlendElement*>(slot.slotBase())->impl());
    RefPtr<SVGAnimatedString> obj = imp->in1Animated();
    return toJS(exec, obj.get(), imp);
}

JSValue* jsSVGFEBlendElementIn2(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGFEBlendElement* imp = static_cast<SVGFEBlendElement*>(static_cast<JSSVGFEBlendElement*>(slot.slotBase())->impl());
    RefPtr<SVGAnimatedString> obj = imp->in2Animated();
    return toJS(exec, obj.get(), imp);
}

JSValue* jsSVGFEBlendElementMode(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGFEBlendElement* imp = static_cast<SVGFEBlendElement*>(static_cast<JSSVGFEBlendElement*>(slot.slotBase())->impl());
    RefPtr<SVGAnimatedEnumeration> obj = imp->modeAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValue* jsSVGFEBlendElementX(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGFEBlendElement* imp = static_cast<SVGFEBlendElement*>(static_cast<JSSVGFEBlendElement*>(slot.slotBase())->impl());
    RefPtr<SVGAnimatedLength> obj = imp->xAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValue* jsSVGFEBlendElementY(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGFEBlendElement* imp = static_cast<SVGFEBlendElement*>(static_cast<JSSVGFEBlendElement*>(slot.slotBase())->impl());
    RefPtr<SVGAnimatedLength> obj = imp->yAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValue* jsSVGFEBlendElementWidth(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGFEBlendElement* imp = static_cast<SVGFEBlendElement*>(static_cast<JSSVGFEBlendElement*>(slot.slotBase())->impl());
    RefPtr<SVGAnimatedLength> obj = imp->widthAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValue* jsSVGFEBlendElementHeight(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGFEBlendElement* imp = static_cast<SVGFEBlendElement*>(static_cast<JSSVGFEBlendElement*>(slot.slotBase())->impl());
    RefPtr<SVGAnimatedLength> obj = imp->heightAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValue* jsSVGFEBlendElementResult(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGFEBlendElement* imp = static_cast<SVGFEBlendElement*>(static_cast<JSSVGFEBlendElement*>(slot.slotBase())->impl());
    RefPtr<SVGAnimatedString> obj = imp->resultAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValue* jsSVGFEBlendElementClassName(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGFEBlendElement* imp = static_cast<SVGFEBlendElement*>(static_cast<JSSVGFEBlendElement*>(slot.slotBase())->impl());
    RefPtr<SVGAnimatedString> obj = imp->classNameAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValue* jsSVGFEBlendElementStyle(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGFEBlendElement* imp = static_cast<SVGFEBlendElement*>(static_cast<JSSVGFEBlendElement*>(slot.slotBase())->impl());
    return toJS(exec, WTF::getPtr(imp->style()));
}

JSValue* jsSVGFEBlendElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSSVGFEBlendElement*>(slot.slotBase())->getConstructor(exec);
}
JSValue* JSSVGFEBlendElement::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSSVGFEBlendElementConstructor>(exec);
}

JSValue* jsSVGFEBlendElementPrototypeFunctionGetPresentationAttribute(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGFEBlendElement::s_info))
        return throwError(exec, TypeError);
    JSSVGFEBlendElement* castedThisObj = static_cast<JSSVGFEBlendElement*>(thisValue);
    SVGFEBlendElement* imp = static_cast<SVGFEBlendElement*>(castedThisObj->impl());
    const UString& name = args.at(exec, 0)->toString(exec);


    JSC::JSValue* result = toJS(exec, WTF::getPtr(imp->getPresentationAttribute(name)));
    return result;
}

// Constant getters

JSValue* jsSVGFEBlendElementSVG_FEBLEND_MODE_UNKNOWN(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(0));
}

JSValue* jsSVGFEBlendElementSVG_FEBLEND_MODE_NORMAL(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(1));
}

JSValue* jsSVGFEBlendElementSVG_FEBLEND_MODE_MULTIPLY(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(2));
}

JSValue* jsSVGFEBlendElementSVG_FEBLEND_MODE_SCREEN(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(3));
}

JSValue* jsSVGFEBlendElementSVG_FEBLEND_MODE_DARKEN(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(4));
}

JSValue* jsSVGFEBlendElementSVG_FEBLEND_MODE_LIGHTEN(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(5));
}


}

#endif // ENABLE(SVG) && ENABLE(SVG_FILTERS)
