/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(SVG)

#include "SVGElement.h"
#include "JSSVGElementInstance.h"

#include <wtf/GetPtr.h>

#include "EventTargetSVGElementInstance.h"
#include "JSEventTargetSVGElementInstance.h"
#include "JSSVGElement.h"
#include "JSSVGElementInstanceList.h"
#include "JSSVGUseElement.h"
#include "SVGElement.h"
#include "SVGElementInstance.h"
#include "SVGElementInstanceList.h"
#include "SVGUseElement.h"


using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGElementInstance)

/* Hash table */

static const HashTableValue JSSVGElementInstanceTableValues[9] =
{
    { "correspondingElement", DontDelete|ReadOnly, (intptr_t)jsSVGElementInstanceCorrespondingElement, (intptr_t)0 },
    { "correspondingUseElement", DontDelete|ReadOnly, (intptr_t)jsSVGElementInstanceCorrespondingUseElement, (intptr_t)0 },
    { "parentNode", DontDelete|ReadOnly, (intptr_t)jsSVGElementInstanceParentNode, (intptr_t)0 },
    { "childNodes", DontDelete|ReadOnly, (intptr_t)jsSVGElementInstanceChildNodes, (intptr_t)0 },
    { "firstChild", DontDelete|ReadOnly, (intptr_t)jsSVGElementInstanceFirstChild, (intptr_t)0 },
    { "lastChild", DontDelete|ReadOnly, (intptr_t)jsSVGElementInstanceLastChild, (intptr_t)0 },
    { "previousSibling", DontDelete|ReadOnly, (intptr_t)jsSVGElementInstancePreviousSibling, (intptr_t)0 },
    { "nextSibling", DontDelete|ReadOnly, (intptr_t)jsSVGElementInstanceNextSibling, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGElementInstanceTable = { 255, JSSVGElementInstanceTableValues, 0 };

/* Hash table for prototype */

static const HashTableValue JSSVGElementInstancePrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGElementInstancePrototypeTable = { 0, JSSVGElementInstancePrototypeTableValues, 0 };

const ClassInfo JSSVGElementInstancePrototype::s_info = { "SVGElementInstancePrototype", 0, &JSSVGElementInstancePrototypeTable, 0 };

JSObject* JSSVGElementInstancePrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSSVGElementInstance>(exec);
}

const ClassInfo JSSVGElementInstance::s_info = { "SVGElementInstance", 0, &JSSVGElementInstanceTable , 0 };

JSSVGElementInstance::JSSVGElementInstance(PassRefPtr<StructureID> structure, PassRefPtr<SVGElementInstance> impl)
    : DOMObject(structure)
    , m_impl(impl)
{
}

JSSVGElementInstance::~JSSVGElementInstance()
{
    forgetDOMObject(*Heap::heap(this)->globalData(), m_impl.get());

}

JSObject* JSSVGElementInstance::createPrototype(ExecState* exec)
{
    return new (exec) JSSVGElementInstancePrototype(JSSVGElementInstancePrototype::createStructureID(exec->lexicalGlobalObject()->objectPrototype()));
}

bool JSSVGElementInstance::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGElementInstance, Base>(exec, &JSSVGElementInstanceTable, this, propertyName, slot);
}

JSValue* jsSVGElementInstanceCorrespondingElement(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(slot.slotBase())->impl());
    return toJS(exec, WTF::getPtr(imp->correspondingElement()));
}

JSValue* jsSVGElementInstanceCorrespondingUseElement(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(slot.slotBase())->impl());
    return toJS(exec, WTF::getPtr(imp->correspondingUseElement()));
}

JSValue* jsSVGElementInstanceParentNode(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(slot.slotBase())->impl());
    return toJS(exec, WTF::getPtr(imp->parentNode()));
}

JSValue* jsSVGElementInstanceChildNodes(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(slot.slotBase())->impl());
    return toJS(exec, WTF::getPtr(imp->childNodes()));
}

JSValue* jsSVGElementInstanceFirstChild(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(slot.slotBase())->impl());
    return toJS(exec, WTF::getPtr(imp->firstChild()));
}

JSValue* jsSVGElementInstanceLastChild(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(slot.slotBase())->impl());
    return toJS(exec, WTF::getPtr(imp->lastChild()));
}

JSValue* jsSVGElementInstancePreviousSibling(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(slot.slotBase())->impl());
    return toJS(exec, WTF::getPtr(imp->previousSibling()));
}

JSValue* jsSVGElementInstanceNextSibling(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(slot.slotBase())->impl());
    return toJS(exec, WTF::getPtr(imp->nextSibling()));
}

SVGElementInstance* toSVGElementInstance(JSC::JSValue* val)
{
    return val->isObject(&JSSVGElementInstance::s_info) ? static_cast<JSSVGElementInstance*>(val)->impl() : 0;
}

}

#endif // ENABLE(SVG)
