/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(SVG)

#include "SVGElement.h"
#include "JSSVGAnimatedBoolean.h"

#include <wtf/GetPtr.h>



using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGAnimatedBoolean)

/* Hash table */

static const HashTableValue JSSVGAnimatedBooleanTableValues[3] =
{
    { "baseVal", DontDelete, (intptr_t)jsSVGAnimatedBooleanBaseVal, (intptr_t)setJSSVGAnimatedBooleanBaseVal },
    { "animVal", DontDelete|ReadOnly, (intptr_t)jsSVGAnimatedBooleanAnimVal, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGAnimatedBooleanTable = { 1, JSSVGAnimatedBooleanTableValues, 0 };

/* Hash table for prototype */

static const HashTableValue JSSVGAnimatedBooleanPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGAnimatedBooleanPrototypeTable = { 0, JSSVGAnimatedBooleanPrototypeTableValues, 0 };

const ClassInfo JSSVGAnimatedBooleanPrototype::s_info = { "SVGAnimatedBooleanPrototype", 0, &JSSVGAnimatedBooleanPrototypeTable, 0 };

JSObject* JSSVGAnimatedBooleanPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSSVGAnimatedBoolean>(exec);
}

const ClassInfo JSSVGAnimatedBoolean::s_info = { "SVGAnimatedBoolean", 0, &JSSVGAnimatedBooleanTable , 0 };

JSSVGAnimatedBoolean::JSSVGAnimatedBoolean(PassRefPtr<StructureID> structure, PassRefPtr<SVGAnimatedBoolean> impl, SVGElement* context)
    : DOMObject(structure)
    , m_context(context)
    , m_impl(impl)
{
}

JSSVGAnimatedBoolean::~JSSVGAnimatedBoolean()
{
    forgetDOMObject(*Heap::heap(this)->globalData(), m_impl.get());

}

JSObject* JSSVGAnimatedBoolean::createPrototype(ExecState* exec)
{
    return new (exec) JSSVGAnimatedBooleanPrototype(JSSVGAnimatedBooleanPrototype::createStructureID(exec->lexicalGlobalObject()->objectPrototype()));
}

bool JSSVGAnimatedBoolean::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGAnimatedBoolean, Base>(exec, &JSSVGAnimatedBooleanTable, this, propertyName, slot);
}

JSValue* jsSVGAnimatedBooleanBaseVal(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGAnimatedBoolean* imp = static_cast<SVGAnimatedBoolean*>(static_cast<JSSVGAnimatedBoolean*>(slot.slotBase())->impl());
    return jsBoolean(imp->baseVal());
}

JSValue* jsSVGAnimatedBooleanAnimVal(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGAnimatedBoolean* imp = static_cast<SVGAnimatedBoolean*>(static_cast<JSSVGAnimatedBoolean*>(slot.slotBase())->impl());
    return jsBoolean(imp->animVal());
}

void JSSVGAnimatedBoolean::put(ExecState* exec, const Identifier& propertyName, JSValue* value, PutPropertySlot& slot)
{
    lookupPut<JSSVGAnimatedBoolean, Base>(exec, propertyName, value, &JSSVGAnimatedBooleanTable, this, slot);
}

void setJSSVGAnimatedBooleanBaseVal(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    SVGAnimatedBoolean* imp = static_cast<SVGAnimatedBoolean*>(static_cast<JSSVGAnimatedBoolean*>(thisObject)->impl());
    imp->setBaseVal(value->toBoolean(exec));
    if (static_cast<JSSVGAnimatedBoolean*>(thisObject)->context())
        static_cast<JSSVGAnimatedBoolean*>(thisObject)->context()->svgAttributeChanged(static_cast<JSSVGAnimatedBoolean*>(thisObject)->impl()->associatedAttributeName());
}

JSC::JSValue* toJS(JSC::ExecState* exec, SVGAnimatedBoolean* object, SVGElement* context)
{
    return getDOMObjectWrapper<JSSVGAnimatedBoolean>(exec, object, context);
}
SVGAnimatedBoolean* toSVGAnimatedBoolean(JSC::JSValue* val)
{
    return val->isObject(&JSSVGAnimatedBoolean::s_info) ? static_cast<JSSVGAnimatedBoolean*>(val)->impl() : 0;
}

}

#endif // ENABLE(SVG)
