/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSSQLResultSet.h"

#include <wtf/GetPtr.h>

#include "JSSQLResultSetRowList.h"
#include "SQLResultSet.h"
#include "SQLResultSetRowList.h"

#include <kjs/JSNumberCell.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSQLResultSet)

/* Hash table */

static const HashTableValue JSSQLResultSetTableValues[4] =
{
    { "rows", DontDelete|ReadOnly, (intptr_t)jsSQLResultSetRows, (intptr_t)0 },
    { "insertId", DontDelete|ReadOnly, (intptr_t)jsSQLResultSetInsertId, (intptr_t)0 },
    { "rowsAffected", DontDelete|ReadOnly, (intptr_t)jsSQLResultSetRowsAffected, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSSQLResultSetTable = { 255, JSSQLResultSetTableValues, 0 };

/* Hash table for prototype */

static const HashTableValue JSSQLResultSetPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSSQLResultSetPrototypeTable = { 0, JSSQLResultSetPrototypeTableValues, 0 };

const ClassInfo JSSQLResultSetPrototype::s_info = { "SQLResultSetPrototype", 0, &JSSQLResultSetPrototypeTable, 0 };

JSObject* JSSQLResultSetPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSSQLResultSet>(exec);
}

const ClassInfo JSSQLResultSet::s_info = { "SQLResultSet", 0, &JSSQLResultSetTable , 0 };

JSSQLResultSet::JSSQLResultSet(PassRefPtr<StructureID> structure, PassRefPtr<SQLResultSet> impl)
    : DOMObject(structure)
    , m_impl(impl)
{
}

JSSQLResultSet::~JSSQLResultSet()
{
    forgetDOMObject(*Heap::heap(this)->globalData(), m_impl.get());

}

JSObject* JSSQLResultSet::createPrototype(ExecState* exec)
{
    return new (exec) JSSQLResultSetPrototype(JSSQLResultSetPrototype::createStructureID(exec->lexicalGlobalObject()->objectPrototype()));
}

bool JSSQLResultSet::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSQLResultSet, Base>(exec, &JSSQLResultSetTable, this, propertyName, slot);
}

JSValue* jsSQLResultSetRows(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SQLResultSet* imp = static_cast<SQLResultSet*>(static_cast<JSSQLResultSet*>(slot.slotBase())->impl());
    return toJS(exec, WTF::getPtr(imp->rows()));
}

JSValue* jsSQLResultSetInsertId(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    ExceptionCode ec = 0;
    SQLResultSet* imp = static_cast<SQLResultSet*>(static_cast<JSSQLResultSet*>(slot.slotBase())->impl());
    JSC::JSValue* result = jsNumber(exec, imp->insertId(ec));
    setDOMException(exec, ec);
    return result;
}

JSValue* jsSQLResultSetRowsAffected(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SQLResultSet* imp = static_cast<SQLResultSet*>(static_cast<JSSQLResultSet*>(slot.slotBase())->impl());
    return jsNumber(exec, imp->rowsAffected());
}

JSC::JSValue* toJS(JSC::ExecState* exec, SQLResultSet* object)
{
    return getDOMObjectWrapper<JSSQLResultSet>(exec, object);
}
SQLResultSet* toSQLResultSet(JSC::JSValue* val)
{
    return val->isObject(&JSSQLResultSet::s_info) ? static_cast<JSSQLResultSet*>(val)->impl() : 0;
}

}
