/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSNavigator.h"

#include <wtf/GetPtr.h>

#include "JSMimeTypeArray.h"
#include "JSPluginArray.h"
#include "KURL.h"
#include "MimeTypeArray.h"
#include "Navigator.h"
#include "PluginArray.h"

#include <kjs/Error.h>
#include <kjs/JSString.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSNavigator)

/* Hash table */

static const HashTableValue JSNavigatorTableValues[15] =
{
    { "appCodeName", DontDelete|ReadOnly, (intptr_t)jsNavigatorAppCodeName, (intptr_t)0 },
    { "appName", DontDelete|ReadOnly, (intptr_t)jsNavigatorAppName, (intptr_t)0 },
    { "appVersion", DontDelete|ReadOnly, (intptr_t)jsNavigatorAppVersion, (intptr_t)0 },
    { "language", DontDelete|ReadOnly, (intptr_t)jsNavigatorLanguage, (intptr_t)0 },
    { "userAgent", DontDelete|ReadOnly, (intptr_t)jsNavigatorUserAgent, (intptr_t)0 },
    { "platform", DontDelete|ReadOnly, (intptr_t)jsNavigatorPlatform, (intptr_t)0 },
    { "plugins", DontDelete|ReadOnly, (intptr_t)jsNavigatorPlugins, (intptr_t)0 },
    { "mimeTypes", DontDelete|ReadOnly, (intptr_t)jsNavigatorMimeTypes, (intptr_t)0 },
    { "product", DontDelete|ReadOnly, (intptr_t)jsNavigatorProduct, (intptr_t)0 },
    { "productSub", DontDelete|ReadOnly, (intptr_t)jsNavigatorProductSub, (intptr_t)0 },
    { "vendor", DontDelete|ReadOnly, (intptr_t)jsNavigatorVendor, (intptr_t)0 },
    { "vendorSub", DontDelete|ReadOnly, (intptr_t)jsNavigatorVendorSub, (intptr_t)0 },
    { "cookieEnabled", DontDelete|ReadOnly, (intptr_t)jsNavigatorCookieEnabled, (intptr_t)0 },
    { "onLine", DontDelete|ReadOnly, (intptr_t)jsNavigatorOnLine, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSNavigatorTable = { 511, JSNavigatorTableValues, 0 };

/* Hash table for prototype */

static const HashTableValue JSNavigatorPrototypeTableValues[2] =
{
    { "javaEnabled", DontDelete|Function, (intptr_t)jsNavigatorPrototypeFunctionJavaEnabled, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSNavigatorPrototypeTable = { 0, JSNavigatorPrototypeTableValues, 0 };

const ClassInfo JSNavigatorPrototype::s_info = { "NavigatorPrototype", 0, &JSNavigatorPrototypeTable, 0 };

JSObject* JSNavigatorPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSNavigator>(exec);
}

bool JSNavigatorPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSNavigatorPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSNavigator::s_info = { "Navigator", 0, &JSNavigatorTable , 0 };

JSNavigator::JSNavigator(PassRefPtr<StructureID> structure, PassRefPtr<Navigator> impl)
    : DOMObject(structure)
    , m_impl(impl)
{
}

JSNavigator::~JSNavigator()
{
    forgetDOMObject(*Heap::heap(this)->globalData(), m_impl.get());

}

JSObject* JSNavigator::createPrototype(ExecState* exec)
{
    return new (exec) JSNavigatorPrototype(JSNavigatorPrototype::createStructureID(exec->lexicalGlobalObject()->objectPrototype()));
}

bool JSNavigator::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSNavigator, Base>(exec, &JSNavigatorTable, this, propertyName, slot);
}

JSValue* jsNavigatorAppCodeName(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    Navigator* imp = static_cast<Navigator*>(static_cast<JSNavigator*>(slot.slotBase())->impl());
    return jsString(exec, imp->appCodeName());
}

JSValue* jsNavigatorAppName(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    Navigator* imp = static_cast<Navigator*>(static_cast<JSNavigator*>(slot.slotBase())->impl());
    return jsString(exec, imp->appName());
}

JSValue* jsNavigatorAppVersion(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSNavigator*>(slot.slotBase())->appVersion(exec);
}

JSValue* jsNavigatorLanguage(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    Navigator* imp = static_cast<Navigator*>(static_cast<JSNavigator*>(slot.slotBase())->impl());
    return jsString(exec, imp->language());
}

JSValue* jsNavigatorUserAgent(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    Navigator* imp = static_cast<Navigator*>(static_cast<JSNavigator*>(slot.slotBase())->impl());
    return jsString(exec, imp->userAgent());
}

JSValue* jsNavigatorPlatform(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    Navigator* imp = static_cast<Navigator*>(static_cast<JSNavigator*>(slot.slotBase())->impl());
    return jsString(exec, imp->platform());
}

JSValue* jsNavigatorPlugins(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    Navigator* imp = static_cast<Navigator*>(static_cast<JSNavigator*>(slot.slotBase())->impl());
    return toJS(exec, WTF::getPtr(imp->plugins()));
}

JSValue* jsNavigatorMimeTypes(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    Navigator* imp = static_cast<Navigator*>(static_cast<JSNavigator*>(slot.slotBase())->impl());
    return toJS(exec, WTF::getPtr(imp->mimeTypes()));
}

JSValue* jsNavigatorProduct(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    Navigator* imp = static_cast<Navigator*>(static_cast<JSNavigator*>(slot.slotBase())->impl());
    return jsString(exec, imp->product());
}

JSValue* jsNavigatorProductSub(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    Navigator* imp = static_cast<Navigator*>(static_cast<JSNavigator*>(slot.slotBase())->impl());
    return jsString(exec, imp->productSub());
}

JSValue* jsNavigatorVendor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    Navigator* imp = static_cast<Navigator*>(static_cast<JSNavigator*>(slot.slotBase())->impl());
    return jsString(exec, imp->vendor());
}

JSValue* jsNavigatorVendorSub(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    Navigator* imp = static_cast<Navigator*>(static_cast<JSNavigator*>(slot.slotBase())->impl());
    return jsString(exec, imp->vendorSub());
}

JSValue* jsNavigatorCookieEnabled(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    Navigator* imp = static_cast<Navigator*>(static_cast<JSNavigator*>(slot.slotBase())->impl());
    return jsBoolean(imp->cookieEnabled());
}

JSValue* jsNavigatorOnLine(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    Navigator* imp = static_cast<Navigator*>(static_cast<JSNavigator*>(slot.slotBase())->impl());
    return jsBoolean(imp->onLine());
}

JSValue* jsNavigatorPrototypeFunctionJavaEnabled(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSNavigator::s_info))
        return throwError(exec, TypeError);
    JSNavigator* castedThisObj = static_cast<JSNavigator*>(thisValue);
    Navigator* imp = static_cast<Navigator*>(castedThisObj->impl());


    JSC::JSValue* result = jsBoolean(imp->javaEnabled());
    return result;
}

JSC::JSValue* toJS(JSC::ExecState* exec, Navigator* object)
{
    return getDOMObjectWrapper<JSNavigator>(exec, object);
}
Navigator* toNavigator(JSC::JSValue* val)
{
    return val->isObject(&JSNavigator::s_info) ? static_cast<JSNavigator*>(val)->impl() : 0;
}

}
