/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSMessageChannel.h"

#include <wtf/GetPtr.h>

#include "JSMessagePort.h"
#include "MessageChannel.h"
#include "MessagePort.h"


using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSMessageChannel)

/* Hash table */

static const HashTableValue JSMessageChannelTableValues[3] =
{
    { "port1", DontDelete|ReadOnly, (intptr_t)jsMessageChannelPort1, (intptr_t)0 },
    { "port2", DontDelete|ReadOnly, (intptr_t)jsMessageChannelPort2, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSMessageChannelTable = { 3, JSMessageChannelTableValues, 0 };

/* Hash table for prototype */

static const HashTableValue JSMessageChannelPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSMessageChannelPrototypeTable = { 0, JSMessageChannelPrototypeTableValues, 0 };

const ClassInfo JSMessageChannelPrototype::s_info = { "MessageChannelPrototype", 0, &JSMessageChannelPrototypeTable, 0 };

JSObject* JSMessageChannelPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSMessageChannel>(exec);
}

const ClassInfo JSMessageChannel::s_info = { "MessageChannel", 0, &JSMessageChannelTable , 0 };

JSMessageChannel::JSMessageChannel(PassRefPtr<StructureID> structure, PassRefPtr<MessageChannel> impl)
    : DOMObject(structure)
    , m_impl(impl)
{
}

JSMessageChannel::~JSMessageChannel()
{
    forgetDOMObject(*Heap::heap(this)->globalData(), m_impl.get());

}

JSObject* JSMessageChannel::createPrototype(ExecState* exec)
{
    return new (exec) JSMessageChannelPrototype(JSMessageChannelPrototype::createStructureID(exec->lexicalGlobalObject()->objectPrototype()));
}

bool JSMessageChannel::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSMessageChannel, Base>(exec, &JSMessageChannelTable, this, propertyName, slot);
}

JSValue* jsMessageChannelPort1(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    MessageChannel* imp = static_cast<MessageChannel*>(static_cast<JSMessageChannel*>(slot.slotBase())->impl());
    return toJS(exec, WTF::getPtr(imp->port1()));
}

JSValue* jsMessageChannelPort2(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    MessageChannel* imp = static_cast<MessageChannel*>(static_cast<JSMessageChannel*>(slot.slotBase())->impl());
    return toJS(exec, WTF::getPtr(imp->port2()));
}

JSC::JSValue* toJS(JSC::ExecState* exec, MessageChannel* object)
{
    return getDOMObjectWrapper<JSMessageChannel>(exec, object);
}
MessageChannel* toMessageChannel(JSC::JSValue* val)
{
    return val->isObject(&JSMessageChannel::s_info) ? static_cast<JSMessageChannel*>(val)->impl() : 0;
}

}
