/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSImageData.h"

#include <wtf/GetPtr.h>

#include "CanvasPixelArray.h"
#include "ImageData.h"
#include "JSCanvasPixelArray.h"

#include <kjs/JSNumberCell.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSImageData)

/* Hash table */

static const HashTableValue JSImageDataTableValues[5] =
{
    { "width", DontDelete|ReadOnly, (intptr_t)jsImageDataWidth, (intptr_t)0 },
    { "height", DontDelete|ReadOnly, (intptr_t)jsImageDataHeight, (intptr_t)0 },
    { "data", DontDelete|ReadOnly, (intptr_t)jsImageDataData, (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsImageDataConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSImageDataTable = { 31, JSImageDataTableValues, 0 };

/* Hash table for constructor */

static const HashTableValue JSImageDataConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSImageDataConstructorTable = { 0, JSImageDataConstructorTableValues, 0 };

class JSImageDataConstructor : public DOMObject {
public:
    JSImageDataConstructor(ExecState* exec)
        : DOMObject(JSImageDataConstructor::createStructureID(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSImageDataPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<StructureID> createStructureID(JSValue* proto) 
    { 
        return StructureID::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSImageDataConstructor::s_info = { "ImageDataConstructor", 0, &JSImageDataConstructorTable, 0 };

bool JSImageDataConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSImageDataConstructor, DOMObject>(exec, &JSImageDataConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSImageDataPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSImageDataPrototypeTable = { 0, JSImageDataPrototypeTableValues, 0 };

const ClassInfo JSImageDataPrototype::s_info = { "ImageDataPrototype", 0, &JSImageDataPrototypeTable, 0 };

JSObject* JSImageDataPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSImageData>(exec);
}

const ClassInfo JSImageData::s_info = { "ImageData", 0, &JSImageDataTable , 0 };

JSImageData::JSImageData(PassRefPtr<StructureID> structure, PassRefPtr<ImageData> impl)
    : DOMObject(structure)
    , m_impl(impl)
{
}

JSImageData::~JSImageData()
{
    forgetDOMObject(*Heap::heap(this)->globalData(), m_impl.get());

}

JSObject* JSImageData::createPrototype(ExecState* exec)
{
    return new (exec) JSImageDataPrototype(JSImageDataPrototype::createStructureID(exec->lexicalGlobalObject()->objectPrototype()));
}

bool JSImageData::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSImageData, Base>(exec, &JSImageDataTable, this, propertyName, slot);
}

JSValue* jsImageDataWidth(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    ImageData* imp = static_cast<ImageData*>(static_cast<JSImageData*>(slot.slotBase())->impl());
    return jsNumber(exec, imp->width());
}

JSValue* jsImageDataHeight(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    ImageData* imp = static_cast<ImageData*>(static_cast<JSImageData*>(slot.slotBase())->impl());
    return jsNumber(exec, imp->height());
}

JSValue* jsImageDataData(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    ImageData* imp = static_cast<ImageData*>(static_cast<JSImageData*>(slot.slotBase())->impl());
    return toJS(exec, WTF::getPtr(imp->data()));
}

JSValue* jsImageDataConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSImageData*>(slot.slotBase())->getConstructor(exec);
}
JSValue* JSImageData::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSImageDataConstructor>(exec);
}

ImageData* toImageData(JSC::JSValue* val)
{
    return val->isObject(&JSImageData::s_info) ? static_cast<JSImageData*>(val)->impl() : 0;
}

}
