/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSHTMLTableCellElement.h"

#include <wtf/GetPtr.h>

#include "HTMLTableCellElement.h"
#include "KURL.h"

#include <kjs/JSNumberCell.h>
#include <kjs/JSString.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHTMLTableCellElement)

/* Hash table */

static const HashTableValue JSHTMLTableCellElementTableValues[17] =
{
    { "cellIndex", DontDelete|ReadOnly, (intptr_t)jsHTMLTableCellElementCellIndex, (intptr_t)0 },
    { "abbr", DontDelete, (intptr_t)jsHTMLTableCellElementAbbr, (intptr_t)setJSHTMLTableCellElementAbbr },
    { "align", DontDelete, (intptr_t)jsHTMLTableCellElementAlign, (intptr_t)setJSHTMLTableCellElementAlign },
    { "axis", DontDelete, (intptr_t)jsHTMLTableCellElementAxis, (intptr_t)setJSHTMLTableCellElementAxis },
    { "bgColor", DontDelete, (intptr_t)jsHTMLTableCellElementBgColor, (intptr_t)setJSHTMLTableCellElementBgColor },
    { "ch", DontDelete, (intptr_t)jsHTMLTableCellElementCh, (intptr_t)setJSHTMLTableCellElementCh },
    { "chOff", DontDelete, (intptr_t)jsHTMLTableCellElementChOff, (intptr_t)setJSHTMLTableCellElementChOff },
    { "colSpan", DontDelete, (intptr_t)jsHTMLTableCellElementColSpan, (intptr_t)setJSHTMLTableCellElementColSpan },
    { "headers", DontDelete, (intptr_t)jsHTMLTableCellElementHeaders, (intptr_t)setJSHTMLTableCellElementHeaders },
    { "height", DontDelete, (intptr_t)jsHTMLTableCellElementHeight, (intptr_t)setJSHTMLTableCellElementHeight },
    { "noWrap", DontDelete, (intptr_t)jsHTMLTableCellElementNoWrap, (intptr_t)setJSHTMLTableCellElementNoWrap },
    { "rowSpan", DontDelete, (intptr_t)jsHTMLTableCellElementRowSpan, (intptr_t)setJSHTMLTableCellElementRowSpan },
    { "scope", DontDelete, (intptr_t)jsHTMLTableCellElementScope, (intptr_t)setJSHTMLTableCellElementScope },
    { "vAlign", DontDelete, (intptr_t)jsHTMLTableCellElementVAlign, (intptr_t)setJSHTMLTableCellElementVAlign },
    { "width", DontDelete, (intptr_t)jsHTMLTableCellElementWidth, (intptr_t)setJSHTMLTableCellElementWidth },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsHTMLTableCellElementConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLTableCellElementTable = { 511, JSHTMLTableCellElementTableValues, 0 };

/* Hash table for constructor */

static const HashTableValue JSHTMLTableCellElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLTableCellElementConstructorTable = { 0, JSHTMLTableCellElementConstructorTableValues, 0 };

class JSHTMLTableCellElementConstructor : public DOMObject {
public:
    JSHTMLTableCellElementConstructor(ExecState* exec)
        : DOMObject(JSHTMLTableCellElementConstructor::createStructureID(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSHTMLTableCellElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<StructureID> createStructureID(JSValue* proto) 
    { 
        return StructureID::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSHTMLTableCellElementConstructor::s_info = { "HTMLTableCellElementConstructor", 0, &JSHTMLTableCellElementConstructorTable, 0 };

bool JSHTMLTableCellElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLTableCellElementConstructor, DOMObject>(exec, &JSHTMLTableCellElementConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLTableCellElementPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLTableCellElementPrototypeTable = { 0, JSHTMLTableCellElementPrototypeTableValues, 0 };

const ClassInfo JSHTMLTableCellElementPrototype::s_info = { "HTMLTableCellElementPrototype", 0, &JSHTMLTableCellElementPrototypeTable, 0 };

JSObject* JSHTMLTableCellElementPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSHTMLTableCellElement>(exec);
}

const ClassInfo JSHTMLTableCellElement::s_info = { "HTMLTableCellElement", &JSHTMLElement::s_info, &JSHTMLTableCellElementTable , 0 };

JSHTMLTableCellElement::JSHTMLTableCellElement(PassRefPtr<StructureID> structure, PassRefPtr<HTMLTableCellElement> impl)
    : JSHTMLElement(structure, impl)
{
}

JSObject* JSHTMLTableCellElement::createPrototype(ExecState* exec)
{
    return new (exec) JSHTMLTableCellElementPrototype(JSHTMLTableCellElementPrototype::createStructureID(JSHTMLElementPrototype::self(exec)));
}

bool JSHTMLTableCellElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLTableCellElement, Base>(exec, &JSHTMLTableCellElementTable, this, propertyName, slot);
}

JSValue* jsHTMLTableCellElementCellIndex(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLTableCellElement* imp = static_cast<HTMLTableCellElement*>(static_cast<JSHTMLTableCellElement*>(slot.slotBase())->impl());
    return jsNumber(exec, imp->cellIndex());
}

JSValue* jsHTMLTableCellElementAbbr(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLTableCellElement* imp = static_cast<HTMLTableCellElement*>(static_cast<JSHTMLTableCellElement*>(slot.slotBase())->impl());
    return jsString(exec, imp->abbr());
}

JSValue* jsHTMLTableCellElementAlign(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLTableCellElement* imp = static_cast<HTMLTableCellElement*>(static_cast<JSHTMLTableCellElement*>(slot.slotBase())->impl());
    return jsString(exec, imp->align());
}

JSValue* jsHTMLTableCellElementAxis(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLTableCellElement* imp = static_cast<HTMLTableCellElement*>(static_cast<JSHTMLTableCellElement*>(slot.slotBase())->impl());
    return jsString(exec, imp->axis());
}

JSValue* jsHTMLTableCellElementBgColor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLTableCellElement* imp = static_cast<HTMLTableCellElement*>(static_cast<JSHTMLTableCellElement*>(slot.slotBase())->impl());
    return jsString(exec, imp->bgColor());
}

JSValue* jsHTMLTableCellElementCh(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLTableCellElement* imp = static_cast<HTMLTableCellElement*>(static_cast<JSHTMLTableCellElement*>(slot.slotBase())->impl());
    return jsString(exec, imp->ch());
}

JSValue* jsHTMLTableCellElementChOff(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLTableCellElement* imp = static_cast<HTMLTableCellElement*>(static_cast<JSHTMLTableCellElement*>(slot.slotBase())->impl());
    return jsString(exec, imp->chOff());
}

JSValue* jsHTMLTableCellElementColSpan(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLTableCellElement* imp = static_cast<HTMLTableCellElement*>(static_cast<JSHTMLTableCellElement*>(slot.slotBase())->impl());
    return jsNumber(exec, imp->colSpan());
}

JSValue* jsHTMLTableCellElementHeaders(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLTableCellElement* imp = static_cast<HTMLTableCellElement*>(static_cast<JSHTMLTableCellElement*>(slot.slotBase())->impl());
    return jsString(exec, imp->headers());
}

JSValue* jsHTMLTableCellElementHeight(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLTableCellElement* imp = static_cast<HTMLTableCellElement*>(static_cast<JSHTMLTableCellElement*>(slot.slotBase())->impl());
    return jsString(exec, imp->height());
}

JSValue* jsHTMLTableCellElementNoWrap(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLTableCellElement* imp = static_cast<HTMLTableCellElement*>(static_cast<JSHTMLTableCellElement*>(slot.slotBase())->impl());
    return jsBoolean(imp->noWrap());
}

JSValue* jsHTMLTableCellElementRowSpan(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLTableCellElement* imp = static_cast<HTMLTableCellElement*>(static_cast<JSHTMLTableCellElement*>(slot.slotBase())->impl());
    return jsNumber(exec, imp->rowSpan());
}

JSValue* jsHTMLTableCellElementScope(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLTableCellElement* imp = static_cast<HTMLTableCellElement*>(static_cast<JSHTMLTableCellElement*>(slot.slotBase())->impl());
    return jsString(exec, imp->scope());
}

JSValue* jsHTMLTableCellElementVAlign(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLTableCellElement* imp = static_cast<HTMLTableCellElement*>(static_cast<JSHTMLTableCellElement*>(slot.slotBase())->impl());
    return jsString(exec, imp->vAlign());
}

JSValue* jsHTMLTableCellElementWidth(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLTableCellElement* imp = static_cast<HTMLTableCellElement*>(static_cast<JSHTMLTableCellElement*>(slot.slotBase())->impl());
    return jsString(exec, imp->width());
}

JSValue* jsHTMLTableCellElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSHTMLTableCellElement*>(slot.slotBase())->getConstructor(exec);
}
void JSHTMLTableCellElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value, PutPropertySlot& slot)
{
    lookupPut<JSHTMLTableCellElement, Base>(exec, propertyName, value, &JSHTMLTableCellElementTable, this, slot);
}

void setJSHTMLTableCellElementAbbr(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLTableCellElement* imp = static_cast<HTMLTableCellElement*>(static_cast<JSHTMLTableCellElement*>(thisObject)->impl());
    imp->setAbbr(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLTableCellElementAlign(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLTableCellElement* imp = static_cast<HTMLTableCellElement*>(static_cast<JSHTMLTableCellElement*>(thisObject)->impl());
    imp->setAlign(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLTableCellElementAxis(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLTableCellElement* imp = static_cast<HTMLTableCellElement*>(static_cast<JSHTMLTableCellElement*>(thisObject)->impl());
    imp->setAxis(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLTableCellElementBgColor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLTableCellElement* imp = static_cast<HTMLTableCellElement*>(static_cast<JSHTMLTableCellElement*>(thisObject)->impl());
    imp->setBgColor(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLTableCellElementCh(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLTableCellElement* imp = static_cast<HTMLTableCellElement*>(static_cast<JSHTMLTableCellElement*>(thisObject)->impl());
    imp->setCh(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLTableCellElementChOff(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLTableCellElement* imp = static_cast<HTMLTableCellElement*>(static_cast<JSHTMLTableCellElement*>(thisObject)->impl());
    imp->setChOff(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLTableCellElementColSpan(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLTableCellElement* imp = static_cast<HTMLTableCellElement*>(static_cast<JSHTMLTableCellElement*>(thisObject)->impl());
    imp->setColSpan(value->toInt32(exec));
}

void setJSHTMLTableCellElementHeaders(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLTableCellElement* imp = static_cast<HTMLTableCellElement*>(static_cast<JSHTMLTableCellElement*>(thisObject)->impl());
    imp->setHeaders(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLTableCellElementHeight(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLTableCellElement* imp = static_cast<HTMLTableCellElement*>(static_cast<JSHTMLTableCellElement*>(thisObject)->impl());
    imp->setHeight(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLTableCellElementNoWrap(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLTableCellElement* imp = static_cast<HTMLTableCellElement*>(static_cast<JSHTMLTableCellElement*>(thisObject)->impl());
    imp->setNoWrap(value->toBoolean(exec));
}

void setJSHTMLTableCellElementRowSpan(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLTableCellElement* imp = static_cast<HTMLTableCellElement*>(static_cast<JSHTMLTableCellElement*>(thisObject)->impl());
    imp->setRowSpan(value->toInt32(exec));
}

void setJSHTMLTableCellElementScope(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLTableCellElement* imp = static_cast<HTMLTableCellElement*>(static_cast<JSHTMLTableCellElement*>(thisObject)->impl());
    imp->setScope(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLTableCellElementVAlign(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLTableCellElement* imp = static_cast<HTMLTableCellElement*>(static_cast<JSHTMLTableCellElement*>(thisObject)->impl());
    imp->setVAlign(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLTableCellElementWidth(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLTableCellElement* imp = static_cast<HTMLTableCellElement*>(static_cast<JSHTMLTableCellElement*>(thisObject)->impl());
    imp->setWidth(valueToStringWithNullCheck(exec, value));
}

JSValue* JSHTMLTableCellElement::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSHTMLTableCellElementConstructor>(exec);
}


}
