/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSHTMLQuoteElement.h"

#include <wtf/GetPtr.h>

#include "HTMLQuoteElement.h"
#include "KURL.h"

#include <kjs/JSNumberCell.h>
#include <kjs/JSString.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHTMLQuoteElement)

/* Hash table */

static const HashTableValue JSHTMLQuoteElementTableValues[3] =
{
    { "cite", DontDelete, (intptr_t)jsHTMLQuoteElementCite, (intptr_t)setJSHTMLQuoteElementCite },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsHTMLQuoteElementConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLQuoteElementTable = { 15, JSHTMLQuoteElementTableValues, 0 };

/* Hash table for constructor */

static const HashTableValue JSHTMLQuoteElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLQuoteElementConstructorTable = { 0, JSHTMLQuoteElementConstructorTableValues, 0 };

class JSHTMLQuoteElementConstructor : public DOMObject {
public:
    JSHTMLQuoteElementConstructor(ExecState* exec)
        : DOMObject(JSHTMLQuoteElementConstructor::createStructureID(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSHTMLQuoteElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<StructureID> createStructureID(JSValue* proto) 
    { 
        return StructureID::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSHTMLQuoteElementConstructor::s_info = { "HTMLQuoteElementConstructor", 0, &JSHTMLQuoteElementConstructorTable, 0 };

bool JSHTMLQuoteElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLQuoteElementConstructor, DOMObject>(exec, &JSHTMLQuoteElementConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLQuoteElementPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLQuoteElementPrototypeTable = { 0, JSHTMLQuoteElementPrototypeTableValues, 0 };

const ClassInfo JSHTMLQuoteElementPrototype::s_info = { "HTMLQuoteElementPrototype", 0, &JSHTMLQuoteElementPrototypeTable, 0 };

JSObject* JSHTMLQuoteElementPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSHTMLQuoteElement>(exec);
}

const ClassInfo JSHTMLQuoteElement::s_info = { "HTMLQuoteElement", &JSHTMLElement::s_info, &JSHTMLQuoteElementTable , 0 };

JSHTMLQuoteElement::JSHTMLQuoteElement(PassRefPtr<StructureID> structure, PassRefPtr<HTMLQuoteElement> impl)
    : JSHTMLElement(structure, impl)
{
}

JSObject* JSHTMLQuoteElement::createPrototype(ExecState* exec)
{
    return new (exec) JSHTMLQuoteElementPrototype(JSHTMLQuoteElementPrototype::createStructureID(JSHTMLElementPrototype::self(exec)));
}

bool JSHTMLQuoteElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLQuoteElement, Base>(exec, &JSHTMLQuoteElementTable, this, propertyName, slot);
}

JSValue* jsHTMLQuoteElementCite(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLQuoteElement* imp = static_cast<HTMLQuoteElement*>(static_cast<JSHTMLQuoteElement*>(slot.slotBase())->impl());
    return jsString(exec, imp->cite());
}

JSValue* jsHTMLQuoteElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSHTMLQuoteElement*>(slot.slotBase())->getConstructor(exec);
}
void JSHTMLQuoteElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value, PutPropertySlot& slot)
{
    lookupPut<JSHTMLQuoteElement, Base>(exec, propertyName, value, &JSHTMLQuoteElementTable, this, slot);
}

void setJSHTMLQuoteElementCite(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLQuoteElement* imp = static_cast<HTMLQuoteElement*>(static_cast<JSHTMLQuoteElement*>(thisObject)->impl());
    imp->setCite(valueToStringWithNullCheck(exec, value));
}

JSValue* JSHTMLQuoteElement::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSHTMLQuoteElementConstructor>(exec);
}


}
