/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSHTMLOptionElement.h"

#include <wtf/GetPtr.h>

#include "HTMLFormElement.h"
#include "HTMLOptionElement.h"
#include "JSHTMLFormElement.h"
#include "KURL.h"

#include <kjs/JSNumberCell.h>
#include <kjs/JSString.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHTMLOptionElement)

/* Hash table */

static const HashTableValue JSHTMLOptionElementTableValues[9] =
{
    { "form", DontDelete|ReadOnly, (intptr_t)jsHTMLOptionElementForm, (intptr_t)0 },
    { "defaultSelected", DontDelete, (intptr_t)jsHTMLOptionElementDefaultSelected, (intptr_t)setJSHTMLOptionElementDefaultSelected },
    { "text", DontDelete, (intptr_t)jsHTMLOptionElementText, (intptr_t)setJSHTMLOptionElementText },
    { "index", DontDelete|ReadOnly, (intptr_t)jsHTMLOptionElementIndex, (intptr_t)0 },
    { "disabled", DontDelete, (intptr_t)jsHTMLOptionElementDisabled, (intptr_t)setJSHTMLOptionElementDisabled },
    { "label", DontDelete, (intptr_t)jsHTMLOptionElementLabel, (intptr_t)setJSHTMLOptionElementLabel },
    { "selected", DontDelete, (intptr_t)jsHTMLOptionElementSelected, (intptr_t)setJSHTMLOptionElementSelected },
    { "value", DontDelete, (intptr_t)jsHTMLOptionElementValue, (intptr_t)setJSHTMLOptionElementValue },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLOptionElementTable = { 127, JSHTMLOptionElementTableValues, 0 };

/* Hash table for prototype */

static const HashTableValue JSHTMLOptionElementPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLOptionElementPrototypeTable = { 0, JSHTMLOptionElementPrototypeTableValues, 0 };

const ClassInfo JSHTMLOptionElementPrototype::s_info = { "HTMLOptionElementPrototype", 0, &JSHTMLOptionElementPrototypeTable, 0 };

JSObject* JSHTMLOptionElementPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSHTMLOptionElement>(exec);
}

const ClassInfo JSHTMLOptionElement::s_info = { "HTMLOptionElement", &JSHTMLElement::s_info, &JSHTMLOptionElementTable , 0 };

JSHTMLOptionElement::JSHTMLOptionElement(PassRefPtr<StructureID> structure, PassRefPtr<HTMLOptionElement> impl)
    : JSHTMLElement(structure, impl)
{
}

JSObject* JSHTMLOptionElement::createPrototype(ExecState* exec)
{
    return new (exec) JSHTMLOptionElementPrototype(JSHTMLOptionElementPrototype::createStructureID(JSHTMLElementPrototype::self(exec)));
}

bool JSHTMLOptionElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLOptionElement, Base>(exec, &JSHTMLOptionElementTable, this, propertyName, slot);
}

JSValue* jsHTMLOptionElementForm(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLOptionElement* imp = static_cast<HTMLOptionElement*>(static_cast<JSHTMLOptionElement*>(slot.slotBase())->impl());
    return toJS(exec, WTF::getPtr(imp->form()));
}

JSValue* jsHTMLOptionElementDefaultSelected(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLOptionElement* imp = static_cast<HTMLOptionElement*>(static_cast<JSHTMLOptionElement*>(slot.slotBase())->impl());
    return jsBoolean(imp->defaultSelected());
}

JSValue* jsHTMLOptionElementText(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLOptionElement* imp = static_cast<HTMLOptionElement*>(static_cast<JSHTMLOptionElement*>(slot.slotBase())->impl());
    return jsString(exec, imp->text());
}

JSValue* jsHTMLOptionElementIndex(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLOptionElement* imp = static_cast<HTMLOptionElement*>(static_cast<JSHTMLOptionElement*>(slot.slotBase())->impl());
    return jsNumber(exec, imp->index());
}

JSValue* jsHTMLOptionElementDisabled(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLOptionElement* imp = static_cast<HTMLOptionElement*>(static_cast<JSHTMLOptionElement*>(slot.slotBase())->impl());
    return jsBoolean(imp->disabled());
}

JSValue* jsHTMLOptionElementLabel(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLOptionElement* imp = static_cast<HTMLOptionElement*>(static_cast<JSHTMLOptionElement*>(slot.slotBase())->impl());
    return jsString(exec, imp->label());
}

JSValue* jsHTMLOptionElementSelected(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLOptionElement* imp = static_cast<HTMLOptionElement*>(static_cast<JSHTMLOptionElement*>(slot.slotBase())->impl());
    return jsBoolean(imp->selected());
}

JSValue* jsHTMLOptionElementValue(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLOptionElement* imp = static_cast<HTMLOptionElement*>(static_cast<JSHTMLOptionElement*>(slot.slotBase())->impl());
    return jsString(exec, imp->value());
}

void JSHTMLOptionElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value, PutPropertySlot& slot)
{
    lookupPut<JSHTMLOptionElement, Base>(exec, propertyName, value, &JSHTMLOptionElementTable, this, slot);
}

void setJSHTMLOptionElementDefaultSelected(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLOptionElement* imp = static_cast<HTMLOptionElement*>(static_cast<JSHTMLOptionElement*>(thisObject)->impl());
    imp->setDefaultSelected(value->toBoolean(exec));
}

void setJSHTMLOptionElementText(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLOptionElement* imp = static_cast<HTMLOptionElement*>(static_cast<JSHTMLOptionElement*>(thisObject)->impl());
    ExceptionCode ec = 0;
    imp->setText(valueToStringWithNullCheck(exec, value), ec);
    setDOMException(exec, ec);
}

void setJSHTMLOptionElementDisabled(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLOptionElement* imp = static_cast<HTMLOptionElement*>(static_cast<JSHTMLOptionElement*>(thisObject)->impl());
    imp->setDisabled(value->toBoolean(exec));
}

void setJSHTMLOptionElementLabel(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLOptionElement* imp = static_cast<HTMLOptionElement*>(static_cast<JSHTMLOptionElement*>(thisObject)->impl());
    imp->setLabel(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLOptionElementSelected(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLOptionElement* imp = static_cast<HTMLOptionElement*>(static_cast<JSHTMLOptionElement*>(thisObject)->impl());
    imp->setSelected(value->toBoolean(exec));
}

void setJSHTMLOptionElementValue(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLOptionElement* imp = static_cast<HTMLOptionElement*>(static_cast<JSHTMLOptionElement*>(thisObject)->impl());
    imp->setValue(valueToStringWithNullCheck(exec, value));
}

HTMLOptionElement* toHTMLOptionElement(JSC::JSValue* val)
{
    return val->isObject(&JSHTMLOptionElement::s_info) ? static_cast<JSHTMLOptionElement*>(val)->impl() : 0;
}

}
