/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSHTMLLinkElement.h"

#include <wtf/GetPtr.h>

#include "HTMLLinkElement.h"
#include "JSStyleSheet.h"
#include "KURL.h"
#include "StyleSheet.h"

#include <kjs/JSNumberCell.h>
#include <kjs/JSString.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHTMLLinkElement)

/* Hash table */

static const HashTableValue JSHTMLLinkElementTableValues[12] =
{
    { "disabled", DontDelete, (intptr_t)jsHTMLLinkElementDisabled, (intptr_t)setJSHTMLLinkElementDisabled },
    { "charset", DontDelete, (intptr_t)jsHTMLLinkElementCharset, (intptr_t)setJSHTMLLinkElementCharset },
    { "href", DontDelete, (intptr_t)jsHTMLLinkElementHref, (intptr_t)setJSHTMLLinkElementHref },
    { "hreflang", DontDelete, (intptr_t)jsHTMLLinkElementHreflang, (intptr_t)setJSHTMLLinkElementHreflang },
    { "media", DontDelete, (intptr_t)jsHTMLLinkElementMedia, (intptr_t)setJSHTMLLinkElementMedia },
    { "rel", DontDelete, (intptr_t)jsHTMLLinkElementRel, (intptr_t)setJSHTMLLinkElementRel },
    { "rev", DontDelete, (intptr_t)jsHTMLLinkElementRev, (intptr_t)setJSHTMLLinkElementRev },
    { "target", DontDelete, (intptr_t)jsHTMLLinkElementTarget, (intptr_t)setJSHTMLLinkElementTarget },
    { "type", DontDelete, (intptr_t)jsHTMLLinkElementType, (intptr_t)setJSHTMLLinkElementType },
    { "sheet", DontDelete|ReadOnly, (intptr_t)jsHTMLLinkElementSheet, (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsHTMLLinkElementConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLLinkElementTable = { 63, JSHTMLLinkElementTableValues, 0 };

/* Hash table for constructor */

static const HashTableValue JSHTMLLinkElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLLinkElementConstructorTable = { 0, JSHTMLLinkElementConstructorTableValues, 0 };

class JSHTMLLinkElementConstructor : public DOMObject {
public:
    JSHTMLLinkElementConstructor(ExecState* exec)
        : DOMObject(JSHTMLLinkElementConstructor::createStructureID(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSHTMLLinkElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<StructureID> createStructureID(JSValue* proto) 
    { 
        return StructureID::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSHTMLLinkElementConstructor::s_info = { "HTMLLinkElementConstructor", 0, &JSHTMLLinkElementConstructorTable, 0 };

bool JSHTMLLinkElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLLinkElementConstructor, DOMObject>(exec, &JSHTMLLinkElementConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLLinkElementPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLLinkElementPrototypeTable = { 0, JSHTMLLinkElementPrototypeTableValues, 0 };

const ClassInfo JSHTMLLinkElementPrototype::s_info = { "HTMLLinkElementPrototype", 0, &JSHTMLLinkElementPrototypeTable, 0 };

JSObject* JSHTMLLinkElementPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSHTMLLinkElement>(exec);
}

const ClassInfo JSHTMLLinkElement::s_info = { "HTMLLinkElement", &JSHTMLElement::s_info, &JSHTMLLinkElementTable , 0 };

JSHTMLLinkElement::JSHTMLLinkElement(PassRefPtr<StructureID> structure, PassRefPtr<HTMLLinkElement> impl)
    : JSHTMLElement(structure, impl)
{
}

JSObject* JSHTMLLinkElement::createPrototype(ExecState* exec)
{
    return new (exec) JSHTMLLinkElementPrototype(JSHTMLLinkElementPrototype::createStructureID(JSHTMLElementPrototype::self(exec)));
}

bool JSHTMLLinkElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLLinkElement, Base>(exec, &JSHTMLLinkElementTable, this, propertyName, slot);
}

JSValue* jsHTMLLinkElementDisabled(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLLinkElement* imp = static_cast<HTMLLinkElement*>(static_cast<JSHTMLLinkElement*>(slot.slotBase())->impl());
    return jsBoolean(imp->disabled());
}

JSValue* jsHTMLLinkElementCharset(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLLinkElement* imp = static_cast<HTMLLinkElement*>(static_cast<JSHTMLLinkElement*>(slot.slotBase())->impl());
    return jsString(exec, imp->charset());
}

JSValue* jsHTMLLinkElementHref(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLLinkElement* imp = static_cast<HTMLLinkElement*>(static_cast<JSHTMLLinkElement*>(slot.slotBase())->impl());
    return jsString(exec, imp->href());
}

JSValue* jsHTMLLinkElementHreflang(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLLinkElement* imp = static_cast<HTMLLinkElement*>(static_cast<JSHTMLLinkElement*>(slot.slotBase())->impl());
    return jsString(exec, imp->hreflang());
}

JSValue* jsHTMLLinkElementMedia(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLLinkElement* imp = static_cast<HTMLLinkElement*>(static_cast<JSHTMLLinkElement*>(slot.slotBase())->impl());
    return jsString(exec, imp->media());
}

JSValue* jsHTMLLinkElementRel(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLLinkElement* imp = static_cast<HTMLLinkElement*>(static_cast<JSHTMLLinkElement*>(slot.slotBase())->impl());
    return jsString(exec, imp->rel());
}

JSValue* jsHTMLLinkElementRev(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLLinkElement* imp = static_cast<HTMLLinkElement*>(static_cast<JSHTMLLinkElement*>(slot.slotBase())->impl());
    return jsString(exec, imp->rev());
}

JSValue* jsHTMLLinkElementTarget(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLLinkElement* imp = static_cast<HTMLLinkElement*>(static_cast<JSHTMLLinkElement*>(slot.slotBase())->impl());
    return jsString(exec, imp->target());
}

JSValue* jsHTMLLinkElementType(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLLinkElement* imp = static_cast<HTMLLinkElement*>(static_cast<JSHTMLLinkElement*>(slot.slotBase())->impl());
    return jsString(exec, imp->type());
}

JSValue* jsHTMLLinkElementSheet(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLLinkElement* imp = static_cast<HTMLLinkElement*>(static_cast<JSHTMLLinkElement*>(slot.slotBase())->impl());
    return toJS(exec, WTF::getPtr(imp->sheet()));
}

JSValue* jsHTMLLinkElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSHTMLLinkElement*>(slot.slotBase())->getConstructor(exec);
}
void JSHTMLLinkElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value, PutPropertySlot& slot)
{
    lookupPut<JSHTMLLinkElement, Base>(exec, propertyName, value, &JSHTMLLinkElementTable, this, slot);
}

void setJSHTMLLinkElementDisabled(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLLinkElement* imp = static_cast<HTMLLinkElement*>(static_cast<JSHTMLLinkElement*>(thisObject)->impl());
    imp->setDisabled(value->toBoolean(exec));
}

void setJSHTMLLinkElementCharset(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLLinkElement* imp = static_cast<HTMLLinkElement*>(static_cast<JSHTMLLinkElement*>(thisObject)->impl());
    imp->setCharset(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLLinkElementHref(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLLinkElement* imp = static_cast<HTMLLinkElement*>(static_cast<JSHTMLLinkElement*>(thisObject)->impl());
    imp->setHref(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLLinkElementHreflang(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLLinkElement* imp = static_cast<HTMLLinkElement*>(static_cast<JSHTMLLinkElement*>(thisObject)->impl());
    imp->setHreflang(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLLinkElementMedia(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLLinkElement* imp = static_cast<HTMLLinkElement*>(static_cast<JSHTMLLinkElement*>(thisObject)->impl());
    imp->setMedia(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLLinkElementRel(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLLinkElement* imp = static_cast<HTMLLinkElement*>(static_cast<JSHTMLLinkElement*>(thisObject)->impl());
    imp->setRel(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLLinkElementRev(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLLinkElement* imp = static_cast<HTMLLinkElement*>(static_cast<JSHTMLLinkElement*>(thisObject)->impl());
    imp->setRev(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLLinkElementTarget(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLLinkElement* imp = static_cast<HTMLLinkElement*>(static_cast<JSHTMLLinkElement*>(thisObject)->impl());
    imp->setTarget(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLLinkElementType(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLLinkElement* imp = static_cast<HTMLLinkElement*>(static_cast<JSHTMLLinkElement*>(thisObject)->impl());
    imp->setType(valueToStringWithNullCheck(exec, value));
}

JSValue* JSHTMLLinkElement::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSHTMLLinkElementConstructor>(exec);
}


}
