/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSHTMLHeadElement.h"

#include <wtf/GetPtr.h>

#include "HTMLHeadElement.h"
#include "KURL.h"

#include <kjs/JSNumberCell.h>
#include <kjs/JSString.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHTMLHeadElement)

/* Hash table */

static const HashTableValue JSHTMLHeadElementTableValues[3] =
{
    { "profile", DontDelete, (intptr_t)jsHTMLHeadElementProfile, (intptr_t)setJSHTMLHeadElementProfile },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsHTMLHeadElementConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLHeadElementTable = { 7, JSHTMLHeadElementTableValues, 0 };

/* Hash table for constructor */

static const HashTableValue JSHTMLHeadElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLHeadElementConstructorTable = { 0, JSHTMLHeadElementConstructorTableValues, 0 };

class JSHTMLHeadElementConstructor : public DOMObject {
public:
    JSHTMLHeadElementConstructor(ExecState* exec)
        : DOMObject(JSHTMLHeadElementConstructor::createStructureID(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSHTMLHeadElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<StructureID> createStructureID(JSValue* proto) 
    { 
        return StructureID::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSHTMLHeadElementConstructor::s_info = { "HTMLHeadElementConstructor", 0, &JSHTMLHeadElementConstructorTable, 0 };

bool JSHTMLHeadElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLHeadElementConstructor, DOMObject>(exec, &JSHTMLHeadElementConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLHeadElementPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLHeadElementPrototypeTable = { 0, JSHTMLHeadElementPrototypeTableValues, 0 };

const ClassInfo JSHTMLHeadElementPrototype::s_info = { "HTMLHeadElementPrototype", 0, &JSHTMLHeadElementPrototypeTable, 0 };

JSObject* JSHTMLHeadElementPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSHTMLHeadElement>(exec);
}

const ClassInfo JSHTMLHeadElement::s_info = { "HTMLHeadElement", &JSHTMLElement::s_info, &JSHTMLHeadElementTable , 0 };

JSHTMLHeadElement::JSHTMLHeadElement(PassRefPtr<StructureID> structure, PassRefPtr<HTMLHeadElement> impl)
    : JSHTMLElement(structure, impl)
{
}

JSObject* JSHTMLHeadElement::createPrototype(ExecState* exec)
{
    return new (exec) JSHTMLHeadElementPrototype(JSHTMLHeadElementPrototype::createStructureID(JSHTMLElementPrototype::self(exec)));
}

bool JSHTMLHeadElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLHeadElement, Base>(exec, &JSHTMLHeadElementTable, this, propertyName, slot);
}

JSValue* jsHTMLHeadElementProfile(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLHeadElement* imp = static_cast<HTMLHeadElement*>(static_cast<JSHTMLHeadElement*>(slot.slotBase())->impl());
    return jsString(exec, imp->profile());
}

JSValue* jsHTMLHeadElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSHTMLHeadElement*>(slot.slotBase())->getConstructor(exec);
}
void JSHTMLHeadElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value, PutPropertySlot& slot)
{
    lookupPut<JSHTMLHeadElement, Base>(exec, propertyName, value, &JSHTMLHeadElementTable, this, slot);
}

void setJSHTMLHeadElementProfile(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLHeadElement* imp = static_cast<HTMLHeadElement*>(static_cast<JSHTMLHeadElement*>(thisObject)->impl());
    imp->setProfile(valueToStringWithNullCheck(exec, value));
}

JSValue* JSHTMLHeadElement::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSHTMLHeadElementConstructor>(exec);
}


}
