/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSFile.h"

#include <wtf/GetPtr.h>

#include "File.h"
#include "KURL.h"

#include <kjs/JSNumberCell.h>
#include <kjs/JSString.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSFile)

/* Hash table */

static const HashTableValue JSFileTableValues[4] =
{
    { "fileName", DontDelete|ReadOnly, (intptr_t)jsFileFileName, (intptr_t)0 },
    { "fileSize", DontDelete|ReadOnly, (intptr_t)jsFileFileSize, (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsFileConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSFileTable = { 7, JSFileTableValues, 0 };

/* Hash table for constructor */

static const HashTableValue JSFileConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSFileConstructorTable = { 0, JSFileConstructorTableValues, 0 };

class JSFileConstructor : public DOMObject {
public:
    JSFileConstructor(ExecState* exec)
        : DOMObject(JSFileConstructor::createStructureID(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSFilePrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<StructureID> createStructureID(JSValue* proto) 
    { 
        return StructureID::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSFileConstructor::s_info = { "FileConstructor", 0, &JSFileConstructorTable, 0 };

bool JSFileConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSFileConstructor, DOMObject>(exec, &JSFileConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSFilePrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSFilePrototypeTable = { 0, JSFilePrototypeTableValues, 0 };

const ClassInfo JSFilePrototype::s_info = { "FilePrototype", 0, &JSFilePrototypeTable, 0 };

JSObject* JSFilePrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSFile>(exec);
}

const ClassInfo JSFile::s_info = { "File", 0, &JSFileTable , 0 };

JSFile::JSFile(PassRefPtr<StructureID> structure, PassRefPtr<File> impl)
    : DOMObject(structure)
    , m_impl(impl)
{
}

JSFile::~JSFile()
{
    forgetDOMObject(*Heap::heap(this)->globalData(), m_impl.get());

}

JSObject* JSFile::createPrototype(ExecState* exec)
{
    return new (exec) JSFilePrototype(JSFilePrototype::createStructureID(exec->lexicalGlobalObject()->objectPrototype()));
}

bool JSFile::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSFile, Base>(exec, &JSFileTable, this, propertyName, slot);
}

JSValue* jsFileFileName(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    File* imp = static_cast<File*>(static_cast<JSFile*>(slot.slotBase())->impl());
    return jsString(exec, imp->fileName());
}

JSValue* jsFileFileSize(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    File* imp = static_cast<File*>(static_cast<JSFile*>(slot.slotBase())->impl());
    return jsNumber(exec, imp->fileSize());
}

JSValue* jsFileConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSFile*>(slot.slotBase())->getConstructor(exec);
}
JSValue* JSFile::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSFileConstructor>(exec);
}

JSC::JSValue* toJS(JSC::ExecState* exec, File* object)
{
    return getDOMObjectWrapper<JSFile>(exec, object);
}
File* toFile(JSC::JSValue* val)
{
    return val->isObject(&JSFile::s_info) ? static_cast<JSFile*>(val)->impl() : 0;
}

}
