/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSDOMCoreException.h"

#include <wtf/GetPtr.h>

#include "DOMCoreException.h"
#include "KURL.h"

#include <kjs/Error.h>
#include <kjs/JSNumberCell.h>
#include <kjs/JSString.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSDOMCoreException)

/* Hash table */

static const HashTableValue JSDOMCoreExceptionTableValues[5] =
{
    { "code", DontDelete|ReadOnly, (intptr_t)jsDOMCoreExceptionCode, (intptr_t)0 },
    { "name", DontDelete|ReadOnly, (intptr_t)jsDOMCoreExceptionName, (intptr_t)0 },
    { "message", DontDelete|ReadOnly, (intptr_t)jsDOMCoreExceptionMessage, (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsDOMCoreExceptionConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSDOMCoreExceptionTable = { 127, JSDOMCoreExceptionTableValues, 0 };

/* Hash table for constructor */

static const HashTableValue JSDOMCoreExceptionConstructorTableValues[18] =
{
    { "INDEX_SIZE_ERR", DontDelete|ReadOnly, (intptr_t)jsDOMCoreExceptionINDEX_SIZE_ERR, (intptr_t)0 },
    { "DOMSTRING_SIZE_ERR", DontDelete|ReadOnly, (intptr_t)jsDOMCoreExceptionDOMSTRING_SIZE_ERR, (intptr_t)0 },
    { "HIERARCHY_REQUEST_ERR", DontDelete|ReadOnly, (intptr_t)jsDOMCoreExceptionHIERARCHY_REQUEST_ERR, (intptr_t)0 },
    { "WRONG_DOCUMENT_ERR", DontDelete|ReadOnly, (intptr_t)jsDOMCoreExceptionWRONG_DOCUMENT_ERR, (intptr_t)0 },
    { "INVALID_CHARACTER_ERR", DontDelete|ReadOnly, (intptr_t)jsDOMCoreExceptionINVALID_CHARACTER_ERR, (intptr_t)0 },
    { "NO_DATA_ALLOWED_ERR", DontDelete|ReadOnly, (intptr_t)jsDOMCoreExceptionNO_DATA_ALLOWED_ERR, (intptr_t)0 },
    { "NO_MODIFICATION_ALLOWED_ERR", DontDelete|ReadOnly, (intptr_t)jsDOMCoreExceptionNO_MODIFICATION_ALLOWED_ERR, (intptr_t)0 },
    { "NOT_FOUND_ERR", DontDelete|ReadOnly, (intptr_t)jsDOMCoreExceptionNOT_FOUND_ERR, (intptr_t)0 },
    { "NOT_SUPPORTED_ERR", DontDelete|ReadOnly, (intptr_t)jsDOMCoreExceptionNOT_SUPPORTED_ERR, (intptr_t)0 },
    { "INUSE_ATTRIBUTE_ERR", DontDelete|ReadOnly, (intptr_t)jsDOMCoreExceptionINUSE_ATTRIBUTE_ERR, (intptr_t)0 },
    { "INVALID_STATE_ERR", DontDelete|ReadOnly, (intptr_t)jsDOMCoreExceptionINVALID_STATE_ERR, (intptr_t)0 },
    { "SYNTAX_ERR", DontDelete|ReadOnly, (intptr_t)jsDOMCoreExceptionSYNTAX_ERR, (intptr_t)0 },
    { "INVALID_MODIFICATION_ERR", DontDelete|ReadOnly, (intptr_t)jsDOMCoreExceptionINVALID_MODIFICATION_ERR, (intptr_t)0 },
    { "NAMESPACE_ERR", DontDelete|ReadOnly, (intptr_t)jsDOMCoreExceptionNAMESPACE_ERR, (intptr_t)0 },
    { "INVALID_ACCESS_ERR", DontDelete|ReadOnly, (intptr_t)jsDOMCoreExceptionINVALID_ACCESS_ERR, (intptr_t)0 },
    { "VALIDATION_ERR", DontDelete|ReadOnly, (intptr_t)jsDOMCoreExceptionVALIDATION_ERR, (intptr_t)0 },
    { "TYPE_MISMATCH_ERR", DontDelete|ReadOnly, (intptr_t)jsDOMCoreExceptionTYPE_MISMATCH_ERR, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSDOMCoreExceptionConstructorTable = { 511, JSDOMCoreExceptionConstructorTableValues, 0 };

class JSDOMCoreExceptionConstructor : public DOMObject {
public:
    JSDOMCoreExceptionConstructor(ExecState* exec)
        : DOMObject(JSDOMCoreExceptionConstructor::createStructureID(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSDOMCoreExceptionPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<StructureID> createStructureID(JSValue* proto) 
    { 
        return StructureID::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSDOMCoreExceptionConstructor::s_info = { "DOMExceptionConstructor", 0, &JSDOMCoreExceptionConstructorTable, 0 };

bool JSDOMCoreExceptionConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSDOMCoreExceptionConstructor, DOMObject>(exec, &JSDOMCoreExceptionConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSDOMCoreExceptionPrototypeTableValues[19] =
{
    { "INDEX_SIZE_ERR", DontDelete|ReadOnly, (intptr_t)jsDOMCoreExceptionINDEX_SIZE_ERR, (intptr_t)0 },
    { "DOMSTRING_SIZE_ERR", DontDelete|ReadOnly, (intptr_t)jsDOMCoreExceptionDOMSTRING_SIZE_ERR, (intptr_t)0 },
    { "HIERARCHY_REQUEST_ERR", DontDelete|ReadOnly, (intptr_t)jsDOMCoreExceptionHIERARCHY_REQUEST_ERR, (intptr_t)0 },
    { "WRONG_DOCUMENT_ERR", DontDelete|ReadOnly, (intptr_t)jsDOMCoreExceptionWRONG_DOCUMENT_ERR, (intptr_t)0 },
    { "INVALID_CHARACTER_ERR", DontDelete|ReadOnly, (intptr_t)jsDOMCoreExceptionINVALID_CHARACTER_ERR, (intptr_t)0 },
    { "NO_DATA_ALLOWED_ERR", DontDelete|ReadOnly, (intptr_t)jsDOMCoreExceptionNO_DATA_ALLOWED_ERR, (intptr_t)0 },
    { "NO_MODIFICATION_ALLOWED_ERR", DontDelete|ReadOnly, (intptr_t)jsDOMCoreExceptionNO_MODIFICATION_ALLOWED_ERR, (intptr_t)0 },
    { "NOT_FOUND_ERR", DontDelete|ReadOnly, (intptr_t)jsDOMCoreExceptionNOT_FOUND_ERR, (intptr_t)0 },
    { "NOT_SUPPORTED_ERR", DontDelete|ReadOnly, (intptr_t)jsDOMCoreExceptionNOT_SUPPORTED_ERR, (intptr_t)0 },
    { "INUSE_ATTRIBUTE_ERR", DontDelete|ReadOnly, (intptr_t)jsDOMCoreExceptionINUSE_ATTRIBUTE_ERR, (intptr_t)0 },
    { "INVALID_STATE_ERR", DontDelete|ReadOnly, (intptr_t)jsDOMCoreExceptionINVALID_STATE_ERR, (intptr_t)0 },
    { "SYNTAX_ERR", DontDelete|ReadOnly, (intptr_t)jsDOMCoreExceptionSYNTAX_ERR, (intptr_t)0 },
    { "INVALID_MODIFICATION_ERR", DontDelete|ReadOnly, (intptr_t)jsDOMCoreExceptionINVALID_MODIFICATION_ERR, (intptr_t)0 },
    { "NAMESPACE_ERR", DontDelete|ReadOnly, (intptr_t)jsDOMCoreExceptionNAMESPACE_ERR, (intptr_t)0 },
    { "INVALID_ACCESS_ERR", DontDelete|ReadOnly, (intptr_t)jsDOMCoreExceptionINVALID_ACCESS_ERR, (intptr_t)0 },
    { "VALIDATION_ERR", DontDelete|ReadOnly, (intptr_t)jsDOMCoreExceptionVALIDATION_ERR, (intptr_t)0 },
    { "TYPE_MISMATCH_ERR", DontDelete|ReadOnly, (intptr_t)jsDOMCoreExceptionTYPE_MISMATCH_ERR, (intptr_t)0 },
    { "toString", DontDelete|DontEnum|Function, (intptr_t)jsDOMCoreExceptionPrototypeFunctionToString, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSDOMCoreExceptionPrototypeTable = { 511, JSDOMCoreExceptionPrototypeTableValues, 0 };

const ClassInfo JSDOMCoreExceptionPrototype::s_info = { "DOMExceptionPrototype", 0, &JSDOMCoreExceptionPrototypeTable, 0 };

JSObject* JSDOMCoreExceptionPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSDOMCoreException>(exec);
}

bool JSDOMCoreExceptionPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticPropertySlot<JSDOMCoreExceptionPrototype, JSObject>(exec, &JSDOMCoreExceptionPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSDOMCoreException::s_info = { "DOMException", 0, &JSDOMCoreExceptionTable , 0 };

JSDOMCoreException::JSDOMCoreException(PassRefPtr<StructureID> structure, PassRefPtr<DOMCoreException> impl)
    : DOMObject(structure)
    , m_impl(impl)
{
}

JSDOMCoreException::~JSDOMCoreException()
{
    forgetDOMObject(*Heap::heap(this)->globalData(), m_impl.get());

}

JSObject* JSDOMCoreException::createPrototype(ExecState* exec)
{
    return new (exec) JSDOMCoreExceptionPrototype(JSDOMCoreExceptionPrototype::createStructureID(exec->lexicalGlobalObject()->objectPrototype()));
}

bool JSDOMCoreException::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSDOMCoreException, Base>(exec, &JSDOMCoreExceptionTable, this, propertyName, slot);
}

JSValue* jsDOMCoreExceptionCode(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    DOMCoreException* imp = static_cast<DOMCoreException*>(static_cast<JSDOMCoreException*>(slot.slotBase())->impl());
    return jsNumber(exec, imp->code());
}

JSValue* jsDOMCoreExceptionName(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    DOMCoreException* imp = static_cast<DOMCoreException*>(static_cast<JSDOMCoreException*>(slot.slotBase())->impl());
    return jsString(exec, imp->name());
}

JSValue* jsDOMCoreExceptionMessage(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    DOMCoreException* imp = static_cast<DOMCoreException*>(static_cast<JSDOMCoreException*>(slot.slotBase())->impl());
    return jsString(exec, imp->message());
}

JSValue* jsDOMCoreExceptionConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSDOMCoreException*>(slot.slotBase())->getConstructor(exec);
}
JSValue* JSDOMCoreException::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSDOMCoreExceptionConstructor>(exec);
}

JSValue* jsDOMCoreExceptionPrototypeFunctionToString(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDOMCoreException::s_info))
        return throwError(exec, TypeError);
    JSDOMCoreException* castedThisObj = static_cast<JSDOMCoreException*>(thisValue);
    DOMCoreException* imp = static_cast<DOMCoreException*>(castedThisObj->impl());


    JSC::JSValue* result = jsString(exec, imp->toString());
    return result;
}

// Constant getters

JSValue* jsDOMCoreExceptionINDEX_SIZE_ERR(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(1));
}

JSValue* jsDOMCoreExceptionDOMSTRING_SIZE_ERR(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(2));
}

JSValue* jsDOMCoreExceptionHIERARCHY_REQUEST_ERR(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(3));
}

JSValue* jsDOMCoreExceptionWRONG_DOCUMENT_ERR(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(4));
}

JSValue* jsDOMCoreExceptionINVALID_CHARACTER_ERR(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(5));
}

JSValue* jsDOMCoreExceptionNO_DATA_ALLOWED_ERR(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(6));
}

JSValue* jsDOMCoreExceptionNO_MODIFICATION_ALLOWED_ERR(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(7));
}

JSValue* jsDOMCoreExceptionNOT_FOUND_ERR(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(8));
}

JSValue* jsDOMCoreExceptionNOT_SUPPORTED_ERR(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(9));
}

JSValue* jsDOMCoreExceptionINUSE_ATTRIBUTE_ERR(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(10));
}

JSValue* jsDOMCoreExceptionINVALID_STATE_ERR(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(11));
}

JSValue* jsDOMCoreExceptionSYNTAX_ERR(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(12));
}

JSValue* jsDOMCoreExceptionINVALID_MODIFICATION_ERR(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(13));
}

JSValue* jsDOMCoreExceptionNAMESPACE_ERR(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(14));
}

JSValue* jsDOMCoreExceptionINVALID_ACCESS_ERR(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(15));
}

JSValue* jsDOMCoreExceptionVALIDATION_ERR(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(16));
}

JSValue* jsDOMCoreExceptionTYPE_MISMATCH_ERR(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(17));
}

JSC::JSValue* toJS(JSC::ExecState* exec, DOMCoreException* object)
{
    return getDOMObjectWrapper<JSDOMCoreException>(exec, object);
}
DOMCoreException* toDOMCoreException(JSC::JSValue* val)
{
    return val->isObject(&JSDOMCoreException::s_info) ? static_cast<JSDOMCoreException*>(val)->impl() : 0;
}

}
