/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef JSConsole_h
#define JSConsole_h

#include "JSDOMBinding.h"
#include <kjs/JSGlobalObject.h>
#include <kjs/ObjectPrototype.h>

namespace WebCore {

class Console;

class JSConsole : public DOMObject {
    typedef DOMObject Base;
public:
    JSConsole(PassRefPtr<JSC::StructureID>, PassRefPtr<Console>);
    virtual ~JSConsole();
    static JSC::JSObject* createPrototype(JSC::ExecState*);
    virtual const JSC::ClassInfo* classInfo() const { return &s_info; }
    static const JSC::ClassInfo s_info;


    // Custom functions
    JSC::JSValue* debug(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue* error(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue* info(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue* log(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue* warn(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue* dir(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue* dirxml(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue* trace(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue* assertCondition(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue* count(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue* profile(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue* profileEnd(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue* timeEnd(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue* group(JSC::ExecState*, const JSC::ArgList&);
    Console* impl() const { return m_impl.get(); }

private:
    RefPtr<Console> m_impl;
};

JSC::JSValue* toJS(JSC::ExecState*, Console*);
Console* toConsole(JSC::JSValue*);

class JSConsolePrototype : public JSC::JSObject {
public:
    static JSC::JSObject* self(JSC::ExecState*);
    virtual const JSC::ClassInfo* classInfo() const { return &s_info; }
    static const JSC::ClassInfo s_info;
    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    JSConsolePrototype(PassRefPtr<JSC::StructureID> structure) : JSC::JSObject(structure) { }
};

// Functions

JSC::JSValue* jsConsolePrototypeFunctionDebug(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
JSC::JSValue* jsConsolePrototypeFunctionError(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
JSC::JSValue* jsConsolePrototypeFunctionInfo(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
JSC::JSValue* jsConsolePrototypeFunctionLog(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
JSC::JSValue* jsConsolePrototypeFunctionWarn(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
JSC::JSValue* jsConsolePrototypeFunctionDir(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
JSC::JSValue* jsConsolePrototypeFunctionDirxml(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
JSC::JSValue* jsConsolePrototypeFunctionTrace(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
JSC::JSValue* jsConsolePrototypeFunctionAssert(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
JSC::JSValue* jsConsolePrototypeFunctionCount(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
JSC::JSValue* jsConsolePrototypeFunctionProfile(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
JSC::JSValue* jsConsolePrototypeFunctionProfileEnd(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
JSC::JSValue* jsConsolePrototypeFunctionTime(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
JSC::JSValue* jsConsolePrototypeFunctionTimeEnd(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
JSC::JSValue* jsConsolePrototypeFunctionGroup(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
JSC::JSValue* jsConsolePrototypeFunctionGroupEnd(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);

} // namespace WebCore

#endif
