/****************************************************************************
**
** Copyright (C) 2008 Nokia Corporation and/or its subsidiary(-ies).
** Contact: Qt Software Information (qt-info@nokia.com)
**
** This file is part of the example classes of the Qt Toolkit.
**
** No Commercial Usage
** This file contains pre-release code and may only be used for
** evaluation and testing purposes.  It may not be used for commercial
** development.  You may use this file in accordance with the terms and
** conditions contained in the either Technology Preview License
** Agreement or the Beta Release License Agreement.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License versions 2.0 or 3.0 as published by the Free
** Software Foundation and appearing in the file LICENSE.GPL included in
** the packaging of this file.  Please review the following information
** to ensure GNU General Public Licensing requirements will be met:
** http://www.fsf.org/licensing/licenses/info/GPLv2.html and
** http://www.gnu.org/copyleft/gpl.html.  In addition, as a special
** exception, Nokia gives you certain additional rights. These rights
** are described in the Nokia Qt GPL Exception version 1.3, included in
** the file GPL_EXCEPTION.txt in this package.
**
** Qt for Windows(R) Licensees
** As a special exception, Nokia, as the sole copyright holder for Qt
** Designer, grants users of the Qt/Eclipse Integration plug-in the
** right for the Qt/Eclipse Integration to link to functionality
** provided by Qt Designer and its related libraries.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at qt-sales@nokia.com.
**
****************************************************************************/

#ifndef ENVIRONMENT_H
#define ENVIRONMENT_H

#include <qobject.h>
#include <qlist.h>
#include <qhash.h>
#include <QTimerEvent>
#include <QMouseEvent>
#include <QKeyEvent>
#include <QScriptEngine>
#include <QScriptable>
class QContext2DCanvas;

//! [0]
class Environment : public QObject
{
    Q_OBJECT
    Q_PROPERTY(QScriptValue document READ document)
public:
    Environment(QObject *parent = 0);
    ~Environment();

    QScriptValue document() const;

    void addCanvas(QContext2DCanvas *canvas);
    QContext2DCanvas *canvasByName(const QString &name) const;
    QList<QContext2DCanvas*> canvases() const;

    QScriptValue evaluate(const QString &code,
                          const QString &fileName = QString());

    QScriptValue toWrapper(QObject *object);

    void handleEvent(QContext2DCanvas *canvas, QMouseEvent *e);
    void handleEvent(QContext2DCanvas *canvas, QKeyEvent *e);

    void reset();
//! [0]

    QScriptEngine *engine() const;

//! [1]
public slots:
    int setInterval(const QScriptValue &expression, int delay);
    void clearInterval(int timerId);

    int setTimeout(const QScriptValue &expression, int delay);
    void clearTimeout(int timerId);
//! [1]

//! [2]
signals:
    void scriptError(const QScriptValue &error);
//! [2]

protected:
    void timerEvent(QTimerEvent *event);

private:
    QScriptValue eventHandler(QContext2DCanvas *canvas,
                              const QString &type, QScriptValue *who);
    QScriptValue newFakeDomEvent(const QString &type,
                                 const QScriptValue &target);
    void maybeEmitScriptError();

    QScriptEngine *m_engine;
    QScriptValue m_originalGlobalObject;
    QScriptValue m_document;
    QList<QContext2DCanvas*> m_canvases;
    QHash<int, QScriptValue> m_intervalHash;
    QHash<int, QScriptValue> m_timeoutHash;
};

//! [3]
class Document : public QObject
{
    Q_OBJECT
public:
    Document(Environment *env);
    ~Document();

public slots:
    QScriptValue getElementById(const QString &id) const;
    QScriptValue getElementsByTagName(const QString &name) const;

    // EventTarget
    void addEventListener(const QString &type, const QScriptValue &listener,
                          bool useCapture);
};
//! [3]

class CanvasGradientPrototype : public QObject, public QScriptable
{
    Q_OBJECT
protected:
    CanvasGradientPrototype(QObject *parent = 0);
public:
    static void setup(QScriptEngine *engine);

public slots:
    void addColorStop(qreal offset, const QString &color);
};

#endif
