/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** Contact: Qt Software Information (qt-info@nokia.com)
**
** This file is part of the QtScriptTools module of the Qt Toolkit.
**
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the either Technology Preview License Agreement or the
** Beta Release License Agreement.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License versions 2.0 or 3.0 as published by the Free
** Software Foundation and appearing in the file LICENSE.GPL included in
** the packaging of this file.  Please review the following information
** to ensure GNU General Public Licensing requirements will be met:
** http://www.fsf.org/licensing/licenses/info/GPLv2.html and
** http://www.gnu.org/copyleft/gpl.html.  In addition, as a special
** exception, Nokia gives you certain additional rights. These rights
** are described in the Nokia Qt GPL Exception version 1.3, included in
** the file GPL_EXCEPTION.txt in this package.
**
** Qt for Windows(R) Licensees
** As a special exception, Nokia, as the sole copyright holder for Qt
** Designer, grants users of the Qt/Eclipse Integration plug-in the
** right for the Qt/Eclipse Integration to link to functionality
** provided by Qt Designer and its related libraries.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at qt-sales@nokia.com.
**
****************************************************************************/

#include "qscriptxmlparser_p.h"

#include <QtCore/qstringlist.h>
#include <QtCore/qxmlstream.h>
#include <QtCore/qdebug.h>

QT_BEGIN_NAMESPACE

static void tokenUntil(QXmlStreamReader &reader, QXmlStreamReader::TokenType target,
                       QList<int> &lineNumbers)
{
    int level = 0;
    while (!reader.atEnd()) {
        QXmlStreamReader::TokenType t = reader.readNext();
        if ((t == target) && (level == 0))
            return;
        if (t == QXmlStreamReader::StartElement) {
            ++level;
            QString line = reader.attributes().value(QLatin1String("line")).toString();
            if (!line.isEmpty())
                lineNumbers.append(line.toInt());
        } else if (t == QXmlStreamReader::EndElement) {
            --level;
        }
    }
//    Q_ASSERT_X(false, "QScriptXmlParser", "premature end of file");
}

QScriptXmlParser::Result QScriptXmlParser::parse(const QString &xml)
{
    QMap<QString, int> functionsInfo;
    QList<int> lineNumbers;
    QXmlStreamReader reader(xml);
    reader.readNext(); // StartDocument
    reader.readNext(); // <program>
    reader.readNext(); // <source-elements>
    while (reader.readNext() == QXmlStreamReader::StartElement) {
//        qDebug() << reader.name().toString();
        int line = reader.attributes().value(QLatin1String("line")).toString().toInt();
        lineNumbers.append(line);
        if (reader.name() == QLatin1String("function-declaration")) {
            // extract the line number, name and formal parameters
            reader.readNext(); // <name>
            reader.readNext(); // Characters
            QString name = reader.text().toString();
            reader.readNext(); // </name>
            reader.readNext(); // <formal-parameter-list>
            QStringList formalParameters;
            while (reader.readNext() == QXmlStreamReader::StartElement) {
                reader.readNext(); // Characters
                formalParameters.append(reader.text().toString());
                reader.readNext(); // </identifier>
            }
            reader.readNext(); // <function-body>
            tokenUntil(reader, QXmlStreamReader::EndElement, lineNumbers);

            QString signature;
            signature.append(name);
            signature.append(QLatin1Char('('));
            for (int i = 0; i < formalParameters.size(); ++i) {
                if (i > 0)
                    signature.append(QLatin1String(", "));
                signature.append(formalParameters.at(i));
            }
            signature.append(QLatin1Char(')'));
            functionsInfo.insert(signature, line);
        } else if (reader.name() == QLatin1String("expression-statement")) {
            reader.readNext();
            if ((reader.name() == QLatin1String("binary-expression"))
                && reader.attributes().value(QLatin1String("op")) == QLatin1String("=")) {
                // try to match a statement of the form Foo.prototype.bar = function() { ... }
                // this can be generalized...
                QString first, second, third;
                reader.readNext(); // LHS
                if (reader.name() == QLatin1String("field-member-expression")) {
                    reader.readNext();
                    if (reader.name() == QLatin1String("field-member-expression")) {
                        reader.readNext();
                        if (reader.name() == QLatin1String("identifier")) {
                            reader.readNext();
                            first = reader.text().toString();
                        }
                        tokenUntil(reader, QXmlStreamReader::EndElement, lineNumbers);
                        reader.readNext();
                        if (reader.name() == QLatin1String("identifier")) {
                            reader.readNext();
                            second = reader.text().toString();
                        }
                        tokenUntil(reader, QXmlStreamReader::EndElement, lineNumbers);
                    } else if (reader.name() == QLatin1String("identifier")) {
                        reader.readNext();
                        first = reader.text().toString();
                    }
                    tokenUntil(reader, QXmlStreamReader::EndElement, lineNumbers);
                    reader.readNext();
                    if (reader.name() == QLatin1String("identifier")) {
                        reader.readNext();
                        if (second.isEmpty())
                            second = reader.text().toString();
                        else
                            third = reader.text().toString();
                    }
                    tokenUntil(reader, QXmlStreamReader::EndElement, lineNumbers);
                }
                tokenUntil(reader, QXmlStreamReader::EndElement, lineNumbers);
                reader.readNext(); // RHS
                if (reader.name() == QLatin1String("function-expression")) {
                    if (!first.isEmpty()) {
                        QString signature = first;
                        if (!second.isEmpty()) {
                            signature.append(QLatin1Char('.'));
                            signature.append(second);
                            if (!third.isEmpty()) {
                                signature.append(QLatin1Char('.'));
                                signature.append(third);
                            }
                        }
                        signature.append(QLatin1String("()"));
                        functionsInfo.insert(signature, line);
                    }
                }
                tokenUntil(reader, QXmlStreamReader::EndElement, lineNumbers);
            }
            tokenUntil(reader, QXmlStreamReader::EndElement, lineNumbers);
        }
        tokenUntil(reader, QXmlStreamReader::EndElement, lineNumbers);
    }
    reader.readNext(); // </source-elements>
    reader.readNext(); // </program>
    reader.readNext(); // EndDocument
    Q_ASSERT(reader.atEnd());
    return Result(functionsInfo, lineNumbers.toSet());
}

QT_END_NAMESPACE
